/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Transformation;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import org.jetbrains.annotations.Nullable;

public class BakedItemModel
implements BakedModel {
    protected final ImmutableList<BakedQuad> quads;
    protected final TextureAtlasSprite particle;
    protected final ImmutableMap<ItemTransforms.TransformType, Transformation> transforms;
    protected final ItemOverrides overrides;
    protected final BakedModel guiModel;
    protected final boolean isSideLit;

    public BakedItemModel(ImmutableList<BakedQuad> quads, TextureAtlasSprite particle, ImmutableMap<ItemTransforms.TransformType, Transformation> transforms, ItemOverrides overrides, boolean untransformed, boolean isSideLit) {
        this.quads = quads;
        this.particle = particle;
        this.transforms = transforms;
        this.overrides = overrides;
        this.isSideLit = isSideLit;
        this.guiModel = untransformed && BakedItemModel.hasGuiIdentity(transforms) ? new BakedGuiItemModel<BakedItemModel>(this) : null;
    }

    private static boolean hasGuiIdentity(ImmutableMap<ItemTransforms.TransformType, Transformation> transforms) {
        Transformation guiTransform = (Transformation)transforms.get((Object)ItemTransforms.TransformType.GUI);
        return guiTransform == null || guiTransform.isIdentity();
    }

    public boolean m_7541_() {
        return true;
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7547_() {
        return this.isSideLit;
    }

    public boolean m_7521_() {
        return false;
    }

    public TextureAtlasSprite m_6160_() {
        return this.particle;
    }

    public ItemOverrides m_7343_() {
        return this.overrides;
    }

    public List<BakedQuad> m_213637_(@Nullable BlockState state, @Nullable Direction side, RandomSource rand) {
        if (side == null) {
            return this.quads;
        }
        return ImmutableList.of();
    }

    public BakedModel handlePerspective(ItemTransforms.TransformType type, PoseStack poseStack) {
        if (type == ItemTransforms.TransformType.GUI && this.guiModel != null) {
            return this.guiModel.handlePerspective(type, poseStack);
        }
        return PerspectiveMapWrapper.handlePerspective((BakedModel)this, this.transforms, type, poseStack);
    }

    public static class BakedGuiItemModel<T extends BakedItemModel>
    extends BakedModelWrapper<T> {
        private final ImmutableList<BakedQuad> quads;

        public BakedGuiItemModel(T originalModel) {
            super(originalModel);
            ImmutableList.Builder builder = ImmutableList.builder();
            for (BakedQuad quad : ((BakedItemModel)originalModel).quads) {
                if (quad.m_111306_() != Direction.SOUTH) continue;
                builder.add((Object)quad);
            }
            this.quads = builder.build();
        }

        @Override
        public List<BakedQuad> m_213637_(@Nullable BlockState state, @Nullable Direction side, RandomSource rand) {
            if (side == null) {
                return this.quads;
            }
            return ImmutableList.of();
        }

        @Override
        public boolean doesHandlePerspectives() {
            return true;
        }

        @Override
        public BakedModel handlePerspective(ItemTransforms.TransformType type, PoseStack poseStack) {
            if (type == ItemTransforms.TransformType.GUI) {
                return PerspectiveMapWrapper.handlePerspective((BakedModel)this, ((BakedItemModel)this.originalModel).transforms, type, poseStack);
            }
            return ((BakedItemModel)this.originalModel).handlePerspective(type, poseStack);
        }
    }
}

