/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.CompositeModelState;
import net.minecraftforge.client.model.IModelBuilder;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.client.model.geometry.IModelGeometryPart;
import net.minecraftforge.client.model.geometry.IMultipartModelGeometry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositeModel
implements IDynamicBakedModel {
    private final ImmutableMap<String, BakedModel> bakedParts;
    private final boolean isAmbientOcclusion;
    private final boolean isGui3d;
    private final boolean isSideLit;
    private final TextureAtlasSprite particle;
    private final ItemOverrides overrides;
    private final ModelState transforms;

    public CompositeModel(boolean isGui3d, boolean isSideLit, boolean isAmbientOcclusion, TextureAtlasSprite particle, ImmutableMap<String, BakedModel> bakedParts, ModelState combinedTransform, ItemOverrides overrides) {
        this.bakedParts = bakedParts;
        this.isAmbientOcclusion = isAmbientOcclusion;
        this.isGui3d = isGui3d;
        this.isSideLit = isSideLit;
        this.particle = particle;
        this.overrides = overrides;
        this.transforms = combinedTransform;
    }

    @Override
    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull IModelData extraData) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        for (Map.Entry entry : this.bakedParts.entrySet()) {
            quads.addAll(((BakedModel)entry.getValue()).getQuads(state, side, rand, CompositeModelData.get(extraData, (String)entry.getKey())));
        }
        return quads;
    }

    @NotNull
    public IModelData getModelData(@NotNull BlockAndTintGetter level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull IModelData modelData) {
        CompositeModelData composite = new CompositeModelData();
        for (Map.Entry entry : this.bakedParts.entrySet()) {
            composite.putSubmodelData((String)entry.getKey(), ((BakedModel)entry.getValue()).getModelData(level, pos, state, ModelDataWrapper.wrap(modelData)));
        }
        return composite;
    }

    public boolean m_7541_() {
        return this.isAmbientOcclusion;
    }

    public boolean m_7539_() {
        return this.isGui3d;
    }

    public boolean m_7547_() {
        return this.isSideLit;
    }

    public boolean m_7521_() {
        return false;
    }

    public TextureAtlasSprite m_6160_() {
        return this.particle;
    }

    public ItemOverrides m_7343_() {
        return this.overrides;
    }

    public boolean doesHandlePerspectives() {
        return true;
    }

    public BakedModel handlePerspective(ItemTransforms.TransformType cameraTransformType, PoseStack poseStack) {
        return PerspectiveMapWrapper.handlePerspective((BakedModel)this, this.transforms, cameraTransformType, poseStack);
    }

    @Nullable
    public BakedModel getPart(String name) {
        return (BakedModel)this.bakedParts.get((Object)name);
    }

    public static class CompositeModelData
    extends ModelDataMap {
        public static final ModelProperty<CompositeModelData> SUBMODEL_DATA = new ModelProperty();
        private final Map<String, IModelData> parts = new HashMap<String, IModelData>();

        public static Optional<CompositeModelData> get(IModelData modelData) {
            return Optional.ofNullable(modelData.getData(SUBMODEL_DATA));
        }

        public static IModelData get(IModelData modelData, String name) {
            return CompositeModelData.get(modelData).map(data -> data.getSubmodelData(name)).orElse(EmptyModelData.INSTANCE);
        }

        public IModelData getSubmodelData(String name) {
            if (this.parts.containsKey(name)) {
                return this.parts.get(name);
            }
            return EmptyModelData.INSTANCE;
        }

        public void putSubmodelData(String name, IModelData data) {
            this.parts.put(name, data);
        }

        @Override
        public boolean hasProperty(ModelProperty<?> prop) {
            return prop == SUBMODEL_DATA || super.hasProperty(prop);
        }

        @Override
        @Nullable
        public <T> T getData(ModelProperty<T> prop) {
            if (prop == SUBMODEL_DATA) {
                return (T)this;
            }
            return super.getData(prop);
        }

        @Override
        @Nullable
        public <T> T setData(ModelProperty<T> prop, T data) {
            if (prop == SUBMODEL_DATA) {
                return (T)this;
            }
            return super.setData(prop, data);
        }
    }

    private static class ModelDataWrapper
    extends ModelDataMap {
        private final IModelData parent;

        public static IModelData wrap(IModelData parent) {
            return new ModelDataWrapper(parent);
        }

        private ModelDataWrapper(IModelData parent) {
            this.parent = parent;
        }

        @Override
        public boolean hasProperty(ModelProperty<?> prop) {
            return super.hasProperty(prop) || this.parent.hasProperty(prop);
        }

        @Override
        @Nullable
        public <T> T getData(ModelProperty<T> prop) {
            return super.hasProperty(prop) ? super.getData(prop) : this.parent.getData(prop);
        }

        @Override
        @Nullable
        public <T> T setData(ModelProperty<T> prop, T data) {
            return super.setData(prop, data);
        }
    }

    public static class Loader
    implements IModelLoader<Geometry> {
        public static final Loader INSTANCE = new Loader();

        private Loader() {
        }

        public void m_6213_(ResourceManager resourceManager) {
        }

        @Override
        public Geometry read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            if (!modelContents.has("parts")) {
                throw new RuntimeException("Composite model requires a \"parts\" element.");
            }
            ImmutableMap.Builder parts = ImmutableMap.builder();
            for (Map.Entry part : modelContents.get("parts").getAsJsonObject().entrySet()) {
                SimpleModelState modelTransform = SimpleModelState.IDENTITY;
                parts.put((Object)((String)part.getKey()), (Object)new Submodel((String)part.getKey(), (BlockModel)deserializationContext.deserialize((JsonElement)part.getValue(), BlockModel.class), modelTransform));
            }
            return new Geometry((ImmutableMap<String, Submodel>)parts.build());
        }
    }

    public static class Geometry
    implements IMultipartModelGeometry<Geometry> {
        private final ImmutableMap<String, Submodel> parts;

        Geometry(ImmutableMap<String, Submodel> parts) {
            this.parts = parts;
        }

        @Override
        public Collection<? extends IModelGeometryPart> getParts() {
            return this.parts.values();
        }

        @Override
        public Optional<? extends IModelGeometryPart> getPart(String name) {
            return Optional.ofNullable((Submodel)this.parts.get((Object)name));
        }

        @Override
        public BakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
            Material particleLocation = owner.resolveTexture("particle");
            TextureAtlasSprite particle = spriteGetter.apply(particleLocation);
            ImmutableMap.Builder bakedParts = ImmutableMap.builder();
            for (Map.Entry part : this.parts.entrySet()) {
                Submodel submodel = (Submodel)part.getValue();
                if (!owner.getPartVisibility(submodel)) continue;
                bakedParts.put((Object)((String)part.getKey()), (Object)submodel.bakeModel(bakery, spriteGetter, modelTransform, modelLocation));
            }
            return new CompositeModel(owner.isShadedInGui(), owner.isSideLit(), owner.useSmoothLighting(), particle, (ImmutableMap<String, BakedModel>)bakedParts.build(), owner.getCombinedTransform(), overrides);
        }

        @Override
        public Collection<Material> getTextures(IModelConfiguration owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
            HashSet<Material> textures = new HashSet<Material>();
            for (Submodel part : this.parts.values()) {
                textures.addAll(part.getTextures(owner, modelGetter, missingTextureErrors));
            }
            return textures;
        }
    }

    private static class Submodel
    implements IModelGeometryPart {
        private final String name;
        private final BlockModel model;
        private final ModelState modelTransform;

        private Submodel(String name, BlockModel model, ModelState modelTransform) {
            this.name = name;
            this.model = model;
            this.modelTransform = modelTransform;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public void addQuads(IModelConfiguration owner, IModelBuilder<?> modelBuilder, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ResourceLocation modelLocation) {
            throw new UnsupportedOperationException("Attempted to call adQuads on a Submodel instance. Please don't.");
        }

        public BakedModel bakeModel(ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ResourceLocation modelLocation) {
            return this.model.m_7611_(bakery, spriteGetter, (ModelState)new CompositeModelState(this.modelTransform, modelTransform, this.modelTransform.m_7538_() || modelTransform.m_7538_()), modelLocation);
        }

        @Override
        public Collection<Material> getTextures(IModelConfiguration owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
            return this.model.m_5500_(modelGetter, missingTextureErrors);
        }
    }
}

