/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Transformation;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import net.minecraftforge.client.model.pipeline.BakedQuadBuilder;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.TRSRTransformer;
import net.minecraftforge.fluids.FluidAttributes;
import org.jetbrains.annotations.Nullable;

public final class FluidModel
implements IModelGeometry<FluidModel> {
    public static final FluidModel WATER = new FluidModel((Fluid)Fluids.f_76193_);
    public static final FluidModel LAVA = new FluidModel((Fluid)Fluids.f_76195_);
    private final Fluid fluid;

    public FluidModel(Fluid fluid) {
        this.fluid = fluid;
    }

    @Override
    public Collection<Material> getTextures(IModelConfiguration owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        return ForgeHooksClient.getFluidMaterials(this.fluid).collect(Collectors.toList());
    }

    @Override
    public BakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
        FluidAttributes attrs = this.fluid.getAttributes();
        return new CachingBakedFluid(modelTransform.m_6189_(), PerspectiveMapWrapper.getTransforms(modelTransform), modelLocation, attrs.getColor(), spriteGetter.apply(ForgeHooksClient.getBlockMaterial(attrs.getStillTexture())), spriteGetter.apply(ForgeHooksClient.getBlockMaterial(attrs.getFlowingTexture())), Optional.ofNullable(attrs.getOverlayTexture()).map(ForgeHooksClient::getBlockMaterial).map(spriteGetter), attrs.isLighterThanAir(), null);
    }

    private static final class CachingBakedFluid
    extends BakedFluid {
        private final LoadingCache<Long, BakedFluid> modelCache = CacheBuilder.newBuilder().maximumSize(200L).build((CacheLoader)new CacheLoader<Long, BakedFluid>(){

            public BakedFluid load(Long key) {
                boolean statePresent = (key & 1L) != 0L;
                key = key >>> 1;
                int[] cornerRound = new int[4];
                for (int i = 0; i < 4; ++i) {
                    cornerRound[i] = (int)(key & 0x3FFL);
                    key = key >>> 10;
                }
                int flowRound = (int)(key & 0x7FFL) - 1024;
                key = key >>> 11;
                boolean[] overlaySides = new boolean[4];
                for (int i = 0; i < 4; ++i) {
                    overlaySides[i] = (key & 1L) != 0L;
                    key = key >>> 1;
                }
                return new BakedFluid(transformation, (ImmutableMap<ItemTransforms.TransformType, Transformation>)transforms, modelLocation, color, still, flowing, overlay, gas, statePresent, cornerRound, flowRound, overlaySides);
            }
        });

        public CachingBakedFluid(Transformation transformation, ImmutableMap<ItemTransforms.TransformType, Transformation> transforms, ResourceLocation modelLocation, int color, TextureAtlasSprite still, TextureAtlasSprite flowing, Optional<TextureAtlasSprite> overlay, boolean gas, Optional<IModelData> stateOption) {
            super(transformation, transforms, modelLocation, color, still, flowing, overlay, gas, stateOption.isPresent(), CachingBakedFluid.getCorners(stateOption), CachingBakedFluid.getFlow(stateOption), CachingBakedFluid.getOverlay(stateOption));
        }

        private static int[] getCorners(Optional<IModelData> stateOption) {
            int[] cornerRound = new int[]{0, 0, 0, 0};
            if (stateOption.isPresent()) {
                IModelData state = stateOption.get();
                for (int i = 0; i < 4; ++i) {
                    Float level = null;
                    cornerRound[i] = Math.round((level == null ? 0.8888889f : level.floatValue()) * 864.0f);
                }
            }
            return cornerRound;
        }

        private static int getFlow(Optional<IModelData> stateOption) {
            Float flow = Float.valueOf(-1000.0f);
            if (stateOption.isPresent() && (flow = null) == null) {
                flow = Float.valueOf(-1000.0f);
            }
            int flowRound = (int)Math.round(Math.toDegrees(flow.floatValue()));
            flowRound = Mth.m_14045_((int)flowRound, (int)-1000, (int)1000);
            return flowRound;
        }

        private static boolean[] getOverlay(Optional<IModelData> stateOption) {
            boolean[] overlaySides = new boolean[4];
            if (stateOption.isPresent()) {
                IModelData state = stateOption.get();
                for (int i = 0; i < 4; ++i) {
                    Boolean overlay = null;
                    if (overlay == null) continue;
                    overlaySides[i] = overlay;
                }
            }
            return overlaySides;
        }

        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, IModelData modelData) {
            if (side != null) {
                int i;
                Optional<IModelData> exState = Optional.of(modelData);
                int[] cornerRound = CachingBakedFluid.getCorners(exState);
                int flowRound = CachingBakedFluid.getFlow(exState);
                boolean[] overlaySides = CachingBakedFluid.getOverlay(exState);
                long key = 0L;
                for (i = 3; i >= 0; --i) {
                    key <<= 1;
                    key |= overlaySides[i] ? 1L : 0L;
                }
                key <<= 11;
                key |= (long)(flowRound + 1024);
                for (i = 3; i >= 0; --i) {
                    key <<= 10;
                    key |= (long)cornerRound[i];
                }
                key <<= 1;
                return ((BakedFluid)this.modelCache.getUnchecked((Object)(key |= 1L))).m_213637_(state, side, rand);
            }
            return super.m_213637_(state, side, rand);
        }
    }

    private static class BakedFluid
    implements BakedModel {
        private static final int[] x = new int[]{0, 0, 1, 1};
        private static final int[] z = new int[]{0, 1, 1, 0};
        private static final float eps = 0.001f;
        protected final Transformation transformation;
        protected final ImmutableMap<ItemTransforms.TransformType, Transformation> transforms;
        protected final ResourceLocation modelLocation;
        protected final int color;
        protected final TextureAtlasSprite still;
        protected final TextureAtlasSprite flowing;
        protected final Optional<TextureAtlasSprite> overlay;
        protected final boolean gas;
        protected final ImmutableMap<Direction, ImmutableList<BakedQuad>> faceQuads;

        public BakedFluid(Transformation transformation, ImmutableMap<ItemTransforms.TransformType, Transformation> transforms, ResourceLocation modelLocation, int color, TextureAtlasSprite still, TextureAtlasSprite flowing, Optional<TextureAtlasSprite> overlay, boolean gas, boolean statePresent, int[] cornerRound, int flowRound, boolean[] sideOverlays) {
            this.transformation = transformation;
            this.transforms = transforms;
            this.modelLocation = modelLocation;
            this.color = color;
            this.still = still;
            this.flowing = flowing;
            this.overlay = overlay;
            this.gas = gas;
            this.faceQuads = this.buildQuads(statePresent, cornerRound, flowRound, sideOverlays);
        }

        private ImmutableMap<Direction, ImmutableList<BakedQuad>> buildQuads(boolean statePresent, int[] cornerRound, int flowRound, boolean[] sideOverlays) {
            EnumMap<Direction, ImmutableList> faceQuads = new EnumMap<Direction, ImmutableList>(Direction.class);
            for (Direction side : Direction.values()) {
                faceQuads.put(side, ImmutableList.of());
            }
            if (statePresent) {
                float[] y = new float[4];
                boolean fullVolume = true;
                for (int i2 = 0; i2 < 4; ++i2) {
                    float value = (float)cornerRound[i2] / 864.0f;
                    if (value < 1.0f) {
                        fullVolume = false;
                    }
                    y[i2] = this.gas ? 1.0f - value : value;
                }
                boolean isFlowing = flowRound > -1000;
                float flow = isFlowing ? (float)Math.toRadians(flowRound) : 0.0f;
                TextureAtlasSprite topSprite = isFlowing ? this.flowing : this.still;
                float scale = isFlowing ? 4.0f : 8.0f;
                float c = Mth.m_14089_((float)flow) * scale;
                float s = Mth.m_14031_((float)flow) * scale;
                Direction top = this.gas ? Direction.DOWN : Direction.UP;
                VertexParameter uv = i -> c * (float)(x[i] * 2 - 1) + s * (float)(z[i] * 2 - 1);
                VertexParameter topX = i -> x[i];
                VertexParameter topY = i -> y[i];
                VertexParameter topZ = i -> z[i];
                VertexParameter topU = i -> 8.0f + uv.get(i);
                VertexParameter topV = i -> 8.0f + uv.get((i + 1) % 4);
                ImmutableList.Builder builder = ImmutableList.builder();
                builder.add((Object)this.buildQuad(top, topSprite, this.gas, false, topX, topY, topZ, topU, topV));
                if (!fullVolume) {
                    builder.add((Object)this.buildQuad(top, topSprite, !this.gas, true, topX, topY, topZ, topU, topV));
                }
                faceQuads.put(top, builder.build());
                Direction bottom = top.m_122424_();
                faceQuads.put(bottom, ImmutableList.of((Object)this.buildQuad(bottom, this.still, this.gas, false, i -> z[i], i -> this.gas ? 1.0f : 0.0f, i -> x[i], i -> z[i] * 16, i -> x[i] * 16)));
                for (int i3 = 0; i3 < 4; ++i3) {
                    Direction side = Direction.m_122407_((int)((5 - i3) % 4));
                    boolean useOverlay = this.overlay.isPresent() && sideOverlays[side.m_122416_()];
                    int si = i3;
                    VertexParameter sideX = j -> x[(si + x[j]) % 4];
                    VertexParameter sideY = j -> z[j] == 0 ? (float)(this.gas ? 1 : 0) : y[(si + x[j]) % 4];
                    VertexParameter sideZ = j -> z[(si + x[j]) % 4];
                    VertexParameter sideU = j -> x[j] * 8;
                    VertexParameter sideV = j -> (this.gas ? sideY.get(j) : 1.0f - sideY.get(j)) * 8.0f;
                    ImmutableList.Builder builder2 = ImmutableList.builder();
                    if (!useOverlay) {
                        builder2.add((Object)this.buildQuad(side, this.flowing, this.gas, true, sideX, sideY, sideZ, sideU, sideV));
                    }
                    builder2.add((Object)this.buildQuad(side, useOverlay ? this.overlay.get() : this.flowing, !this.gas, false, sideX, sideY, sideZ, sideU, sideV));
                    faceQuads.put(side, builder2.build());
                }
            } else {
                faceQuads.put(Direction.SOUTH, ImmutableList.of((Object)this.buildQuad(Direction.UP, this.still, false, false, i -> z[i], i -> x[i], i -> 0.0f, i -> z[i] * 16, i -> x[i] * 16)));
            }
            return ImmutableMap.copyOf(faceQuads);
        }

        private BakedQuad buildQuad(Direction side, TextureAtlasSprite texture, boolean flip, boolean offset, VertexParameter x, VertexParameter y, VertexParameter z, VertexParameter u, VertexParameter v) {
            BakedQuadBuilder builder = new BakedQuadBuilder(texture);
            builder.setQuadOrientation(side);
            builder.setQuadTint(0);
            boolean hasTransform = !this.transformation.isIdentity();
            IVertexConsumer consumer = hasTransform ? new TRSRTransformer(builder, this.transformation) : builder;
            for (int i = 0; i < 4; ++i) {
                int vertex = flip ? 3 - i : i;
                this.putVertex(consumer, side, offset, x.get(vertex), y.get(vertex), z.get(vertex), texture.m_118367_((double)u.get(vertex)), texture.m_118393_((double)v.get(vertex)));
            }
            return builder.build();
        }

        private void putVertex(IVertexConsumer consumer, Direction side, boolean offset, float x, float y, float z, float u, float v) {
            VertexFormat format = DefaultVertexFormat.f_85811_;
            ImmutableList elements = format.m_86023_();
            block6: for (int e = 0; e < elements.size(); ++e) {
                switch (((VertexFormatElement)elements.get(e)).m_86048_()) {
                    case POSITION: {
                        float dx = offset ? (float)side.m_122436_().m_123341_() * 0.001f : 0.0f;
                        float dy = offset ? (float)side.m_122436_().m_123342_() * 0.001f : 0.0f;
                        float dz = offset ? (float)side.m_122436_().m_123343_() * 0.001f : 0.0f;
                        consumer.put(e, x - dx, y - dy, z - dz, 1.0f);
                        continue block6;
                    }
                    case COLOR: {
                        float r = (float)(this.color >> 16 & 0xFF) / 255.0f;
                        float g = (float)(this.color >> 8 & 0xFF) / 255.0f;
                        float b = (float)(this.color & 0xFF) / 255.0f;
                        float a = (float)(this.color >> 24 & 0xFF) / 255.0f;
                        consumer.put(e, r, g, b, a);
                        continue block6;
                    }
                    case NORMAL: {
                        float offX = side.m_122429_();
                        float offY = side.m_122430_();
                        float offZ = side.m_122431_();
                        consumer.put(e, offX, offY, offZ, 0.0f);
                        continue block6;
                    }
                    case UV: {
                        if (((VertexFormatElement)elements.get(e)).m_86049_() == 0) {
                            consumer.put(e, u, v, 0.0f, 1.0f);
                            continue block6;
                        }
                    }
                    default: {
                        consumer.put(e, new float[0]);
                    }
                }
            }
        }

        public boolean m_7541_() {
            return true;
        }

        public boolean m_7539_() {
            return false;
        }

        public boolean m_7547_() {
            return false;
        }

        public boolean m_7521_() {
            return false;
        }

        public TextureAtlasSprite m_6160_() {
            return this.still;
        }

        public List<BakedQuad> m_213637_(@Nullable BlockState state, @Nullable Direction side, RandomSource rand) {
            return side == null ? ImmutableList.of() : (List)this.faceQuads.get((Object)side);
        }

        public ItemOverrides m_7343_() {
            return ItemOverrides.f_111734_;
        }

        public boolean doesHandlePerspectives() {
            return true;
        }

        public BakedModel handlePerspective(ItemTransforms.TransformType type, PoseStack poseStack) {
            return PerspectiveMapWrapper.handlePerspective((BakedModel)this, this.transforms, type, poseStack);
        }

        private static interface VertexParameter {
            public float get(int var1);
        }
    }
}

