/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.collect.Maps;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.client.model.ModelLoadingException;
import net.minecraftforge.fml.Logging;
import net.minecraftforge.logging.ModelLoaderErrorMessage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public final class ForgeModelBakery
extends ModelBakery {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<ResourceLocation, Exception> loadingExceptions = Maps.newHashMap();
    private UnbakedModel missingModel = null;
    private boolean isLoading = false;
    private static ForgeModelBakery instance;
    private static Set<ResourceLocation> specialModels;
    private static final Function<ResourceLocation, UnbakedModel> DEFAULT_MODEL_GETTER;

    @Nullable
    public static ForgeModelBakery instance() {
        return instance;
    }

    public boolean isLoading() {
        return this.isLoading;
    }

    public ForgeModelBakery(ResourceManager manager, BlockColors colours, ProfilerFiller profiler, int maxMipmapLevel) {
        super(manager, colours, false);
        instance = this;
        this.processLoading(profiler, maxMipmapLevel);
    }

    public static void addSpecialModel(ResourceLocation rl) {
        specialModels.add(rl);
    }

    public Set<ResourceLocation> getSpecialModels() {
        return specialModels;
    }

    public static ModelResourceLocation getInventoryVariant(String s) {
        if (s.contains("#")) {
            return new ModelResourceLocation(s);
        }
        return new ModelResourceLocation(s, "inventory");
    }

    protected ResourceLocation getModelLocation(ResourceLocation model) {
        return new ResourceLocation(model.m_135827_(), model.m_135815_() + ".json");
    }

    protected UnbakedModel getMissingModel() {
        if (this.missingModel == null) {
            try {
                this.missingModel = this.m_119341_((ResourceLocation)f_119230_);
            }
            catch (Exception e) {
                throw new RuntimeException("Missing the missing model, this should never happen");
            }
        }
        return this.missingModel;
    }

    public UnbakedModel getModelOrMissing(ResourceLocation location) {
        try {
            return this.m_119341_(location);
        }
        catch (Exception e) {
            return this.getMissingModel();
        }
    }

    public UnbakedModel getModelOrLogError(ResourceLocation location, String error) {
        try {
            return this.m_119341_(location);
        }
        catch (Exception e) {
            LOGGER.error(error, (Throwable)e);
            return this.getMissingModel();
        }
    }

    public void onPostBakeEvent(Map<ResourceLocation, BakedModel> modelRegistry) {
        BakedModel missingModel = modelRegistry.get(f_119230_);
        for (Map.Entry<ResourceLocation, Exception> entry : this.loadingExceptions.entrySet()) {
            if (!(entry.getKey() instanceof ModelResourceLocation)) continue;
            LOGGER.debug(Logging.MODELLOADING, () -> new ModelLoaderErrorMessage((ModelResourceLocation)entry.getKey(), (Exception)entry.getValue()));
            ModelResourceLocation location = (ModelResourceLocation)entry.getKey();
            BakedModel model = modelRegistry.get(location);
            if (model != null) continue;
            modelRegistry.put((ResourceLocation)location, missingModel);
        }
        this.loadingExceptions.clear();
        this.isLoading = false;
    }

    public static Function<Material, TextureAtlasSprite> defaultTextureGetter() {
        return Material::m_119204_;
    }

    public static Function<ResourceLocation, UnbakedModel> defaultModelGetter() {
        return DEFAULT_MODEL_GETTER;
    }

    static {
        specialModels = new HashSet<ResourceLocation>();
        DEFAULT_MODEL_GETTER = rl -> ForgeModelBakery.instance().getModelOrMissing((ResourceLocation)rl);
    }

    public static class ItemLoadingException
    extends ModelLoadingException {
        private final Exception normalException;
        private final Exception blockstateException;

        public ItemLoadingException(String message, Exception normalException, Exception blockstateException) {
            super(message);
            this.normalException = normalException;
            this.blockstateException = blockstateException;
        }
    }

    public static final class White {
        public static final ResourceLocation LOCATION = new ResourceLocation("white");
        private static TextureAtlasSprite instance = null;

        public static final TextureAtlasSprite instance() {
            if (instance == null) {
                instance = new Material(TextureAtlas.f_118259_, LOCATION).m_119204_();
            }
            return instance;
        }
    }
}

