/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Transformation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.BakedItemModel;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;
import org.jetbrains.annotations.Nullable;

public class ItemMultiLayerBakedModel
implements IDynamicBakedModel {
    private final boolean smoothLighting;
    private final boolean shadedInGui;
    private final boolean sideLit;
    private final TextureAtlasSprite particle;
    private final ItemOverrides overrides;
    private final ImmutableList<Pair<BakedModel, RenderType>> layerModels;
    private final ImmutableMap<ItemTransforms.TransformType, Transformation> cameraTransforms;

    public ItemMultiLayerBakedModel(boolean smoothLighting, boolean shadedInGui, boolean sideLit, TextureAtlasSprite particle, ItemOverrides overrides, ImmutableMap<ItemTransforms.TransformType, Transformation> cameraTransforms, ImmutableList<Pair<BakedModel, RenderType>> layerModels) {
        this.smoothLighting = smoothLighting;
        this.shadedInGui = shadedInGui;
        this.sideLit = sideLit;
        this.particle = particle;
        this.overrides = overrides;
        this.layerModels = layerModels;
        this.cameraTransforms = cameraTransforms;
    }

    @Override
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, IModelData modelData) {
        ArrayList quads = Lists.newArrayList();
        this.layerModels.forEach(lm -> quads.addAll(((BakedModel)lm.getFirst()).getQuads(state, side, rand, modelData)));
        return quads;
    }

    public boolean m_7541_() {
        return this.smoothLighting;
    }

    public boolean m_7539_() {
        return this.shadedInGui;
    }

    public boolean m_7547_() {
        return this.sideLit;
    }

    public boolean m_7521_() {
        return false;
    }

    public TextureAtlasSprite m_6160_() {
        return this.particle;
    }

    public ItemOverrides m_7343_() {
        return this.overrides;
    }

    public boolean doesHandlePerspectives() {
        return true;
    }

    public BakedModel handlePerspective(ItemTransforms.TransformType cameraTransformType, PoseStack poseStack) {
        return PerspectiveMapWrapper.handlePerspective((BakedModel)this, this.cameraTransforms, cameraTransformType, poseStack);
    }

    public boolean isLayered() {
        return true;
    }

    public List<Pair<BakedModel, RenderType>> getLayerModels(ItemStack itemStack, boolean fabulous) {
        return this.layerModels;
    }

    public static Builder builder(IModelConfiguration owner, TextureAtlasSprite particle, ItemOverrides overrides, ImmutableMap<ItemTransforms.TransformType, Transformation> cameraTransforms) {
        return new Builder(owner, particle, overrides, cameraTransforms);
    }

    public static class Builder {
        private final ImmutableList.Builder<Pair<BakedModel, RenderType>> builder = ImmutableList.builder();
        private final List<BakedQuad> quads = Lists.newArrayList();
        private final ItemOverrides overrides;
        private final ImmutableMap<ItemTransforms.TransformType, Transformation> cameraTransforms;
        private final IModelConfiguration owner;
        private TextureAtlasSprite particle;
        private RenderType lastRt = null;

        private Builder(IModelConfiguration owner, TextureAtlasSprite particle, ItemOverrides overrides, ImmutableMap<ItemTransforms.TransformType, Transformation> cameraTransforms) {
            this.owner = owner;
            this.particle = particle;
            this.overrides = overrides;
            this.cameraTransforms = cameraTransforms;
        }

        private void addLayer(ImmutableList.Builder<Pair<BakedModel, RenderType>> builder, List<BakedQuad> quads, RenderType rt) {
            BakedItemModel model = new BakedItemModel((ImmutableList<BakedQuad>)ImmutableList.copyOf(quads), this.particle, (ImmutableMap<ItemTransforms.TransformType, Transformation>)ImmutableMap.of(), ItemOverrides.f_111734_, true, this.owner.isSideLit());
            builder.add((Object)Pair.of((Object)model, (Object)rt));
        }

        private void flushQuads(RenderType rt) {
            if (rt != this.lastRt) {
                if (this.quads.size() > 0) {
                    this.addLayer(this.builder, this.quads, this.lastRt);
                    this.quads.clear();
                }
                this.lastRt = rt;
            }
        }

        public Builder setParticle(TextureAtlasSprite particleSprite) {
            this.particle = particleSprite;
            return this;
        }

        public Builder addQuads(RenderType rt, BakedQuad ... quadsToAdd) {
            this.flushQuads(rt);
            Collections.addAll(this.quads, quadsToAdd);
            return this;
        }

        public Builder addQuads(RenderType rt, Collection<BakedQuad> quadsToAdd) {
            this.flushQuads(rt);
            this.quads.addAll(quadsToAdd);
            return this;
        }

        public BakedModel build() {
            if (this.quads.size() > 0) {
                this.addLayer(this.builder, this.quads, this.lastRt);
            }
            return new ItemMultiLayerBakedModel(this.owner.useSmoothLighting(), this.owner.isShadedInGui(), this.owner.isSideLit(), this.particle, this.overrides, this.cameraTransforms, (ImmutableList<Pair<BakedModel, RenderType>>)this.builder.build());
        }
    }
}

