/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.generators.loaders;

import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.model.generators.CustomLoaderBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class DynamicBucketModelBuilder<T extends ModelBuilder<T>>
extends CustomLoaderBuilder<T> {
    private ResourceLocation fluid;
    private Boolean flipGas;
    private Boolean applyTint;
    private Boolean coverIsMask;
    private Boolean applyFluidLuminosity;

    public static <T extends ModelBuilder<T>> DynamicBucketModelBuilder<T> begin(T parent, ExistingFileHelper existingFileHelper) {
        return new DynamicBucketModelBuilder<T>(parent, existingFileHelper);
    }

    protected DynamicBucketModelBuilder(T parent, ExistingFileHelper existingFileHelper) {
        super(new ResourceLocation("forge:bucket"), parent, existingFileHelper);
    }

    public DynamicBucketModelBuilder<T> fluid(Fluid fluid) {
        Preconditions.checkNotNull((Object)fluid, (Object)"fluid must not be null");
        this.fluid = ForgeRegistries.FLUIDS.getKey(fluid);
        return this;
    }

    public DynamicBucketModelBuilder<T> flipGas(boolean flip) {
        this.flipGas = flip;
        return this;
    }

    public DynamicBucketModelBuilder<T> applyTint(boolean tint) {
        this.applyTint = tint;
        return this;
    }

    public DynamicBucketModelBuilder<T> coverIsMask(boolean coverIsMask) {
        this.coverIsMask = coverIsMask;
        return this;
    }

    public DynamicBucketModelBuilder<T> applyFluidLuminosity(boolean applyFluidLuminosity) {
        this.applyFluidLuminosity = applyFluidLuminosity;
        return this;
    }

    @Override
    public JsonObject toJson(JsonObject json) {
        json = super.toJson(json);
        Preconditions.checkNotNull((Object)this.fluid, (Object)"fluid must not be null");
        json.addProperty("fluid", this.fluid.toString());
        if (this.flipGas != null) {
            json.addProperty("flipGas", this.flipGas);
        }
        if (this.applyTint != null) {
            json.addProperty("applyTint", this.applyTint);
        }
        if (this.coverIsMask != null) {
            json.addProperty("coverIsMask", this.coverIsMask);
        }
        if (this.applyFluidLuminosity != null) {
            json.addProperty("applyFluidLuminosity", this.applyFluidLuminosity);
        }
        return json;
    }
}

