/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.renderable;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Arrays;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.renderable.IRenderable;

public class BakedRenderable
implements IRenderable<IModelData> {
    private static final Direction[] MODEL_FACINGS = Arrays.copyOf(Direction.values(), Direction.values().length + 1);
    private final RandomSource rand = RandomSource.m_216327_();
    private final BakedModel model;

    public static BakedRenderable of(ResourceLocation model) {
        return BakedRenderable.of(Minecraft.m_91087_().m_91304_().getModel(model));
    }

    public static BakedRenderable of(BakedModel model) {
        return new BakedRenderable(model);
    }

    private BakedRenderable(BakedModel model) {
        this.model = model;
    }

    @Override
    public void render(PoseStack poseStack, MultiBufferSource bufferSource, Function<ResourceLocation, RenderType> renderTypeFunction, int lightmapCoord, int overlayCoord, float partialTicks, IModelData renderValues) {
        RenderType rt = renderTypeFunction.apply(InventoryMenu.f_39692_);
        VertexConsumer bb = bufferSource.m_6299_(rt);
        for (Direction direction : MODEL_FACINGS) {
            for (BakedQuad quad : this.model.getQuads(null, direction, this.rand, renderValues)) {
                bb.putBulkData(poseStack.m_85850_(), quad, 1.0f, 1.0f, 1.0f, 1.0f, lightmapCoord, overlayCoord, true);
            }
        }
    }
}

