/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.Logging;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.logging.log4j.LogManager;

public class ForgeConfig {
    static final ForgeConfigSpec clientSpec;
    public static final Client CLIENT;
    static final ForgeConfigSpec commonSpec;
    public static final Common COMMON;
    static final ForgeConfigSpec serverSpec;
    public static final Server SERVER;

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading configEvent) {
        LogManager.getLogger().debug(Logging.FORGEMOD, "Loaded forge config file {}", (Object)configEvent.getConfig().getFileName());
    }

    @SubscribeEvent
    public static void onFileChange(ModConfigEvent.Reloading configEvent) {
        LogManager.getLogger().debug(Logging.FORGEMOD, "Forge config just got changed on the file system!");
    }

    static {
        Object specPair = new ForgeConfigSpec.Builder().configure(Client::new);
        clientSpec = (ForgeConfigSpec)((Object)specPair.getRight());
        CLIENT = (Client)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        commonSpec = (ForgeConfigSpec)((Object)specPair.getRight());
        COMMON = (Common)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(Server::new);
        serverSpec = (ForgeConfigSpec)((Object)specPair.getRight());
        SERVER = (Server)specPair.getLeft();
    }

    public static class Client {
        public final ForgeConfigSpec.BooleanValue alwaysSetupTerrainOffThread;
        public final ForgeConfigSpec.BooleanValue experimentalForgeLightPipelineEnabled;
        public final ForgeConfigSpec.BooleanValue showLoadWarnings;
        public final ForgeConfigSpec.BooleanValue useCombinedDepthStencilAttachment;
        public final ForgeConfigSpec.BooleanValue forceSystemNanoTime;

        Client(ForgeConfigSpec.Builder builder) {
            builder.comment("Client only settings, mostly things related to rendering").push("client");
            this.alwaysSetupTerrainOffThread = builder.comment("Enable Forge to queue all chunk updates to the Chunk Update thread.", "May increase FPS significantly, but may also cause weird rendering lag.", "Not recommended for computers without a significant number of cores available.").translation("forge.configgui.alwaysSetupTerrainOffThread").define("alwaysSetupTerrainOffThread", false);
            this.experimentalForgeLightPipelineEnabled = builder.comment("EXPERIMENTAL: Enable the Forge block rendering pipeline - fixes the lighting of custom models.").translation("forge.configgui.forgeLightPipelineEnabled").define("experimentalForgeLightPipelineEnabled", false);
            this.showLoadWarnings = builder.comment("When enabled, Forge will show any warnings that occurred during loading.").translation("forge.configgui.showLoadWarnings").define("showLoadWarnings", true);
            this.useCombinedDepthStencilAttachment = builder.comment("Set to true to use a combined DEPTH_STENCIL attachment instead of two separate ones.").translation("forge.configgui.useCombinedDepthStencilAttachment").define("useCombinedDepthStencilAttachment", false);
            this.forceSystemNanoTime = builder.comment("Forces the use of System.nanoTime instead of glfwGetTime, as the main Util time provider").translation("forge.configgui.forceSystemNanoTime").define("forceSystemNanoTime", false);
            builder.pop();
        }
    }

    public static class Common {
        public final ForgeConfigSpec.ConfigValue<? extends String> defaultWorldType;

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("General configuration settings").push("general");
            this.defaultWorldType = builder.comment("Defines a default world type to use. The vanilla default world type is represented by 'default'.", "The modded world types are registry names which should include the registry namespace, such as 'examplemod:example_world_type'.").translation("forge.configgui.defaultWorldType").define("defaultWorldType", "default");
            builder.pop();
        }
    }

    public static class Server {
        public final ForgeConfigSpec.BooleanValue removeErroringBlockEntities;
        public final ForgeConfigSpec.BooleanValue removeErroringEntities;
        public final ForgeConfigSpec.BooleanValue fullBoundingBoxLadders;
        public final ForgeConfigSpec.DoubleValue zombieBaseSummonChance;
        public final ForgeConfigSpec.DoubleValue zombieBabyChance;
        public final ForgeConfigSpec.BooleanValue treatEmptyTagsAsAir;
        public final ForgeConfigSpec.BooleanValue skipEmptyShapelessCheck;
        public final ForgeConfigSpec.BooleanValue fixAdvancementLoading;
        public final ForgeConfigSpec.ConfigValue<String> permissionHandler;

        Server(ForgeConfigSpec.Builder builder) {
            builder.comment("Server configuration settings").push("server");
            this.removeErroringBlockEntities = builder.comment("Set this to true to remove any BlockEntity that throws an error in its update method instead of closing the server and reporting a crash log. BE WARNED THIS COULD SCREW UP EVERYTHING USE SPARINGLY WE ARE NOT RESPONSIBLE FOR DAMAGES.").translation("forge.configgui.removeErroringBlockEntities").worldRestart().define("removeErroringBlockEntities", false);
            this.removeErroringEntities = builder.comment("Set this to true to remove any Entity (Note: Does not include BlockEntities) that throws an error in its tick method instead of closing the server and reporting a crash log. BE WARNED THIS COULD SCREW UP EVERYTHING USE SPARINGLY WE ARE NOT RESPONSIBLE FOR DAMAGES.").translation("forge.configgui.removeErroringEntities").worldRestart().define("removeErroringEntities", false);
            this.fullBoundingBoxLadders = builder.comment("Set this to true to check the entire entity's collision bounding box for ladders instead of just the block they are in. Causes noticeable differences in mechanics so default is vanilla behavior. Default: false.").translation("forge.configgui.fullBoundingBoxLadders").worldRestart().define("fullBoundingBoxLadders", false);
            this.zombieBaseSummonChance = builder.comment("Base zombie summoning spawn chance. Allows changing the bonus zombie summoning mechanic.").translation("forge.configgui.zombieBaseSummonChance").worldRestart().defineInRange("zombieBaseSummonChance", 0.1, 0.0, 1.0);
            this.zombieBabyChance = builder.comment("Chance that a zombie (or subclass) is a baby. Allows changing the zombie spawning mechanic.").translation("forge.configgui.zombieBabyChance").worldRestart().defineInRange("zombieBabyChance", 0.05, 0.0, 1.0);
            this.treatEmptyTagsAsAir = builder.comment("Vanilla will treat crafting recipes using empty tags as air, and allow you to craft with nothing in that slot. This changes empty tags to use BARRIER as the item. To prevent crafting with air.").translation("forge.configgui.treatEmptyTagsAsAir").define("treatEmptyTagsAsAir", false);
            this.skipEmptyShapelessCheck = builder.comment("Skip checking if an ingredient is empty during shapeless recipe deserialization to prevent complex ingredients from caching tags too early.").translation("forge.configgui.skipEmptyShapelessCheck").define("skipEmptyShapelessCheck", true);
            this.fixAdvancementLoading = builder.comment("Fix advancement loading to use a proper topological sort. This may have visibility side-effects and can thus be turned off if needed for data-pack compatibility.").translation("forge.configgui.fixAdvancementLoading").define("fixAdvancementLoading", true);
            this.permissionHandler = builder.comment("The permission handler used by the server. Defaults to forge:default_handler if no such handler with that name is registered.").translation("forge.configgui.permissionHandler").define("permissionHandler", "forge:default_handler");
            builder.pop();
        }
    }
}

