/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.FarmlandWaterManager;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.common.UsernameCache;
import net.minecraftforge.common.WorldWorkerManager;
import net.minecraftforge.common.loot.LootModifierManager;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.server.command.ConfigCommand;
import net.minecraftforge.server.command.ForgeCommand;

public class ForgeInternalHandler {
    private static LootModifierManager INSTANCE;

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        Entity newEntity;
        ItemStack stack;
        Item item;
        Entity entity = event.getEntity();
        if (entity.getClass().equals(ItemEntity.class) && (item = (stack = ((ItemEntity)entity).m_32055_()).m_41720_()).hasCustomEntity(stack) && (newEntity = item.createEntity(event.getWorld(), entity, stack)) != null) {
            entity.m_146870_();
            event.setCanceled(true);
            BlockableEventLoop<? super TickTask> executor = LogicalSidedProvider.WORKQUEUE.get(event.getWorld().f_46443_ ? LogicalSide.CLIENT : LogicalSide.SERVER);
            executor.m_6937_((Runnable)new TickTask(0, () -> event.getWorld().m_7967_(newEntity)));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onDimensionUnload(WorldEvent.Unload event) {
        if (event.getWorld() instanceof ServerLevel) {
            FakePlayerFactory.unloadLevel((ServerLevel)event.getWorld());
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        WorldWorkerManager.tick(event.phase == TickEvent.Phase.START);
    }

    @SubscribeEvent
    public void checkSettings(TickEvent.ClientTickEvent event) {
    }

    @SubscribeEvent
    public void onChunkUnload(ChunkEvent.Unload event) {
        if (!event.getWorld().m_5776_()) {
            FarmlandWaterManager.removeTickets(event.getChunk());
        }
    }

    @SubscribeEvent
    public void playerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        UsernameCache.setUsername(event.getPlayer().m_20148_(), event.getPlayer().m_36316_().getName());
    }

    @SubscribeEvent
    public void tagsUpdated(TagsUpdatedEvent event) {
        if (event.shouldUpdateStaticData()) {
            ForgeHooks.updateBurns();
        }
    }

    @SubscribeEvent
    public void onCommandsRegister(RegisterCommandsEvent event) {
        new ForgeCommand(event.getDispatcher());
        ConfigCommand.register(event.getDispatcher());
    }

    @SubscribeEvent
    public void onResourceReload(AddReloadListenerEvent event) {
        INSTANCE = new LootModifierManager();
        event.addListener((PreparableReloadListener)INSTANCE);
    }

    static LootModifierManager getLootModifierManager() {
        if (INSTANCE == null) {
            throw new IllegalStateException("Can not retrieve LootModifierManager until resources have loaded once.");
        }
        return INSTANCE;
    }

    @SubscribeEvent
    public void resourceReloadListeners(AddReloadListenerEvent event) {
        event.addListener(TierSortingRegistry.getReloadListener());
    }
}

