/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.world;

import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringUtil;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraftforge.common.ForgeConfig;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ForgeWorldPreset {
    private static final Logger LOGGER = LogManager.getLogger();
    private final IChunkGeneratorFactory factory;

    public static ForgeWorldPreset getDefaultWorldPreset() {
        String defaultWorldType = ForgeConfig.COMMON.defaultWorldType.get();
        if (StringUtil.m_14408_((String)defaultWorldType) || "default".equals(defaultWorldType)) {
            return null;
        }
        ForgeWorldPreset def = ForgeRegistries.WORLD_TYPES.get().getValue(new ResourceLocation(defaultWorldType));
        if (def == null) {
            LOGGER.error("The defaultWorldType '{}' specified in the forge config has not been registered. The vanilla default generator will be used.", (Object)defaultWorldType);
        }
        return def;
    }

    public ForgeWorldPreset(IChunkGeneratorFactory factory) {
        this.factory = factory;
    }

    public ForgeWorldPreset(IBasicChunkGeneratorFactory factory) {
        this.factory = factory;
    }

    public String getTranslationKey() {
        return Util.m_137492_((String)"generator", (ResourceLocation)ForgeRegistries.WORLD_TYPES.get().getKey(this));
    }

    public Component getDisplayName() {
        return Component.m_237115_((String)this.getTranslationKey());
    }

    public ChunkGenerator createChunkGenerator(RegistryAccess registryAccess, long seed, String generatorSettings) {
        return this.factory.createChunkGenerator(registryAccess, seed, generatorSettings);
    }

    public WorldGenSettings createSettings(RegistryAccess registryAccess, long seed, boolean generateStructures, boolean generateLoot, String generatorSettings) {
        return this.factory.createSettings(registryAccess, seed, generateStructures, generateLoot, generatorSettings);
    }

    public static interface IChunkGeneratorFactory {
        public ChunkGenerator createChunkGenerator(RegistryAccess var1, long var2, String var4);

        default public WorldGenSettings createSettings(RegistryAccess dynamicRegistries, long seed, boolean generateStructures, boolean bonusChest, String generatorSettings) {
            Registry dimensionTypeRegistry = dynamicRegistries.m_175515_(Registry.f_122818_);
            Registry levelStemRegistry = dynamicRegistries.m_175515_(Registry.f_122820_);
            return new WorldGenSettings(seed, generateStructures, bonusChest, WorldGenSettings.m_204649_((Registry)dimensionTypeRegistry, (Registry)levelStemRegistry, (ChunkGenerator)this.createChunkGenerator(dynamicRegistries, seed, generatorSettings)));
        }
    }

    public static interface IBasicChunkGeneratorFactory
    extends IChunkGeneratorFactory {
        public ChunkGenerator createChunkGenerator(RegistryAccess var1, long var2);

        @Override
        default public ChunkGenerator createChunkGenerator(RegistryAccess registryAccess, long seed, String generatorSettings) {
            return this.createChunkGenerator(registryAccess, seed);
        }
    }
}

