/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event.entity.living;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.eventbus.api.Cancelable;
import org.jetbrains.annotations.Nullable;

public class LivingEvent
extends EntityEvent {
    private final LivingEntity entityLiving;

    public LivingEvent(LivingEntity entity) {
        super((Entity)entity);
        this.entityLiving = entity;
    }

    public LivingEntity getEntityLiving() {
        return this.entityLiving;
    }

    public static class LivingVisibilityEvent
    extends LivingEvent {
        private double visibilityModifier;
        @Nullable
        private final Entity lookingEntity;

        public LivingVisibilityEvent(LivingEntity livingEntity, @Nullable Entity lookingEntity, double originalMultiplier) {
            super(livingEntity);
            this.visibilityModifier = originalMultiplier;
            this.lookingEntity = lookingEntity;
        }

        public void modifyVisibility(double mod) {
            this.visibilityModifier *= mod;
        }

        public double getVisibilityModifier() {
            return this.visibilityModifier;
        }

        @Nullable
        public Entity getLookingEntity() {
            return this.lookingEntity;
        }
    }

    public static class LivingJumpEvent
    extends LivingEvent {
        public LivingJumpEvent(LivingEntity e) {
            super(e);
        }
    }

    @Cancelable
    public static class LivingUpdateEvent
    extends LivingEvent {
        public LivingUpdateEvent(LivingEntity e) {
            super(e);
        }
    }
}

