/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event.world;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraftforge.eventbus.api.Event;

public class StructureSpawnListGatherEvent
extends Event {
    private final Structure structure;
    private final Map<MobCategory, List<MobSpawnSettings.SpawnerData>> entitySpawns = new HashMap<MobCategory, List<MobSpawnSettings.SpawnerData>>();
    private final Map<MobCategory, List<MobSpawnSettings.SpawnerData>> entitySpawnsUnmodifiableLists = new HashMap<MobCategory, List<MobSpawnSettings.SpawnerData>>();
    private final Map<MobCategory, List<MobSpawnSettings.SpawnerData>> entitySpawnsUnmodifiable = Collections.unmodifiableMap(this.entitySpawnsUnmodifiableLists);
    private boolean insideOnly;

    public StructureSpawnListGatherEvent(Structure structure) {
        this.structure = structure;
        this.insideOnly = false;
    }

    public Structure getStructure() {
        return this.structure;
    }

    public void setInsideOnly(boolean insideOnly) {
        this.insideOnly = insideOnly;
    }

    public boolean isInsideOnly() {
        return this.insideOnly;
    }

    public List<MobSpawnSettings.SpawnerData> getEntitySpawns(MobCategory classification) {
        return this.entitySpawnsUnmodifiableLists.getOrDefault(classification, Collections.emptyList());
    }

    private List<MobSpawnSettings.SpawnerData> getOrCreateEntitySpawns(MobCategory classification) {
        return this.entitySpawns.computeIfAbsent(classification, c -> {
            ArrayList spawners = new ArrayList();
            this.entitySpawnsUnmodifiableLists.put((MobCategory)c, Collections.unmodifiableList(spawners));
            return spawners;
        });
    }

    public void addEntitySpawn(MobCategory classification, MobSpawnSettings.SpawnerData spawner) {
        this.getOrCreateEntitySpawns(classification).add(spawner);
    }

    public void addEntitySpawns(MobCategory classification, List<MobSpawnSettings.SpawnerData> spawners) {
        this.getOrCreateEntitySpawns(classification).addAll(spawners);
    }

    public void removeEntitySpawn(MobCategory classification, MobSpawnSettings.SpawnerData spawner) {
        if (this.entitySpawns.containsKey(classification)) {
            this.entitySpawns.get(classification).remove(spawner);
        }
    }

    public Map<MobCategory, List<MobSpawnSettings.SpawnerData>> getEntitySpawns() {
        return this.entitySpawnsUnmodifiable;
    }
}

