/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.registries;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Lifecycle;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryInternal;
import net.minecraftforge.registries.IHolderHelperHolder;
import net.minecraftforge.registries.ILockableRegistry;
import net.minecraftforge.registries.NamespacedHolderHelper;
import net.minecraftforge.registries.RegistryManager;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;

class NamespacedDefaultedWrapper<T>
extends DefaultedRegistry<T>
implements ILockableRegistry,
IHolderHelperHolder<T> {
    private final ForgeRegistry<T> delegate;
    private final NamespacedHolderHelper<T> holders;
    private boolean locked = false;
    private Lifecycle elementsLifecycle = Lifecycle.experimental();

    private NamespacedDefaultedWrapper(ForgeRegistry<T> owner, Function<T, Holder.Reference<T>> holderLookup) {
        super("empty", owner.getRegistryKey(), Lifecycle.experimental(), holderLookup);
        this.delegate = owner;
        this.holders = new NamespacedHolderHelper<T>(owner, this, this.delegate.getDefaultKey(), holderLookup);
    }

    public Holder<T> m_203704_(int id, ResourceKey<T> key, T value, Lifecycle lifecycle) {
        if (this.locked) {
            throw new IllegalStateException("Can not register to a locked registry. Modder should use Forge Register methods.");
        }
        Validate.notNull(value);
        this.elementsLifecycle = this.elementsLifecycle.add(lifecycle);
        T oldValue = this.delegate.getRaw(key.m_135782_());
        int realId = this.delegate.add(id, key.m_135782_(), value);
        return this.holders.onAdded(RegistryManager.ACTIVE, realId, key, value, oldValue);
    }

    public Holder<T> m_203505_(ResourceKey<T> p_205891_, T p_205892_, Lifecycle p_205893_) {
        return this.m_203704_(-1, p_205891_, p_205892_, p_205893_);
    }

    public Holder<T> m_203384_(OptionalInt id, ResourceKey<T> p_205885_, T p_205886_, Lifecycle p_205887_) {
        int wanted = -1;
        if (id.isPresent() && this.m_7942_(id.getAsInt()) != null) {
            wanted = id.getAsInt();
        }
        return this.m_203704_(wanted, p_205885_, p_205886_, p_205887_);
    }

    public Optional<T> m_6612_(@Nullable ResourceLocation name) {
        return Optional.ofNullable(this.delegate.getRaw(name));
    }

    @Nullable
    public T m_7745_(@Nullable ResourceLocation name) {
        return this.delegate.getValue(name);
    }

    @Nullable
    public T m_6246_(@Nullable ResourceKey<T> name) {
        return name == null ? null : (T)this.delegate.getRaw(name.m_135782_());
    }

    @Nullable
    public ResourceLocation m_7981_(T value) {
        return this.delegate.getKey(value);
    }

    public Optional<ResourceKey<T>> m_7854_(T p_122755_) {
        return this.delegate.getResourceKey(p_122755_);
    }

    public boolean m_7804_(ResourceLocation key) {
        return this.delegate.containsKey(key);
    }

    public boolean m_142003_(ResourceKey<T> key) {
        return this.delegate.getRegistryName().equals((Object)key.m_211136_()) && this.m_7804_(key.m_135782_());
    }

    public int m_7447_(@Nullable T value) {
        return this.delegate.getID(value);
    }

    @Nullable
    public T m_7942_(int id) {
        return this.delegate.getValue(id);
    }

    public ResourceLocation m_122315_() {
        return this.delegate.getDefaultKey();
    }

    public Lifecycle m_6228_(T value) {
        return Lifecycle.stable();
    }

    public Lifecycle m_7837_() {
        return this.elementsLifecycle;
    }

    public Iterator<T> iterator() {
        return this.delegate.iterator();
    }

    public Set<ResourceLocation> m_6566_() {
        return this.delegate.getKeys();
    }

    public Set<Map.Entry<ResourceKey<T>, T>> m_6579_() {
        return this.delegate.getEntries();
    }

    public boolean m_142427_() {
        return this.delegate.isEmpty();
    }

    public int m_13562_() {
        return this.delegate.size();
    }

    @Override
    public NamespacedHolderHelper<T> getHolderHelper() {
        return this.holders;
    }

    public Optional<Holder<T>> m_203300_(int id) {
        return this.holders.getHolder(id);
    }

    public Optional<Holder<T>> m_203636_(ResourceKey<T> key) {
        return this.holders.getHolder(key);
    }

    public DataResult<Holder<T>> m_214185_(ResourceKey<T> key) {
        return DataResult.success(this.holders.getOrCreateHolder(key));
    }

    public Optional<Holder<T>> m_213642_(RandomSource rand) {
        return this.holders.getRandom(rand);
    }

    public Stream<Holder.Reference<T>> m_203611_() {
        return this.holders.holders();
    }

    public boolean m_203658_(TagKey<T> name) {
        return this.holders.isKnownTagName(name);
    }

    public Stream<Pair<TagKey<T>, HolderSet.Named<T>>> m_203612_() {
        return this.holders.getTags();
    }

    public HolderSet.Named<T> m_203561_(TagKey<T> name) {
        return this.holders.getOrCreateTag(name);
    }

    public Stream<TagKey<T>> m_203613_() {
        return this.holders.getTagNames();
    }

    public Registry<T> m_203521_() {
        return this.holders.freeze();
    }

    public Holder.Reference<T> m_203693_(T value) {
        return this.holders.createIntrusiveHolder(value);
    }

    public Optional<HolderSet.Named<T>> m_203431_(TagKey<T> name) {
        return this.holders.getTag(name);
    }

    public void m_203652_(Map<TagKey<T>, List<Holder<T>>> newTags) {
        this.holders.bindTags(newTags);
    }

    public void m_203635_() {
        this.holders.resetTags();
    }

    @Deprecated
    public void unfreeze() {
        this.holders.unfreeze();
    }

    @Override
    @Deprecated
    public void lock() {
        this.locked = true;
    }

    public static class Factory<V>
    implements IForgeRegistry.CreateCallback<V>,
    IForgeRegistry.AddCallback<V> {
        public static final ResourceLocation ID = new ResourceLocation("forge", "registry_defaulted_wrapper");

        @Override
        public void onCreate(IForgeRegistryInternal<V> owner, RegistryManager stage) {
            ForgeRegistry fowner = (ForgeRegistry)owner;
            owner.setSlaveMap(ID, new NamespacedDefaultedWrapper(fowner, fowner.getBuilder().getVanillaHolder()));
        }

        @Override
        public void onAdd(IForgeRegistryInternal<V> owner, RegistryManager stage, int id, ResourceKey<V> key, V value, V oldValue) {
            owner.getSlaveMap((ResourceLocation)Factory.ID, NamespacedDefaultedWrapper.class).holders.onAdded(stage, id, key, value, oldValue);
        }
    }
}

