/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading;

import com.mojang.logging.LogUtils;
import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.api.IModuleLayerManager;
import cpw.mods.modlauncher.util.ServiceLoaderUtils;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraftforge.fml.loading.EarlyLoadingException;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.JarVersionLookupHandler;
import net.minecraftforge.fml.loading.LogMarkers;
import net.minecraftforge.fml.loading.VersionSupportMatrix;
import net.minecraftforge.fml.loading.moddiscovery.ExplodedDirectoryLocator;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.fml.loading.progress.StartupMessageManager;
import net.minecraftforge.forgespi.language.IModLanguageProvider;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.VersionRange;
import org.slf4j.Logger;

public class LanguageLoadingProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final List<IModLanguageProvider> languageProviders = new ArrayList<IModLanguageProvider>();
    private final ServiceLoader<IModLanguageProvider> serviceLoader;
    private final Map<String, ModLanguageWrapper> languageProviderMap = new HashMap<String, ModLanguageWrapper>();
    private List<Path> languagePaths = new ArrayList<Path>();

    public void forEach(Consumer<IModLanguageProvider> consumer) {
        this.languageProviders.forEach(consumer);
    }

    public <T> Stream<T> applyForEach(Function<IModLanguageProvider, T> function) {
        return this.languageProviders.stream().map(function);
    }

    LanguageLoadingProvider() {
        ModuleLayer sl = (ModuleLayer)Launcher.INSTANCE.environment().findModuleLayerManager().flatMap(lm -> lm.getLayer(IModuleLayerManager.Layer.PLUGIN)).orElseThrow();
        this.serviceLoader = ServiceLoader.load(sl, IModLanguageProvider.class);
        this.loadLanguageProviders();
    }

    private void loadLanguageProviders() {
        LOGGER.debug(LogMarkers.CORE, "Found {} language providers", (Object)ServiceLoaderUtils.streamServiceLoader(() -> this.serviceLoader, sce -> LOGGER.error("Problem with language loaders")).count());
        this.serviceLoader.forEach(this.languageProviders::add);
        this.languageProviders.forEach((? super T lp) -> {
            Path lpPath;
            try {
                lpPath = Paths.get(lp.getClass().getProtectionDomain().getCodeSource().getLocation().toURI());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Huh?", e);
            }
            Optional<String> implementationVersion = JarVersionLookupHandler.getImplementationVersion(lp.getClass());
            String impl = implementationVersion.orElse(Files.isDirectory(lpPath, new LinkOption[0]) ? FMLLoader.versionInfo().forgeVersion().split("\\.")[0] : null);
            if (impl == null) {
                LOGGER.error(LogMarkers.CORE, "Found unversioned language provider {}", (Object)lp.name());
                throw new RuntimeException("Failed to find implementation version for language provider " + lp.name());
            }
            LOGGER.debug(LogMarkers.CORE, "Found language provider {}, version {}", (Object)lp.name(), (Object)impl);
            StartupMessageManager.modLoaderConsumer().ifPresent(c -> c.accept("Loaded language provider " + lp.name() + " " + impl));
            this.languageProviderMap.put(lp.name(), new ModLanguageWrapper((IModLanguageProvider)lp, (ArtifactVersion)new DefaultArtifactVersion(impl)));
        });
    }

    void addForgeLanguage(Path forgePath) {
        if (!this.languageProviderMap.containsKey("javafml")) {
            LOGGER.debug(LogMarkers.CORE, "Adding forge as a language from {}", (Object)forgePath.toString());
            this.addLanguagePaths(Stream.of(forgePath));
            this.serviceLoader.reload();
            this.loadLanguageProviders();
        } else {
            LOGGER.debug(LogMarkers.CORE, "Skipping adding forge jar - javafml is already present");
        }
    }

    private void addLanguagePaths(Stream<Path> langPaths) {
        this.languageProviders.clear();
        this.languageProviderMap.clear();
    }

    public void addAdditionalLanguages(List<ModFile> modFiles) {
        if (modFiles == null) {
            return;
        }
        Stream<Path> langPaths = modFiles.stream().map(ModFile::getFilePath);
        this.addLanguagePaths(langPaths);
        this.serviceLoader.reload();
        this.loadLanguageProviders();
    }

    Stream<Path> getLibraries() {
        return this.languagePaths.stream();
    }

    public IModLanguageProvider findLanguage(ModFile mf, String modLoader, VersionRange modLoaderVersion) {
        String languageFileName = mf.getLocator() instanceof ExplodedDirectoryLocator ? "in-development" : mf.getFileName();
        ModLanguageWrapper mlw = this.languageProviderMap.get(modLoader);
        if (mlw == null) {
            LOGGER.error(LogMarkers.LOADING, "Missing language {} version {} wanted by {}", new Object[]{modLoader, modLoaderVersion, languageFileName});
            throw new EarlyLoadingException("Missing language " + modLoader, null, Collections.singletonList(new EarlyLoadingException.ExceptionData("fml.language.missingversion", modLoader, modLoaderVersion, languageFileName, "null")));
        }
        if (!VersionSupportMatrix.testVersionSupportMatrix(modLoaderVersion, modLoader, "languageloader", (llid, range) -> range.containsVersion(mlw.getVersion()))) {
            LOGGER.error(LogMarkers.LOADING, "Missing language {} version {} wanted by {}, found {}", new Object[]{modLoader, modLoaderVersion, languageFileName, mlw.getVersion()});
            throw new EarlyLoadingException("Missing language " + modLoader + " matching range " + modLoaderVersion + " found " + mlw.getVersion(), null, Collections.singletonList(new EarlyLoadingException.ExceptionData("fml.language.missingversion", modLoader, modLoaderVersion, languageFileName, mlw.getVersion())));
        }
        return mlw.getModLanguageProvider();
    }

    private static class ModLanguageWrapper {
        private final IModLanguageProvider modLanguageProvider;
        private final ArtifactVersion version;

        public ModLanguageWrapper(IModLanguageProvider modLanguageProvider, ArtifactVersion version) {
            this.modLanguageProvider = modLanguageProvider;
            this.version = version;
        }

        public ArtifactVersion getVersion() {
            return this.version;
        }

        public IModLanguageProvider getModLanguageProvider() {
            return this.modLanguageProvider;
        }
    }
}

