/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading.moddiscovery;

import com.mojang.logging.LogUtils;
import cpw.mods.jarhandling.JarMetadata;
import cpw.mods.jarhandling.SecureJar;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.jar.Manifest;
import net.minecraftforge.fml.loading.LogMarkers;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.fml.loading.moddiscovery.ModFileParser;
import net.minecraftforge.fml.loading.moddiscovery.ModJarMetadata;
import net.minecraftforge.forgespi.language.IConfigurable;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.forgespi.locating.IModLocator;
import org.slf4j.Logger;

public abstract class AbstractModLocator
implements IModLocator {
    private static final Logger LOGGER = LogUtils.getLogger();
    protected static final String MODS_TOML = "META-INF/mods.toml";
    protected static final String MANIFEST = "META-INF/MANIFEST.MF";

    protected Optional<IModFile> createMod(Path ... path) {
        ModFile mod;
        ModJarMetadata mjm = new ModJarMetadata();
        SecureJar sj = SecureJar.from(Manifest::new, jar -> jar.findFile(MODS_TOML).isPresent() ? mjm : JarMetadata.from((SecureJar)jar, (Path[])path), (root, p) -> true, (Path[])path);
        String type = sj.getManifest().getMainAttributes().getValue(ModFile.TYPE);
        if (sj.findFile(MODS_TOML).isPresent()) {
            LOGGER.debug(LogMarkers.SCAN, "Found {} mod of type {}: {}", new Object[]{MODS_TOML, type, path});
            mod = new ModFile(sj, this, ModFileParser::modsTomlParser);
        } else if (type != null) {
            LOGGER.debug(LogMarkers.SCAN, "Found {} mod of type {}: {}", new Object[]{MANIFEST, type, path});
            mod = new ModFile(sj, this, this::manifestParser);
        } else {
            return Optional.empty();
        }
        mjm.setModFile(mod);
        return Optional.of(mod);
    }

    protected IModFileInfo manifestParser(final IModFile mod) {
        Function<String, Optional> cfg = name -> Optional.ofNullable(mod.getSecureJar().getManifest().getMainAttributes().getValue((String)name));
        final String license = cfg.apply("LICENSE").orElse("");
        IConfigurable dummy = new IConfigurable(){

            public <T> Optional<T> getConfigElement(String ... key) {
                return Optional.empty();
            }

            public List<? extends IConfigurable> getConfigList(String ... key) {
                return Collections.emptyList();
            }
        };
        return new IModFileInfo(){
            final /* synthetic */ 1 val$dummy;
            {
                this.val$dummy = var4_4;
            }

            public List<IModInfo> getMods() {
                return Collections.emptyList();
            }

            public List<IModFileInfo.LanguageSpec> requiredLanguageLoaders() {
                return Collections.emptyList();
            }

            public boolean showAsResourcePack() {
                return false;
            }

            public Map<String, Object> getFileProperties() {
                return Collections.emptyMap();
            }

            public String getLicense() {
                return license;
            }

            public IModFile getFile() {
                return mod;
            }

            public IConfigurable getConfig() {
                return this.val$dummy;
            }

            public String moduleName() {
                return mod.getSecureJar().name();
            }

            public String versionString() {
                return null;
            }

            public List<String> usesServices() {
                return null;
            }

            public String toString() {
                return "IModFileInfo(" + mod.getFilePath() + ")";
            }
        };
    }

    public boolean isValid(IModFile modFile) {
        return true;
    }
}

