/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading.moddiscovery;

import com.mojang.logging.LogUtils;
import cpw.mods.modlauncher.api.IModuleLayerManager;
import cpw.mods.modlauncher.api.ITransformationService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraftforge.fml.loading.EarlyLoadingException;
import net.minecraftforge.fml.loading.LoadingModList;
import net.minecraftforge.fml.loading.LogMarkers;
import net.minecraftforge.fml.loading.ModSorter;
import net.minecraftforge.fml.loading.moddiscovery.BackgroundScanHandler;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.fml.loading.progress.StartupMessageManager;
import net.minecraftforge.forgespi.locating.IModFile;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class ModValidator {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Map<IModFile.Type, List<ModFile>> modFiles;
    private final List<ModFile> candidatePlugins;
    private final List<ModFile> candidateMods;
    private LoadingModList loadingModList;
    private List<ModFile> brokenFiles;

    public ModValidator(Map<IModFile.Type, List<ModFile>> modFiles) {
        this.modFiles = modFiles;
        this.candidateMods = ModValidator.lst(modFiles.get(IModFile.Type.MOD));
        this.candidateMods.addAll(ModValidator.lst(modFiles.get(IModFile.Type.GAMELIBRARY)));
        this.candidatePlugins = ModValidator.lst(modFiles.get(IModFile.Type.LANGPROVIDER));
        this.candidatePlugins.addAll(ModValidator.lst(modFiles.get(IModFile.Type.LIBRARY)));
    }

    private static List<ModFile> lst(List<ModFile> files) {
        return files == null ? new ArrayList<ModFile>() : new ArrayList<ModFile>(files);
    }

    public void stage1Validation() {
        this.brokenFiles = this.validateFiles(this.candidateMods);
        if (LOGGER.isDebugEnabled(LogMarkers.SCAN)) {
            LOGGER.debug(LogMarkers.SCAN, "Found {} mod files with {} mods", (Object)this.candidateMods.size(), (Object)this.candidateMods.stream().mapToInt(mf -> mf.getModInfos().size()).sum());
        }
        StartupMessageManager.modLoaderConsumer().ifPresent(c -> c.accept("Found " + this.candidateMods.size() + " modfiles to load"));
    }

    @NotNull
    private List<ModFile> validateFiles(List<ModFile> mods) {
        ArrayList<ModFile> brokenFiles = new ArrayList<ModFile>();
        Iterator<ModFile> iterator = mods.iterator();
        while (iterator.hasNext()) {
            ModFile mod = iterator.next();
            if (mod.getLocator().isValid((IModFile)mod) && mod.identifyMods()) continue;
            LOGGER.warn(LogMarkers.SCAN, "File {} has been ignored - it is invalid", (Object)mod.getFilePath());
            iterator.remove();
            brokenFiles.add(mod);
        }
        return brokenFiles;
    }

    public ITransformationService.Resource getPluginResources() {
        return new ITransformationService.Resource(IModuleLayerManager.Layer.PLUGIN, this.candidatePlugins.stream().map(ModFile::getSecureJar).toList());
    }

    public ITransformationService.Resource getModResources() {
        return new ITransformationService.Resource(IModuleLayerManager.Layer.GAME, this.candidateMods.stream().map(ModFile::getSecureJar).toList());
    }

    private List<EarlyLoadingException.ExceptionData> validateLanguages() {
        ArrayList<EarlyLoadingException.ExceptionData> errorData = new ArrayList<EarlyLoadingException.ExceptionData>();
        Iterator<ModFile> iterator = this.candidateMods.iterator();
        while (iterator.hasNext()) {
            ModFile modFile = iterator.next();
            try {
                modFile.identifyLanguage();
            }
            catch (EarlyLoadingException e) {
                errorData.addAll(e.getAllData());
                iterator.remove();
            }
        }
        return errorData;
    }

    public BackgroundScanHandler stage2Validation() {
        List<EarlyLoadingException.ExceptionData> errors = this.validateLanguages();
        this.loadingModList = ModSorter.sort(this.candidateMods, errors);
        this.loadingModList.addCoreMods();
        this.loadingModList.addAccessTransformers();
        this.loadingModList.setBrokenFiles(this.brokenFiles);
        BackgroundScanHandler backgroundScanHandler = new BackgroundScanHandler(this.candidateMods);
        this.loadingModList.addForScanning(backgroundScanHandler);
        return backgroundScanHandler;
    }
}

