/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading.targets;

import cpw.mods.jarhandling.SecureJar;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.BiPredicate;
import java.util.stream.Stream;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.LibraryFinder;
import net.minecraftforge.fml.loading.VersionInfo;
import net.minecraftforge.fml.loading.targets.CommonLaunchHandler;

public abstract class CommonServerLaunchHandler
extends CommonLaunchHandler {
    @Override
    public Dist getDist() {
        return Dist.DEDICATED_SERVER;
    }

    @Override
    public String getNaming() {
        return "srg";
    }

    @Override
    public boolean isProduction() {
        return true;
    }

    public Callable<Void> launchService(String[] arguments, ModuleLayer layer) {
        return () -> {
            Class.forName(layer.findModule("minecraft").orElseThrow(), "net.minecraft.server.Main").getMethod("main", String[].class).invoke(null, new Object[]{arguments});
            return null;
        };
    }

    @Override
    public CommonLaunchHandler.LocatedPaths getMinecraftPaths() {
        VersionInfo vers = FMLLoader.versionInfo();
        Path mc = LibraryFinder.findPathForMaven("net.minecraft", "server", "", "srg", vers.mcAndMCPVersion());
        Path mcextra = LibraryFinder.findPathForMaven("net.minecraft", "server", "", "extra", vers.mcAndMCPVersion());
        SecureJar mcextra_filtered = SecureJar.from((path, base) -> path.equals("META-INF/versions/") || !path.endsWith(".class") && !path.startsWith("META-INF/"), (Path[])new Path[]{mcextra});
        BiPredicate<String, String> filter = (path, base) -> true;
        Stream.Builder<Path> mcstream = Stream.builder().add(mc).add(mcextra_filtered.getRootPath());
        Stream.Builder<List<Path>> modstream = Stream.builder();
        filter = this.processMCStream(vers, mcstream, filter, modstream);
        Path fmlcore = LibraryFinder.findPathForMaven(vers.forgeGroup(), "fmlcore", "", "", vers.mcAndForgeVersion());
        Path javafmllang = LibraryFinder.findPathForMaven(vers.forgeGroup(), "javafmllanguage", "", "", vers.mcAndForgeVersion());
        Path lowcodelang = LibraryFinder.findPathForMaven(vers.forgeGroup(), "lowcodelanguage", "", "", vers.mcAndForgeVersion());
        Path mclang = LibraryFinder.findPathForMaven(vers.forgeGroup(), "mclanguage", "", "", vers.mcAndForgeVersion());
        return new CommonLaunchHandler.LocatedPaths(mcstream.build().toList(), filter, modstream.build().toList(), List.of(fmlcore, javafmllang, lowcodelang, mclang));
    }

    protected abstract BiPredicate<String, String> processMCStream(VersionInfo var1, Stream.Builder<Path> var2, BiPredicate<String, String> var3, Stream.Builder<List<Path>> var4);
}

