/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.LongIterator;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.runtime.ObjectMethods;
import java.net.Proxy;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyPair;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.LongSupplier;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import net.minecraft.CrashReport;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.SystemReport;
import net.minecraft.Util;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.data.worldgen.features.MiscOverworldFeatures;
import net.minecraft.gametest.framework.GameTestTicker;
import net.minecraft.network.chat.ChatDecorator;
import net.minecraft.network.chat.ChatSender;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundChangeDifficultyPacket;
import net.minecraft.network.protocol.game.ClientboundSetTimePacket;
import net.minecraft.network.protocol.status.ServerStatus;
import net.minecraft.obfuscate.DontObfuscate;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ReloadableServerResources;
import net.minecraft.server.ServerAdvancementManager;
import net.minecraft.server.ServerFunctionManager;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.Services;
import net.minecraft.server.TickTask;
import net.minecraft.server.WorldStem;
import net.minecraft.server.bossevents.CustomBossEvents;
import net.minecraft.server.level.DemoMode;
import net.minecraft.server.level.PlayerRespawnLogic;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.ServerPlayerGameMode;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.server.level.progress.ChunkProgressListenerFactory;
import net.minecraft.server.network.ServerConnectionListener;
import net.minecraft.server.network.TextFilter;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.resources.CloseableResourceManager;
import net.minecraft.server.packs.resources.MultiPackResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.server.players.PlayerList;
import net.minecraft.server.players.ServerOpListEntry;
import net.minecraft.server.players.UserWhiteList;
import net.minecraft.util.Crypt;
import net.minecraft.util.CryptException;
import net.minecraft.util.FrameTimer;
import net.minecraft.util.ModCheck;
import net.minecraft.util.Mth;
import net.minecraft.util.NativeModuleLister;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SignatureValidator;
import net.minecraft.util.Unit;
import net.minecraft.util.profiling.EmptyProfileResults;
import net.minecraft.util.profiling.ProfileResults;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.util.profiling.ResultField;
import net.minecraft.util.profiling.SingleTickProfiler;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import net.minecraft.util.profiling.jfr.callback.ProfiledDuration;
import net.minecraft.util.profiling.metrics.MetricsSamplerProvider;
import net.minecraft.util.profiling.metrics.profiling.ActiveMetricsRecorder;
import net.minecraft.util.profiling.metrics.profiling.InactiveMetricsRecorder;
import net.minecraft.util.profiling.metrics.profiling.MetricsRecorder;
import net.minecraft.util.profiling.metrics.profiling.ServerMetricsSamplersProvider;
import net.minecraft.util.profiling.metrics.storage.MetricsPersister;
import net.minecraft.util.thread.ReentrantBlockableEventLoop;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.ai.village.VillageSiege;
import net.minecraft.world.entity.npc.CatSpawner;
import net.minecraft.world.entity.npc.WanderingTraderSpawner;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.DataPackConfig;
import net.minecraft.world.level.ForcedChunksSavedData;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.border.BorderChangeListener;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.PatrolSpawner;
import net.minecraft.world.level.levelgen.PhantomSpawner;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.CommandStorage;
import net.minecraft.world.level.storage.DerivedLevelData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.PlayerDataStorage;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.level.storage.loot.ItemModifierManager;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.PredicateManager;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.world.ForgeChunkManager;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.GameShuttingDownEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;
import net.minecraftforge.gametest.ForgeGameTestHooks;
import net.minecraftforge.internal.BrandingControl;
import net.minecraftforge.resource.ResourcePackLoader;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;

public abstract class MinecraftServer
extends ReentrantBlockableEventLoop<TickTask>
implements CommandSource,
AutoCloseable {
    private static final Logger f_129750_ = LogUtils.getLogger();
    public static final String f_195495_ = "vanilla";
    private static final float f_177884_ = 0.8f;
    private static final int f_177885_ = 100;
    public static final int f_177878_ = 50;
    private static final int f_177887_ = 2000;
    private static final int f_177888_ = 15000;
    private static final long f_177889_ = 5000000000L;
    private static final int f_177890_ = 12;
    public static final int f_177882_ = 11;
    private static final int f_177891_ = 441;
    private static final int f_177892_ = 6000;
    private static final int f_177893_ = 3;
    public static final int f_177883_ = 29999984;
    public static final LevelSettings f_129743_ = new LevelSettings("Demo World", GameType.SURVIVAL, false, Difficulty.NORMAL, false, new GameRules(), DataPackConfig.f_45842_);
    private static final long f_177871_ = 50L;
    public static final GameProfile f_195496_ = new GameProfile(Util.f_137441_, "Anonymous Player");
    protected final LevelStorageSource.LevelStorageAccess f_129744_;
    protected final PlayerDataStorage f_129745_;
    private final List<Runnable> f_129752_ = Lists.newArrayList();
    private MetricsRecorder f_177872_ = InactiveMetricsRecorder.f_146153_;
    private ProfilerFiller f_129754_ = this.f_177872_.m_142610_();
    private Consumer<ProfileResults> f_177873_ = p_177903_ -> this.m_177928_();
    private Consumer<Path> f_177874_ = p_177954_ -> {};
    private boolean f_177875_;
    @Nullable
    private TimeProfiler f_177876_;
    private boolean f_177877_;
    private final ServerConnectionListener f_129755_;
    private final ChunkProgressListenerFactory f_129756_;
    private final ServerStatus f_129757_ = new ServerStatus();
    private final RandomSource f_129758_ = RandomSource.m_216327_();
    private final DataFixer f_129759_;
    private String f_129760_;
    private int f_129761_ = -1;
    private final RegistryAccess.Frozen f_129746_;
    private final Map<ResourceKey<Level>, ServerLevel> f_129762_ = Maps.newLinkedHashMap();
    private PlayerList f_129763_;
    private volatile boolean f_129764_ = true;
    private boolean f_129765_;
    private int f_129766_;
    protected final Proxy f_129747_;
    private boolean f_129705_;
    private boolean f_129706_;
    private boolean f_129707_;
    private boolean f_129708_;
    @Nullable
    private String f_129709_;
    private int f_129711_;
    public final long[] f_129748_ = new long[100];
    @Nullable
    private KeyPair f_129712_;
    @Nullable
    private GameProfile f_236719_;
    private boolean f_129714_;
    private volatile boolean f_129717_;
    private long f_129718_;
    protected final Services f_236721_;
    private long f_129724_;
    private final Thread f_129725_;
    protected long f_129726_ = Util.m_137550_();
    private long f_129727_;
    private boolean f_129728_;
    private final PackRepository f_129730_;
    private final ServerScoreboard f_129731_ = new ServerScoreboard(this);
    @Nullable
    private CommandStorage f_129732_;
    private final CustomBossEvents f_129733_ = new CustomBossEvents();
    private final ServerFunctionManager f_129734_;
    private final FrameTimer f_129735_ = new FrameTimer();
    private boolean f_129736_;
    private float f_129737_;
    private final Executor f_129738_;
    @Nullable
    private String f_129739_;
    private ReloadableResources f_129740_;
    private final StructureTemplateManager f_236720_;
    protected final WorldData f_129749_;
    private volatile boolean f_195494_;
    private Map<ResourceKey<Level>, long[]> perWorldTickTimes = Maps.newIdentityHashMap();
    private int worldArrayMarker = 0;
    private int worldArrayLast = -1;
    private ServerLevel[] worldArray;

    public static <S extends MinecraftServer> S m_129872_(Function<Thread, S> p_129873_) {
        AtomicReference<MinecraftServer> atomicreference = new AtomicReference<MinecraftServer>();
        Thread thread = new Thread((ThreadGroup)SidedThreadGroups.SERVER, () -> ((MinecraftServer)atomicreference.get()).m_130011_(), "Server thread");
        thread.setUncaughtExceptionHandler((p_177909_, p_177910_) -> f_129750_.error("Uncaught exception in server thread", p_177910_));
        if (Runtime.getRuntime().availableProcessors() > 4) {
            thread.setPriority(8);
        }
        MinecraftServer s = (MinecraftServer)p_129873_.apply(thread);
        atomicreference.set(s);
        thread.start();
        return (S)s;
    }

    public MinecraftServer(Thread p_236723_, LevelStorageSource.LevelStorageAccess p_236724_, PackRepository p_236725_, WorldStem p_236726_, Proxy p_236727_, DataFixer p_236728_, Services p_236729_, ChunkProgressListenerFactory p_236730_) {
        super("Server");
        this.f_129746_ = p_236726_.f_206894_();
        this.f_129749_ = p_236726_.f_206895_();
        if (!this.f_129749_.m_5961_().m_204655_().m_142003_(LevelStem.f_63971_)) {
            throw new IllegalStateException("Missing Overworld dimension data");
        }
        this.f_129747_ = p_236727_;
        this.f_129730_ = p_236725_;
        this.f_129740_ = new ReloadableResources(p_236726_.f_206892_(), p_236726_.f_206893_());
        this.f_236721_ = p_236729_;
        if (p_236729_.f_214336_() != null) {
            p_236729_.f_214336_().m_143974_((Executor)((Object)this));
        }
        this.f_129755_ = new ServerConnectionListener(this);
        this.f_129756_ = p_236730_;
        this.f_129744_ = p_236724_;
        this.f_129745_ = p_236724_.m_78301_();
        this.f_129759_ = p_236728_;
        this.f_129734_ = new ServerFunctionManager(this, this.f_129740_.f_206585_.m_206860_());
        this.f_236720_ = new StructureTemplateManager((ResourceManager)p_236726_.f_206892_(), p_236724_, p_236728_);
        this.f_129725_ = p_236723_;
        this.f_129738_ = Util.m_183991_();
    }

    private void m_129841_(DimensionDataStorage p_129842_) {
        p_129842_.m_164861_(arg_0 -> ((ServerScoreboard)this.m_129896_()).m_180013_(arg_0), () -> ((ServerScoreboard)this.m_129896_()).m_180015_(), "scoreboard");
    }

    protected abstract boolean m_7038_() throws IOException;

    protected void m_130006_() {
        if (!JvmProfiler.f_185340_.m_183608_()) {
            // empty if block
        }
        boolean flag = false;
        ProfiledDuration profiledduration = JvmProfiler.f_185340_.m_183494_();
        this.f_129749_.m_7955_(this.m_130001_(), this.m_183471_().m_184597_());
        ChunkProgressListener chunkprogresslistener = this.f_129756_.m_9620_(11);
        this.m_129815_(chunkprogresslistener);
        this.m_7044_();
        this.m_129940_(chunkprogresslistener);
        if (profiledduration != null) {
            profiledduration.m_185413_();
        }
        if (flag) {
            try {
                JvmProfiler.f_185340_.m_183243_();
            }
            catch (Throwable throwable) {
                f_129750_.warn("Failed to stop JFR profiling", throwable);
            }
        }
    }

    protected void m_7044_() {
    }

    protected void m_129815_(ChunkProgressListener p_129816_) {
        ServerLevelData serverleveldata = this.f_129749_.m_5996_();
        WorldGenSettings worldgensettings = this.f_129749_.m_5961_();
        boolean flag = worldgensettings.m_64668_();
        long i = worldgensettings.m_64619_();
        long j = BiomeManager.m_47877_((long)i);
        ImmutableList list = ImmutableList.of((Object)new PhantomSpawner(), (Object)new PatrolSpawner(), (Object)new CatSpawner(), (Object)new VillageSiege(), (Object)new WanderingTraderSpawner(serverleveldata));
        Registry registry = worldgensettings.m_204655_();
        LevelStem levelstem = (LevelStem)registry.m_6246_(LevelStem.f_63971_);
        ServerLevel serverlevel = new ServerLevel(this, this.f_129738_, this.f_129744_, serverleveldata, Level.f_46428_, levelstem, p_129816_, flag, j, (List<CustomSpawner>)list, true);
        this.f_129762_.put(Level.f_46428_, serverlevel);
        DimensionDataStorage dimensiondatastorage = serverlevel.m_8895_();
        this.m_129841_(dimensiondatastorage);
        this.f_129732_ = new CommandStorage(dimensiondatastorage);
        WorldBorder worldborder = serverlevel.m_6857_();
        MinecraftForge.EVENT_BUS.post((Event)new WorldEvent.Load((LevelAccessor)this.f_129762_.get(Level.f_46428_)));
        if (!serverleveldata.m_6535_()) {
            try {
                MinecraftServer.m_177896_(serverlevel, serverleveldata, worldgensettings.m_64660_(), flag);
                serverleveldata.m_5555_(true);
                if (flag) {
                    this.m_129847_(this.f_129749_);
                }
            }
            catch (Throwable throwable1) {
                CrashReport crashreport = CrashReport.m_127521_(throwable1, "Exception initializing level");
                try {
                    serverlevel.m_6026_(crashreport);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw new ReportedException(crashreport);
            }
            serverleveldata.m_5555_(true);
        }
        this.m_6846_().m_184209_(serverlevel);
        if (this.f_129749_.m_6587_() != null) {
            this.m_129901_().m_136295_(this.f_129749_.m_6587_());
        }
        for (Map.Entry entry : registry.m_6579_()) {
            ResourceKey resourcekey = entry.getKey();
            if (resourcekey == LevelStem.f_63971_) continue;
            ResourceKey<Level> resourcekey1 = ResourceKey.m_135785_(Registry.f_122819_, resourcekey.m_135782_());
            DerivedLevelData derivedleveldata = new DerivedLevelData(this.f_129749_, serverleveldata);
            ServerLevel serverlevel1 = new ServerLevel(this, this.f_129738_, this.f_129744_, (ServerLevelData)derivedleveldata, resourcekey1, (LevelStem)entry.getValue(), p_129816_, flag, j, (List<CustomSpawner>)ImmutableList.of(), false);
            worldborder.m_61929_((BorderChangeListener)new BorderChangeListener.DelegateBorderChangeListener(serverlevel1.m_6857_()));
            this.f_129762_.put(resourcekey1, serverlevel1);
            MinecraftForge.EVENT_BUS.post((Event)new WorldEvent.Load((LevelAccessor)this.f_129762_.get(resourcekey)));
        }
        worldborder.m_61931_(serverleveldata.m_5813_());
    }

    private static void m_177896_(ServerLevel p_177897_, ServerLevelData p_177898_, boolean p_177899_, boolean p_177900_) {
        if (p_177900_) {
            p_177898_.m_7250_(BlockPos.f_121853_.m_6630_(80), 0.0f);
        } else {
            ServerChunkCache serverchunkcache = p_177897_.m_7726_();
            if (ForgeEventFactory.onCreateWorldSpawn((Level)p_177897_, (ServerLevelData)p_177898_)) {
                return;
            }
            ChunkPos chunkpos = new ChunkPos(serverchunkcache.m_214994_().m_224579_().m_183230_());
            int i = serverchunkcache.m_8481_().m_142051_((LevelHeightAccessor)p_177897_);
            if (i < p_177897_.m_141937_()) {
                BlockPos blockpos = chunkpos.m_45615_();
                i = p_177897_.m_6924_(Heightmap.Types.WORLD_SURFACE, blockpos.m_123341_() + 8, blockpos.m_123343_() + 8);
            }
            p_177898_.m_7250_(chunkpos.m_45615_().m_7918_(8, i, 8), 0.0f);
            int k1 = 0;
            int j = 0;
            int k = 0;
            int l = -1;
            int i1 = 5;
            for (int j1 = 0; j1 < Mth.m_144944_((int)11); ++j1) {
                BlockPos blockpos1;
                if (k1 >= -5 && k1 <= 5 && j >= -5 && j <= 5 && (blockpos1 = PlayerRespawnLogic.m_183932_((ServerLevel)p_177897_, (ChunkPos)new ChunkPos(chunkpos.f_45578_ + k1, chunkpos.f_45579_ + j))) != null) {
                    p_177898_.m_7250_(blockpos1, 0.0f);
                    break;
                }
                if (k1 == j || k1 < 0 && k1 == -j || k1 > 0 && k1 == 1 - j) {
                    int l1 = k;
                    k = -l;
                    l = l1;
                }
                k1 += k;
                j += l;
            }
            if (p_177899_) {
                ConfiguredFeature configuredfeature = (ConfiguredFeature)MiscOverworldFeatures.f_195021_.m_203334_();
                configuredfeature.m_224953_((WorldGenLevel)p_177897_, serverchunkcache.m_8481_(), p_177897_.f_46441_, new BlockPos(p_177898_.m_6789_(), p_177898_.m_6527_(), p_177898_.m_6526_()));
            }
        }
    }

    private void m_129847_(WorldData p_129848_) {
        p_129848_.m_6166_(Difficulty.PEACEFUL);
        p_129848_.m_5560_(true);
        ServerLevelData serverleveldata = p_129848_.m_5996_();
        serverleveldata.m_5565_(false);
        serverleveldata.m_5557_(false);
        serverleveldata.m_6393_(1000000000);
        serverleveldata.m_6247_(6000L);
        serverleveldata.m_5458_(GameType.SPECTATOR);
    }

    private void m_129940_(ChunkProgressListener p_129941_) {
        ServerLevel serverlevel = this.m_129783_();
        f_129750_.info("Preparing start region for dimension {}", (Object)serverlevel.m_46472_().m_135782_());
        BlockPos blockpos = serverlevel.m_220360_();
        p_129941_.m_7647_(new ChunkPos(blockpos));
        ServerChunkCache serverchunkcache = serverlevel.m_7726_();
        serverchunkcache.m_7827_().m_9310_(500);
        this.f_129726_ = Util.m_137550_();
        serverchunkcache.m_8387_(TicketType.f_9442_, new ChunkPos(blockpos), 11, Unit.INSTANCE);
        while (serverchunkcache.m_8427_() != 441) {
            this.f_129726_ = Util.m_137550_() + 10L;
            this.m_130012_();
        }
        this.f_129726_ = Util.m_137550_() + 10L;
        this.m_130012_();
        for (ServerLevel serverlevel1 : this.f_129762_.values()) {
            ForcedChunksSavedData forcedchunkssaveddata = serverlevel1.m_8895_().m_164858_(ForcedChunksSavedData::m_151483_, "chunks");
            if (forcedchunkssaveddata == null) continue;
            LongIterator longiterator = forcedchunkssaveddata.m_46116_().iterator();
            while (longiterator.hasNext()) {
                long i = longiterator.nextLong();
                ChunkPos chunkpos = new ChunkPos(i);
                serverlevel1.m_7726_().m_6692_(chunkpos, true);
            }
            ForgeChunkManager.reinstatePersistentChunks((ServerLevel)serverlevel1, (ForcedChunksSavedData)forcedchunkssaveddata);
        }
        this.f_129726_ = Util.m_137550_() + 10L;
        this.m_130012_();
        p_129941_.m_7646_();
        serverchunkcache.m_7827_().m_9310_(5);
        this.m_129962_();
    }

    public GameType m_130008_() {
        return this.f_129749_.m_5464_();
    }

    public boolean m_7035_() {
        return this.f_129749_.m_5466_();
    }

    public abstract int m_7022_();

    public abstract int m_7034_();

    public abstract boolean m_6983_();

    public boolean m_129885_(boolean p_129886_, boolean p_129887_, boolean p_129888_) {
        boolean flag = false;
        for (ServerLevel serverlevel : this.m_129785_()) {
            if (!p_129886_) {
                f_129750_.info("Saving chunks for level '{}'/{}", (Object)serverlevel, (Object)serverlevel.m_46472_().m_135782_());
            }
            serverlevel.m_8643_(null, p_129887_, serverlevel.f_8564_ && !p_129888_);
            flag = true;
        }
        ServerLevel serverlevel2 = this.m_129783_();
        ServerLevelData serverleveldata = this.f_129749_.m_5996_();
        serverleveldata.m_7831_(serverlevel2.m_6857_().m_61970_());
        this.f_129749_.m_5917_(this.m_129901_().m_136307_());
        this.f_129744_.m_78290_(this.m_206579_(), this.f_129749_, this.m_6846_().m_6960_());
        if (p_129887_) {
            for (ServerLevel serverlevel1 : this.m_129785_()) {
                f_129750_.info("ThreadedAnvilChunkStorage ({}): All chunks are saved", (Object)serverlevel1.m_7726_().f_8325_.m_182285_());
            }
            f_129750_.info("ThreadedAnvilChunkStorage: All dimensions are saved");
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean m_195514_(boolean p_195515_, boolean p_195516_, boolean p_195517_) {
        boolean flag;
        try {
            this.f_195494_ = true;
            this.m_6846_().m_11302_();
            flag = this.m_129885_(p_195515_, p_195516_, p_195517_);
        }
        finally {
            this.f_195494_ = false;
        }
        return flag;
    }

    @Override
    public void close() {
        this.m_7041_();
    }

    public void m_7041_() {
        if (this.m_130010_() && this.m_6982_()) {
            MinecraftForge.EVENT_BUS.post((Event)new GameShuttingDownEvent());
        }
        if (this.f_177872_.m_142763_()) {
            this.m_236737_();
        }
        f_129750_.info("Stopping server");
        if (this.m_129919_() != null) {
            this.m_129919_().m_9718_();
        }
        this.f_195494_ = true;
        if (this.f_129763_ != null) {
            f_129750_.info("Saving players");
            this.f_129763_.m_11302_();
            this.f_129763_.m_11313_();
        }
        f_129750_.info("Saving worlds");
        for (ServerLevel serverlevel : this.m_129785_()) {
            if (serverlevel == null) continue;
            serverlevel.f_8564_ = false;
        }
        while (this.f_129762_.values().stream().anyMatch(p_202480_ -> p_202480_.m_7726_().f_8325_.m_201907_())) {
            this.f_129726_ = Util.m_137550_() + 1L;
            for (ServerLevel serverlevel1 : this.m_129785_()) {
                serverlevel1.m_7726_().m_201915_();
                serverlevel1.m_7726_().m_201698_(() -> true, false);
            }
            this.m_130012_();
        }
        this.m_129885_(false, true, false);
        for (ServerLevel serverlevel2 : this.m_129785_()) {
            if (serverlevel2 == null) continue;
            try {
                MinecraftForge.EVENT_BUS.post((Event)new WorldEvent.Unload((LevelAccessor)serverlevel2));
                serverlevel2.close();
            }
            catch (IOException ioexception1) {
                f_129750_.error("Exception closing the level", (Throwable)ioexception1);
            }
        }
        this.f_195494_ = false;
        this.f_129740_.close();
        try {
            this.f_129744_.close();
        }
        catch (IOException ioexception) {
            f_129750_.error("Failed to unlock level {}", (Object)this.f_129744_.m_78277_(), (Object)ioexception);
        }
    }

    public String m_130009_() {
        return this.f_129760_;
    }

    public void m_129913_(String p_129914_) {
        this.f_129760_ = p_129914_;
    }

    public boolean m_130010_() {
        return this.f_129764_;
    }

    public void m_7570_(boolean p_129884_) {
        this.f_129764_ = false;
        if (p_129884_) {
            try {
                this.f_129725_.join();
            }
            catch (InterruptedException interruptedexception) {
                f_129750_.error("Error while shutting down", (Throwable)interruptedexception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void m_130011_() {
        try {
            if (!this.m_7038_()) {
                throw new IllegalStateException("Failed to initialize server");
            }
            ServerLifecycleHooks.handleServerStarted((MinecraftServer)this);
            this.f_129726_ = Util.m_137550_();
            this.f_129757_.m_134908_((Component)Component.m_237113_((String)this.f_129709_));
            this.f_129757_.m_134912_(new ServerStatus.Version(SharedConstants.m_183709_().getName(), SharedConstants.m_183709_().getProtocolVersion()));
            this.f_129757_.m_238078_(this.m_214000_());
            this.m_129878_(this.f_129757_);
            while (this.f_129764_) {
                long i = Util.m_137550_() - this.f_129726_;
                if (i > 2000L && this.f_129726_ - this.f_129718_ >= 15000L) {
                    long j = i / 50L;
                    f_129750_.warn("Can't keep up! Is the server overloaded? Running {}ms or {} ticks behind", (Object)i, (Object)j);
                    this.f_129726_ += j * 50L;
                    this.f_129718_ = this.f_129726_;
                }
                if (this.f_177877_) {
                    this.f_177877_ = false;
                    this.f_177876_ = new TimeProfiler(Util.m_137569_(), this.f_129766_);
                }
                this.f_129726_ += 50L;
                this.m_177945_();
                this.f_129754_.m_6180_("tick");
                this.m_5705_(this::m_129960_);
                this.f_129754_.m_6182_("nextTickWait");
                this.f_129728_ = true;
                this.f_129727_ = Math.max(Util.m_137550_() + 50L, this.f_129726_);
                this.m_130012_();
                this.f_129754_.m_7238_();
                this.m_177946_();
                this.f_129717_ = true;
                JvmProfiler.f_185340_.m_183597_(this.f_129737_);
            }
            ServerLifecycleHooks.handleServerStopping((MinecraftServer)this);
            ServerLifecycleHooks.expectServerStopped();
        }
        catch (Throwable throwable1) {
            f_129750_.error("Encountered an unexpected exception", throwable1);
            CrashReport crashreport = MinecraftServer.m_206568_(throwable1);
            this.m_177935_(crashreport.m_178626_());
            File file1 = new File(new File(this.m_6237_(), "crash-reports"), "crash-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "-server.txt");
            if (crashreport.m_127512_(file1)) {
                f_129750_.error("This crash report has been saved to: {}", (Object)file1.getAbsolutePath());
            } else {
                f_129750_.error("We were unable to save this crash report to disk.");
            }
            ServerLifecycleHooks.expectServerStopped();
            this.m_7268_(crashreport);
        }
        finally {
            try {
                this.f_129765_ = true;
                this.m_7041_();
            }
            catch (Throwable throwable) {
                f_129750_.error("Exception stopping the server", throwable);
            }
            finally {
                if (this.f_236721_.f_214336_() != null) {
                    this.f_236721_.f_214336_().m_196559_();
                }
                ServerLifecycleHooks.handleServerStopped((MinecraftServer)this);
                this.m_6988_();
            }
        }
    }

    private static CrashReport m_206568_(Throwable p_206569_) {
        CrashReport crashreport;
        ReportedException reportedexception = null;
        for (Throwable throwable = p_206569_; throwable != null; throwable = throwable.getCause()) {
            ReportedException reportedexception1;
            if (!(throwable instanceof ReportedException)) continue;
            reportedexception = reportedexception1 = (ReportedException)throwable;
        }
        if (reportedexception != null) {
            crashreport = reportedexception.m_134761_();
            if (reportedexception != p_206569_) {
                crashreport.m_127514_("Wrapped in").m_128162_("Wrapping exception", p_206569_);
            }
        } else {
            crashreport = new CrashReport("Exception in server tick loop", p_206569_);
        }
        return crashreport;
    }

    private boolean m_129960_() {
        return this.m_18767_() || Util.m_137550_() < (this.f_129728_ ? this.f_129727_ : this.f_129726_);
    }

    protected void m_130012_() {
        this.m_18699_();
        this.m_18701_(() -> !this.m_129960_());
    }

    protected TickTask m_6681_(Runnable p_129852_) {
        return new TickTask(this.f_129766_, p_129852_);
    }

    protected boolean m_6362_(TickTask p_129883_) {
        return p_129883_.m_136254_() + 3 < this.f_129766_ || this.m_129960_();
    }

    public boolean m_7245_() {
        boolean flag;
        this.f_129728_ = flag = this.m_129961_();
        return flag;
    }

    private boolean m_129961_() {
        if (super.m_7245_()) {
            return true;
        }
        if (this.m_129960_()) {
            for (ServerLevel serverlevel : this.m_129785_()) {
                if (!serverlevel.m_7726_().m_8466_()) continue;
                return true;
            }
        }
        return false;
    }

    public void m_6367_(TickTask p_129957_) {
        this.m_129905_().m_6174_("runTask");
        super.m_6367_((Runnable)p_129957_);
    }

    private void m_129878_(ServerStatus p_129879_) {
        Optional<File> optional = Optional.of(this.m_129971_("server-icon.png")).filter(File::isFile);
        if (!optional.isPresent()) {
            optional = this.f_129744_.m_182514_().map(Path::toFile).filter(File::isFile);
        }
        optional.ifPresent(p_202470_ -> {
            try {
                BufferedImage bufferedimage = ImageIO.read(p_202470_);
                Validate.validState((bufferedimage.getWidth() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels wide", (Object[])new Object[0]);
                Validate.validState((bufferedimage.getHeight() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels high", (Object[])new Object[0]);
                ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)bufferedimage, "PNG", bytearrayoutputstream);
                byte[] abyte = Base64.getEncoder().encode(bytearrayoutputstream.toByteArray());
                p_129879_.m_134906_("data:image/png;base64," + new String(abyte, StandardCharsets.UTF_8));
            }
            catch (Exception exception) {
                f_129750_.error("Couldn't load server icon", (Throwable)exception);
            }
        });
    }

    public Optional<Path> m_182649_() {
        return this.f_129744_.m_182514_();
    }

    public File m_6237_() {
        return new File(".");
    }

    public void m_7268_(CrashReport p_129874_) {
    }

    public void m_6988_() {
    }

    public void m_5705_(BooleanSupplier p_129871_) {
        long i = Util.m_137569_();
        ForgeEventFactory.onPreServerTick((BooleanSupplier)p_129871_);
        ++this.f_129766_;
        this.m_5703_(p_129871_);
        if (i - this.f_129724_ >= 5000000000L) {
            this.f_129724_ = i;
            this.f_129757_.m_134910_(new ServerStatus.Players(this.m_7418_(), this.m_7416_()));
            if (!this.m_183306_()) {
                GameProfile[] agameprofile = new GameProfile[Math.min(this.m_7416_(), 12)];
                int j = Mth.m_216271_((RandomSource)this.f_129758_, (int)0, (int)(this.m_7416_() - agameprofile.length));
                for (int k = 0; k < agameprofile.length; ++k) {
                    ServerPlayer serverplayer = this.f_129763_.m_11314_().get(j + k);
                    agameprofile[k] = serverplayer.m_184128_() ? serverplayer.m_36316_() : f_195496_;
                }
                Collections.shuffle(Arrays.asList(agameprofile));
                this.f_129757_.m_134914_().m_134924_(agameprofile);
            }
            this.f_129757_.invalidateJson();
        }
        if (this.f_129766_ % 6000 == 0) {
            f_129750_.debug("Autosave started");
            this.f_129754_.m_6180_("save");
            this.m_195514_(true, false, false);
            this.f_129754_.m_7238_();
            f_129750_.debug("Autosave finished");
        }
        this.f_129754_.m_6180_("tallying");
        long l = Util.m_137569_() - i;
        this.f_129748_[this.f_129766_ % 100] = l;
        long l2 = l;
        this.f_129737_ = this.f_129737_ * 0.8f + (float)l2 / 1000000.0f * 0.19999999f;
        long i1 = Util.m_137569_();
        this.f_129735_.m_13755_(i1 - i);
        this.f_129754_.m_7238_();
        ForgeEventFactory.onPostServerTick((BooleanSupplier)p_129871_);
    }

    public void m_5703_(BooleanSupplier p_129954_) {
        this.f_129754_.m_6180_("commandFunctions");
        this.m_129890_().m_136128_();
        this.f_129754_.m_6182_("levels");
        for (ServerLevel serverlevel : this.getWorldArray()) {
            long tickStart = Util.m_137569_();
            this.f_129754_.m_6521_(() -> serverlevel + " " + serverlevel.m_46472_().m_135782_());
            if (this.f_129766_ % 20 == 0) {
                this.f_129754_.m_6180_("timeSync");
                this.f_129763_.m_11270_((Packet<?>)new ClientboundSetTimePacket(serverlevel.m_46467_(), serverlevel.m_46468_(), serverlevel.m_46469_().m_46207_(GameRules.f_46140_)), serverlevel.m_46472_());
                this.f_129754_.m_7238_();
            }
            this.f_129754_.m_6180_("tick");
            ForgeEventFactory.onPreWorldTick((Level)serverlevel, (BooleanSupplier)p_129954_);
            try {
                serverlevel.m_8793_(p_129954_);
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.m_127521_(throwable, "Exception ticking world");
                serverlevel.m_6026_(crashreport);
                throw new ReportedException(crashreport);
            }
            ForgeEventFactory.onPostWorldTick((Level)serverlevel, (BooleanSupplier)p_129954_);
            this.f_129754_.m_7238_();
            this.f_129754_.m_7238_();
            this.perWorldTickTimes.computeIfAbsent(serverlevel.m_46472_(), (Function<ResourceKey, long[]>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$tickChildren$9(net.minecraft.resources.ResourceKey ), (Lnet/minecraft/resources/ResourceKey;)[J)())[this.f_129766_ % 100] = Util.m_137569_() - tickStart;
        }
        this.f_129754_.m_6182_("connection");
        this.m_129919_().m_9721_();
        this.f_129754_.m_6182_("players");
        this.f_129763_.m_11288_();
        if (ForgeGameTestHooks.isGametestEnabled()) {
            GameTestTicker.f_177648_.m_127790_();
        }
        this.f_129754_.m_6182_("server gui refresh");
        for (int i = 0; i < this.f_129752_.size(); ++i) {
            this.f_129752_.get(i).run();
        }
        this.f_129754_.m_7238_();
    }

    public boolean m_7079_() {
        return true;
    }

    public void m_129946_(Runnable p_129947_) {
        this.f_129752_.add(p_129947_);
    }

    protected void m_129948_(String p_129949_) {
        this.f_129739_ = p_129949_;
    }

    public boolean m_129782_() {
        return !this.f_129725_.isAlive();
    }

    public File m_129971_(String p_129972_) {
        return new File(this.m_6237_(), p_129972_);
    }

    public final ServerLevel m_129783_() {
        return this.f_129762_.get(Level.f_46428_);
    }

    @Nullable
    public ServerLevel m_129880_(ResourceKey<Level> p_129881_) {
        return this.f_129762_.get(p_129881_);
    }

    public Set<ResourceKey<Level>> m_129784_() {
        return this.f_129762_.keySet();
    }

    public Iterable<ServerLevel> m_129785_() {
        return this.f_129762_.values();
    }

    public String m_7630_() {
        return SharedConstants.m_183709_().getName();
    }

    public int m_7416_() {
        return this.f_129763_.m_11309_();
    }

    public int m_7418_() {
        return this.f_129763_.m_11310_();
    }

    public String[] m_7641_() {
        return this.f_129763_.m_11291_();
    }

    @DontObfuscate
    public String m_130001_() {
        return BrandingControl.getServerBranding();
    }

    public SystemReport m_177935_(SystemReport p_177936_) {
        p_177936_.m_143522_("Server Running", () -> Boolean.toString(this.f_129764_));
        if (this.f_129763_ != null) {
            p_177936_.m_143522_("Player Count", () -> this.f_129763_.m_11309_() + " / " + this.f_129763_.m_11310_() + "; " + this.f_129763_.m_11314_());
        }
        p_177936_.m_143522_("Data Packs", () -> {
            StringBuilder stringbuilder = new StringBuilder();
            for (Pack pack : this.f_129730_.m_10524_()) {
                if (stringbuilder.length() > 0) {
                    stringbuilder.append(", ");
                }
                stringbuilder.append(pack.m_10446_());
                if (pack.m_10443_().m_10489_()) continue;
                stringbuilder.append(" (incompatible)");
            }
            return stringbuilder.toString();
        });
        p_177936_.m_143522_("World Generation", () -> this.f_129749_.m_5754_().toString());
        if (this.f_129739_ != null) {
            p_177936_.m_143522_("Server Id", () -> this.f_129739_);
        }
        return this.m_142424_(p_177936_);
    }

    public abstract SystemReport m_142424_(SystemReport var1);

    public ModCheck m_183471_() {
        return ModCheck.m_184600_((String)f_195495_, this::m_130001_, (String)"Server", MinecraftServer.class);
    }

    public void m_213846_(Component p_236736_) {
        f_129750_.info(p_236736_.getString());
    }

    public KeyPair m_129790_() {
        return this.f_129712_;
    }

    public int m_7010_() {
        return this.f_129761_;
    }

    public void m_129801_(int p_129802_) {
        this.f_129761_ = p_129802_;
    }

    @Nullable
    public GameProfile m_236731_() {
        return this.f_236719_;
    }

    public void m_236740_(@Nullable GameProfile p_236741_) {
        this.f_236719_ = p_236741_;
    }

    public boolean m_129792_() {
        return this.f_236719_ != null;
    }

    protected void m_129793_() {
        f_129750_.info("Generating keypair");
        try {
            this.f_129712_ = Crypt.m_13604_();
        }
        catch (CryptException cryptexception) {
            throw new IllegalStateException("Failed to generate key pair", cryptexception);
        }
    }

    public void m_129827_(Difficulty p_129828_, boolean p_129829_) {
        if (p_129829_ || !this.f_129749_.m_5474_()) {
            this.f_129749_.m_6166_(this.f_129749_.m_5466_() ? Difficulty.HARD : p_129828_);
            this.m_129962_();
            this.m_6846_().m_11314_().forEach(this::m_129938_);
        }
    }

    public int m_7186_(int p_129935_) {
        return p_129935_;
    }

    private void m_129962_() {
        for (ServerLevel serverlevel : this.m_129785_()) {
            serverlevel.m_46703_(this.m_7004_(), this.m_6998_());
        }
    }

    public void m_129958_(boolean p_129959_) {
        this.f_129749_.m_5560_(p_129959_);
        this.m_6846_().m_11314_().forEach(this::m_129938_);
    }

    private void m_129938_(ServerPlayer p_129939_) {
        LevelData leveldata = p_129939_.m_9236_().m_6106_();
        p_129939_.f_8906_.m_9829_((Packet<?>)new ClientboundChangeDifficultyPacket(leveldata.m_5472_(), leveldata.m_5474_()));
    }

    public boolean m_7004_() {
        return this.f_129749_.m_5472_() != Difficulty.PEACEFUL;
    }

    public boolean m_129794_() {
        return this.f_129714_;
    }

    public void m_129975_(boolean p_129976_) {
        this.f_129714_ = p_129976_;
    }

    public Optional<ServerResourcePackInfo> m_214042_() {
        return Optional.empty();
    }

    public boolean m_142205_() {
        return this.m_214042_().filter(ServerResourcePackInfo::f_236745_).isPresent();
    }

    public abstract boolean m_6982_();

    public abstract int m_7032_();

    public boolean m_129797_() {
        return this.f_129705_;
    }

    public void m_129985_(boolean p_129986_) {
        this.f_129705_ = p_129986_;
    }

    public boolean m_129798_() {
        return this.f_129706_;
    }

    public void m_129993_(boolean p_129994_) {
        this.f_129706_ = p_129994_;
    }

    public boolean m_6998_() {
        return true;
    }

    public boolean m_6997_() {
        return true;
    }

    public abstract boolean m_6994_();

    public boolean m_129799_() {
        return this.f_129707_;
    }

    public void m_129997_(boolean p_129998_) {
        this.f_129707_ = p_129998_;
    }

    public boolean m_129915_() {
        return this.f_129708_;
    }

    public void m_129999_(boolean p_130000_) {
        this.f_129708_ = p_130000_;
    }

    public abstract boolean m_6993_();

    public String m_129916_() {
        return this.f_129709_;
    }

    public void m_129989_(String p_129990_) {
        this.f_129709_ = p_129990_;
    }

    public boolean m_214000_() {
        return false;
    }

    public boolean m_129918_() {
        return this.f_129765_;
    }

    public PlayerList m_6846_() {
        return this.f_129763_;
    }

    public void m_129823_(PlayerList p_129824_) {
        this.f_129763_ = p_129824_;
    }

    public abstract boolean m_6992_();

    public void m_7835_(GameType p_129832_) {
        this.f_129749_.m_5458_(p_129832_);
    }

    @Nullable
    public ServerConnectionListener m_129919_() {
        return this.f_129755_;
    }

    public boolean m_129920_() {
        return this.f_129717_;
    }

    public boolean m_6370_() {
        return false;
    }

    public boolean m_7386_(@Nullable GameType p_129833_, boolean p_129834_, int p_129835_) {
        return false;
    }

    public int m_129921_() {
        return this.f_129766_;
    }

    public int m_6396_() {
        return 16;
    }

    public boolean m_7762_(ServerLevel p_129811_, BlockPos p_129812_, Player p_129813_) {
        return false;
    }

    public boolean m_6373_() {
        return true;
    }

    public boolean m_183306_() {
        return false;
    }

    public Proxy m_177930_() {
        return this.f_129747_;
    }

    public int m_129924_() {
        return this.f_129711_;
    }

    public void m_7196_(int p_129978_) {
        this.f_129711_ = p_129978_;
    }

    public MinecraftSessionService m_129925_() {
        return this.f_236721_.f_214333_();
    }

    public SignatureValidator m_236739_() {
        return this.f_236721_.f_214334_();
    }

    public GameProfileRepository m_129926_() {
        return this.f_236721_.f_214335_();
    }

    public GameProfileCache m_129927_() {
        return this.f_236721_.f_214336_();
    }

    public ServerStatus m_129928_() {
        return this.f_129757_;
    }

    public void m_129929_() {
        this.f_129724_ = 0L;
    }

    public int m_6329_() {
        return 29999984;
    }

    public boolean m_5660_() {
        return super.m_5660_() && !this.m_129918_();
    }

    public void m_201446_(Runnable p_202482_) {
        if (this.m_129918_()) {
            throw new RejectedExecutionException("Server already shutting down");
        }
        super.m_201446_(p_202482_);
    }

    public Thread m_6304_() {
        return this.f_129725_;
    }

    public int m_6328_() {
        return 256;
    }

    public boolean m_214005_() {
        return false;
    }

    public long m_129932_() {
        return this.f_129726_;
    }

    public DataFixer m_129933_() {
        return this.f_129759_;
    }

    public int m_129803_(@Nullable ServerLevel p_129804_) {
        return p_129804_ != null ? p_129804_.m_46469_().m_46215_(GameRules.f_46147_) : 10;
    }

    public ServerAdvancementManager m_129889_() {
        return this.f_129740_.f_206585_.m_206889_();
    }

    public ServerFunctionManager m_129890_() {
        return this.f_129734_;
    }

    public CompletableFuture<Void> m_129861_(Collection<String> p_129862_) {
        RegistryAccess.Frozen registryaccess$frozen = this.m_206579_();
        CompletionStage completablefuture = ((CompletableFuture)CompletableFuture.supplyAsync(() -> (ImmutableList)p_129862_.stream().map(this.f_129730_::m_10507_).filter(Objects::nonNull).map(Pack::m_10445_).collect(ImmutableList.toImmutableList()), (Executor)((Object)this)).thenCompose(p_212913_ -> {
            MultiPackResourceManager closeableresourcemanager = new MultiPackResourceManager(PackType.SERVER_DATA, (List)p_212913_);
            return ((CompletableFuture)ReloadableServerResources.m_206861_((ResourceManager)closeableresourcemanager, registryaccess$frozen, this.m_6982_() ? Commands.CommandSelection.DEDICATED : Commands.CommandSelection.INTEGRATED, this.m_7034_(), this.f_129738_, (Executor)((Object)this)).whenComplete((arg_0, arg_1) -> MinecraftServer.lambda$reloadResources$16((CloseableResourceManager)closeableresourcemanager, arg_0, arg_1))).thenApply(arg_0 -> MinecraftServer.lambda$reloadResources$17((CloseableResourceManager)closeableresourcemanager, arg_0));
        })).thenAcceptAsync(p_212919_ -> {
            this.f_129740_.close();
            this.f_129740_ = p_212919_;
            this.f_129730_.m_10509_(p_129862_);
            this.f_129749_.m_6645_(MinecraftServer.m_129817_(this.f_129730_));
            this.f_129740_.f_206585_.m_206868_(this.m_206579_());
            this.m_6846_().m_11302_();
            this.m_6846_().m_11315_();
            this.f_129734_.m_136120_(this.f_129740_.f_206585_.m_206860_());
            this.f_236720_.m_230370_((ResourceManager)this.f_129740_.f_206584_);
            this.m_6846_().m_11314_().forEach(this.m_6846_()::m_11289_);
        }, (Executor)((Object)this));
        if (this.m_18695_()) {
            this.m_18701_(((CompletableFuture)completablefuture)::isDone);
        }
        return completablefuture;
    }

    public static DataPackConfig m_129819_(PackRepository p_129820_, DataPackConfig p_129821_, boolean p_129822_) {
        ResourcePackLoader.loadResourcePacks((PackRepository)p_129820_, ServerLifecycleHooks::buildPackFinder);
        p_129820_.m_10506_();
        DataPackConfig.f_45842_.addModPacks(ForgeHooks.getModPacks());
        p_129821_.addModPacks(ForgeHooks.getModPacks());
        if (p_129822_) {
            p_129820_.m_10509_(ForgeHooks.getModPacksWithVanilla());
            return new DataPackConfig(ForgeHooks.getModPacksWithVanilla(), (List<String>)ImmutableList.of());
        }
        LinkedHashSet set = Sets.newLinkedHashSet();
        for (String s : p_129821_.m_45850_()) {
            if (p_129820_.m_10515_(s)) {
                set.add(s);
                continue;
            }
            f_129750_.warn("Missing data pack {}", (Object)s);
        }
        for (Pack pack : p_129820_.m_10519_()) {
            String s1 = pack.m_10446_();
            if (p_129821_.m_45855_().contains(s1) || set.contains(s1)) continue;
            f_129750_.info("Found new data pack {}, loading it automatically", (Object)s1);
            set.add(s1);
        }
        if (set.isEmpty()) {
            f_129750_.info("No datapacks selected, forcing vanilla");
            set.add(f_195495_);
        }
        p_129820_.m_10509_(set);
        return MinecraftServer.m_129817_(p_129820_);
    }

    private static DataPackConfig m_129817_(PackRepository p_129818_) {
        Collection<String> collection = p_129818_.m_10523_();
        ImmutableList list = ImmutableList.copyOf(collection);
        List list1 = (List)p_129818_.m_10514_().stream().filter(p_212916_ -> !collection.contains(p_212916_)).collect(ImmutableList.toImmutableList());
        return new DataPackConfig((List<String>)list, list1);
    }

    public void m_129849_(CommandSourceStack p_129850_) {
        if (this.m_129902_()) {
            PlayerList playerlist = p_129850_.m_81377_().m_6846_();
            UserWhiteList userwhitelist = playerlist.m_11305_();
            for (ServerPlayer serverplayer : Lists.newArrayList(playerlist.m_11314_())) {
                if (userwhitelist.m_11453_(serverplayer.m_36316_())) continue;
                serverplayer.f_8906_.m_9942_((Component)Component.m_237115_((String)"multiplayer.disconnect.not_whitelisted"));
            }
        }
    }

    public PackRepository m_129891_() {
        return this.f_129730_;
    }

    public Commands m_129892_() {
        return this.f_129740_.f_206585_.m_206888_();
    }

    public CommandSourceStack m_129893_() {
        ServerLevel serverlevel = this.m_129783_();
        return new CommandSourceStack(this, serverlevel == null ? Vec3.f_82478_ : Vec3.m_82528_((Vec3i)serverlevel.m_220360_()), Vec2.f_82462_, serverlevel, 4, "Server", (Component)Component.m_237113_((String)"Server"), this, null);
    }

    public boolean m_6999_() {
        return true;
    }

    public boolean m_7028_() {
        return true;
    }

    public abstract boolean m_6102_();

    public RecipeManager m_129894_() {
        return this.f_129740_.f_206585_.m_206887_();
    }

    public ServerScoreboard m_129896_() {
        return this.f_129731_;
    }

    public CommandStorage m_129897_() {
        if (this.f_129732_ == null) {
            throw new NullPointerException("Called before server init");
        }
        return this.f_129732_;
    }

    public LootTables m_129898_() {
        return this.f_129740_.f_206585_.m_206885_();
    }

    public PredicateManager m_129899_() {
        return this.f_129740_.f_206585_.m_206881_();
    }

    public ItemModifierManager m_177926_() {
        return this.f_129740_.f_206585_.m_206886_();
    }

    public GameRules m_129900_() {
        return this.m_129783_().m_46469_();
    }

    public CustomBossEvents m_129901_() {
        return this.f_129733_;
    }

    public boolean m_129902_() {
        return this.f_129736_;
    }

    public void m_130004_(boolean p_130005_) {
        this.f_129736_ = p_130005_;
    }

    public float m_129903_() {
        return this.f_129737_;
    }

    public int m_129944_(GameProfile p_129945_) {
        if (this.m_6846_().m_11303_(p_129945_)) {
            ServerOpListEntry serveroplistentry = (ServerOpListEntry)this.m_6846_().m_11307_().m_11388_((Object)p_129945_);
            if (serveroplistentry != null) {
                return serveroplistentry.m_11363_();
            }
            if (this.m_7779_(p_129945_)) {
                return 4;
            }
            if (this.m_129792_()) {
                return this.m_6846_().m_11316_() ? 4 : 0;
            }
            return this.m_7022_();
        }
        return 0;
    }

    public FrameTimer m_129904_() {
        return this.f_129735_;
    }

    public ProfilerFiller m_129905_() {
        return this.f_129754_;
    }

    public abstract boolean m_7779_(GameProfile var1);

    @Nullable
    public long[] getTickTime(ResourceKey<Level> dim) {
        return this.perWorldTickTimes.get(dim);
    }

    @Deprecated
    public synchronized Map<ResourceKey<Level>, ServerLevel> forgeGetWorldMap() {
        return this.f_129762_;
    }

    @Deprecated
    public synchronized void markWorldsDirty() {
        ++this.worldArrayMarker;
    }

    private ServerLevel[] getWorldArray() {
        if (this.worldArrayMarker == this.worldArrayLast && this.worldArray != null) {
            return this.worldArray;
        }
        this.worldArray = (ServerLevel[])this.f_129762_.values().stream().toArray(ServerLevel[]::new);
        this.worldArrayLast = this.worldArrayMarker;
        return this.worldArray;
    }

    public void m_142116_(Path p_177911_) throws IOException {
    }

    private void m_129859_(Path p_129860_) {
        Path path = p_129860_.resolve("levels");
        try {
            for (Map.Entry<ResourceKey<Level>, ServerLevel> entry : this.f_129762_.entrySet()) {
                ResourceLocation resourcelocation = entry.getKey().m_135782_();
                Path path1 = path.resolve(resourcelocation.m_135827_()).resolve(resourcelocation.m_135815_());
                Files.createDirectories(path1, new FileAttribute[0]);
                entry.getValue().m_8786_(path1);
            }
            this.m_129983_(p_129860_.resolve("gamerules.txt"));
            this.m_129991_(p_129860_.resolve("classpath.txt"));
            this.m_129950_(p_129860_.resolve("stats.txt"));
            this.m_129995_(p_129860_.resolve("threads.txt"));
            this.m_142116_(p_129860_.resolve("server.properties.txt"));
            this.m_195521_(p_129860_.resolve("modules.txt"));
        }
        catch (IOException ioexception) {
            f_129750_.warn("Failed to save debug report", (Throwable)ioexception);
        }
    }

    private void m_129950_(Path p_129951_) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(p_129951_, new OpenOption[0]);){
            writer.write(String.format("pending_tasks: %d\n", this.m_18696_()));
            writer.write(String.format("average_tick_time: %f\n", Float.valueOf(this.m_129903_())));
            writer.write(String.format("tick_times: %s\n", Arrays.toString(this.f_129748_)));
            writer.write(String.format("queue: %s\n", Util.m_183991_()));
        }
    }

    private void m_129983_(Path p_129984_) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(p_129984_, new OpenOption[0]);){
            final ArrayList list = Lists.newArrayList();
            final GameRules gamerules = this.m_129900_();
            GameRules.m_46164_((GameRules.GameRuleTypeVisitor)new GameRules.GameRuleTypeVisitor(){

                public <T extends GameRules.Value<T>> void m_6889_(GameRules.Key<T> p_195531_, GameRules.Type<T> p_195532_) {
                    list.add(String.format("%s=%s\n", p_195531_.m_46328_(), gamerules.m_46170_(p_195531_)));
                }
            });
            for (String s : list) {
                writer.write(s);
            }
        }
    }

    private void m_129991_(Path p_129992_) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(p_129992_, new OpenOption[0]);){
            String s = System.getProperty("java.class.path");
            String s1 = System.getProperty("path.separator");
            for (String s2 : Splitter.on((String)s1).split((CharSequence)s)) {
                writer.write(s2);
                writer.write("\n");
            }
        }
    }

    private void m_129995_(Path p_129996_) throws IOException {
        ThreadMXBean threadmxbean = ManagementFactory.getThreadMXBean();
        ThreadInfo[] athreadinfo = threadmxbean.dumpAllThreads(true, true);
        Arrays.sort(athreadinfo, Comparator.comparing(ThreadInfo::getThreadName));
        try (BufferedWriter writer = Files.newBufferedWriter(p_129996_, new OpenOption[0]);){
            for (ThreadInfo threadinfo : athreadinfo) {
                writer.write(threadinfo.toString());
                ((Writer)writer).write(10);
            }
        }
    }

    private void m_195521_(Path p_195522_) throws IOException {
        block11: {
            block10: {
                try (BufferedWriter writer = Files.newBufferedWriter(p_195522_, new OpenOption[0]);){
                    ArrayList list;
                    try {
                        list = Lists.newArrayList((Iterable)NativeModuleLister.m_184666_());
                    }
                    catch (Throwable throwable1) {
                        f_129750_.warn("Failed to list native modules", throwable1);
                        break block10;
                    }
                    list.sort(Comparator.comparing(p_212910_ -> p_212910_.f_184690_));
                    Iterator $$3 = list.iterator();
                    while (true) {
                        if (!$$3.hasNext()) {
                            break block11;
                        }
                        NativeModuleLister.NativeModuleInfo nativemodulelister$nativemoduleinfo = (NativeModuleLister.NativeModuleInfo)$$3.next();
                        writer.write(nativemodulelister$nativemoduleinfo.toString());
                        ((Writer)writer).write(10);
                    }
                }
            }
            return;
        }
    }

    private void m_177945_() {
        if (this.f_177875_) {
            this.f_177872_ = ActiveMetricsRecorder.m_146132_((MetricsSamplerProvider)new ServerMetricsSamplersProvider(Util.f_137440_, this.m_6982_()), (LongSupplier)Util.f_137440_, (Executor)Util.m_183992_(), (MetricsPersister)new MetricsPersister("server"), this.f_177873_, p_212927_ -> {
                this.m_18709_(() -> this.m_129859_(p_212927_.resolve("server")));
                this.f_177874_.accept((Path)p_212927_);
            });
            this.f_177875_ = false;
        }
        this.f_129754_ = SingleTickProfiler.m_18629_((ProfilerFiller)this.f_177872_.m_142610_(), (SingleTickProfiler)SingleTickProfiler.m_18632_((String)"Server"));
        this.f_177872_.m_142759_();
        this.f_129754_.m_7242_();
    }

    private void m_177946_() {
        this.f_129754_.m_7241_();
        this.f_177872_.m_142758_();
    }

    public boolean m_177927_() {
        return this.f_177872_.m_142763_();
    }

    public void m_177923_(Consumer<ProfileResults> p_177924_, Consumer<Path> p_177925_) {
        this.f_177873_ = p_212922_ -> {
            this.m_177928_();
            p_177924_.accept((ProfileResults)p_212922_);
        };
        this.f_177874_ = p_177925_;
        this.f_177875_ = true;
    }

    public void m_177928_() {
        this.f_177872_ = InactiveMetricsRecorder.f_146153_;
    }

    public void m_177929_() {
        this.f_177872_.m_142760_();
    }

    public void m_236737_() {
        this.f_177872_.m_213832_();
        this.f_129754_ = this.f_177872_.m_142610_();
    }

    public Path m_129843_(LevelResource p_129844_) {
        return this.f_129744_.m_78283_(p_129844_);
    }

    public boolean m_6365_() {
        return true;
    }

    public StructureTemplateManager m_236738_() {
        return this.f_236720_;
    }

    public WorldData m_129910_() {
        return this.f_129749_;
    }

    public ReloadableResources getServerResources() {
        return this.f_129740_;
    }

    public RegistryAccess.Frozen m_206579_() {
        return this.f_129746_;
    }

    public TextFilter m_7950_(ServerPlayer p_129814_) {
        return TextFilter.f_143703_;
    }

    public ServerPlayerGameMode m_177933_(ServerPlayer p_177934_) {
        return this.m_129794_() ? new DemoMode(p_177934_) : new ServerPlayerGameMode(p_177934_);
    }

    @Nullable
    public GameType m_142359_() {
        return null;
    }

    public ResourceManager m_177941_() {
        return this.f_129740_.f_206584_;
    }

    public boolean m_195518_() {
        return this.f_195494_;
    }

    public boolean m_177942_() {
        return this.f_177877_ || this.f_177876_ != null;
    }

    public void m_177943_() {
        this.f_177877_ = true;
    }

    public ProfileResults m_177944_() {
        if (this.f_177876_ == null) {
            return EmptyProfileResults.f_18441_;
        }
        ProfileResults profileresults = this.f_177876_.m_177960_(Util.m_137569_(), this.f_129766_);
        this.f_177876_ = null;
        return profileresults;
    }

    public int m_213994_() {
        return 1000000;
    }

    public void m_236732_(ChatSender p_236733_, Component p_236734_) {
        f_129750_.info(Component.m_237110_((String)"chat.type.text", (Object[])new Object[]{p_236733_.f_236981_(), p_236734_}).getString());
    }

    public ChatDecorator m_236742_() {
        return ChatDecorator.f_236947_;
    }

    private static /* synthetic */ ReloadableResources lambda$reloadResources$17(CloseableResourceManager closeableresourcemanager, ReloadableServerResources p_212904_) {
        return new ReloadableResources(closeableresourcemanager, p_212904_);
    }

    private static /* synthetic */ void lambda$reloadResources$16(CloseableResourceManager closeableresourcemanager, ReloadableServerResources p_212907_, Throwable p_212908_) {
        if (p_212908_ != null) {
            closeableresourcemanager.close();
        }
    }

    private static /* synthetic */ long[] lambda$tickChildren$9(ResourceKey k) {
        return new long[100];
    }

    public record ReloadableResources(CloseableResourceManager f_206584_, ReloadableServerResources f_206585_) implements AutoCloseable
    {
        @Override
        public void close() {
            this.f_206584_.close();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ReloadableResources.class, "resourceManager;managers", "f_206584_", "f_206585_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ReloadableResources.class, "resourceManager;managers", "f_206584_", "f_206585_"}, this);
        }

        @Override
        public final boolean equals(Object p_206593_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ReloadableResources.class, "resourceManager;managers", "f_206584_", "f_206585_"}, this, p_206593_);
        }
    }

    static class TimeProfiler {
        final long f_177955_;
        final int f_177956_;

        TimeProfiler(long p_177958_, int p_177959_) {
            this.f_177955_ = p_177958_;
            this.f_177956_ = p_177959_;
        }

        ProfileResults m_177960_(final long p_177961_, final int p_177962_) {
            return new ProfileResults(){

                public List<ResultField> m_6412_(String p_177972_) {
                    return Collections.emptyList();
                }

                public boolean m_142444_(Path p_177974_) {
                    return false;
                }

                public long m_7229_() {
                    return f_177955_;
                }

                public int m_7230_() {
                    return f_177956_;
                }

                public long m_7236_() {
                    return p_177961_;
                }

                public int m_7317_() {
                    return p_177962_;
                }

                public String m_142368_() {
                    return "";
                }
            };
        }
    }

    public record ServerResourcePackInfo(String f_236743_, String f_236744_, boolean f_236745_, @Nullable Component f_236746_) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ServerResourcePackInfo.class, "url;hash;isRequired;prompt", "f_236743_", "f_236744_", "f_236745_", "f_236746_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ServerResourcePackInfo.class, "url;hash;isRequired;prompt", "f_236743_", "f_236744_", "f_236745_", "f_236746_"}, this);
        }

        @Override
        public final boolean equals(Object p_236757_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ServerResourcePackInfo.class, "url;hash;isRequired;prompt", "f_236743_", "f_236744_", "f_236745_", "f_236746_"}, this, p_236757_);
        }
    }
}

