/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.util;

import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraftforge.common.util.FakePlayer;

public class FakePlayerFactory {
    private static final GameProfile MINECRAFT = new GameProfile(UUID.fromString("41C82C87-7AfB-4024-BA57-13D2C99CAE77"), "[Minecraft]");
    private static final Map<FakePlayerKey, FakePlayer> fakePlayers = Maps.newHashMap();

    public static FakePlayer getMinecraft(ServerLevel level) {
        return FakePlayerFactory.get(level, MINECRAFT);
    }

    public static FakePlayer get(ServerLevel level, GameProfile username) {
        FakePlayerKey key = new FakePlayerKey(level, username);
        return fakePlayers.computeIfAbsent(key, FakePlayerFactory::create);
    }

    public static void unloadLevel(ServerLevel level) {
        fakePlayers.entrySet().removeIf(entry -> ((FakePlayer)((Object)((Object)entry.getValue()))).m_9236_() == level);
    }

    private static FakePlayer create(FakePlayerKey key) {
        CommonListenerCookie cookie = CommonListenerCookie.m_294081_((GameProfile)key.username());
        FakePlayer ret = new FakePlayer(key.level(), cookie.f_290628_(), cookie.f_290565_());
        new FakePlayer.NetHandler(key.level().m_7654_(), ret, cookie);
        return ret;
    }

    private record FakePlayerKey(ServerLevel level, GameProfile username) {
    }
}

