/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.network;

import java.util.Objects;
import net.minecraft.network.Connection;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkContext;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkInitialization;
import net.minecraftforge.network.NetworkInstance;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.packets.LoginWrapper;

public abstract class Channel<MSG> {
    protected final NetworkInstance instance;

    protected Channel(NetworkInstance instance) {
        this.instance = instance;
    }

    public ResourceLocation getName() {
        return this.instance.getChannelName();
    }

    public int getProtocolVersion() {
        return this.instance.getNetworkProtocolVersion();
    }

    public boolean isRemotePresent(Connection connection) {
        return NetworkContext.get(connection).getRemoteChannels().contains(this.getName());
    }

    protected abstract FriendlyByteBuf toBuffer(MSG var1);

    Packet<?> toVanillaPacket(Connection connection, MSG message) {
        ConnectionProtocol protocol = connection.getProtocol();
        boolean serverbound = connection.m_178314_() == PacketFlow.SERVERBOUND;
        FriendlyByteBuf data = this.toBuffer(message);
        if (protocol == ConnectionProtocol.LOGIN) {
            if (serverbound) {
                if (this != NetworkInitialization.LOGIN) {
                    return NetworkInitialization.LOGIN.toVanillaPacket(connection, new LoginWrapper(this.getName(), data));
                }
                return NetworkDirection.LOGIN_TO_SERVER.buildPacket(data, this.getName()).getThis();
            }
            return NetworkDirection.LOGIN_TO_CLIENT.buildPacket(data, this.getName()).getThis();
        }
        if (protocol == ConnectionProtocol.PLAY || protocol == ConnectionProtocol.CONFIGURATION) {
            NetworkDirection dir = serverbound ? NetworkDirection.PLAY_TO_SERVER : NetworkDirection.PLAY_TO_CLIENT;
            return dir.buildPacket(data, this.getName()).getThis();
        }
        throw new IllegalStateException("Unsupported protocol " + protocol.name() + " in Forge Networking Channel");
    }

    public void send(MSG msg, Connection connection) {
        connection.m_129512_(this.toVanillaPacket(connection, msg));
    }

    public void send(MSG msg, PacketDistributor.PacketTarget target) {
        target.send((Packet<?>)target.direction().buildPacket(this.toBuffer(msg), this.getName()).getThis());
    }

    public void reply(MSG msg, CustomPayloadEvent.Context context) {
        this.send(msg, context.getConnection());
    }

    @FunctionalInterface
    public static interface VersionTest {
        public static final VersionTest ACCEPT_MISSING = (status, version) -> status == Status.MISSING;
        public static final VersionTest ACCEPT_VANILLA = (status, version) -> status == Status.VANILLA;

        public static VersionTest exact(int version) {
            return (status, remoteVersion) -> status == Status.PRESENT && version == remoteVersion;
        }

        public boolean accepts(Status var1, int var2);

        default public VersionTest negate() {
            return (status, version) -> !this.accepts(status, version);
        }

        default public VersionTest and(VersionTest other) {
            Objects.requireNonNull(other);
            return (status, version) -> this.accepts(status, version) && other.accepts(status, version);
        }

        default public VersionTest or(VersionTest other) {
            Objects.requireNonNull(other);
            return (status, version) -> this.accepts(status, version) || other.accepts(status, version);
        }

        public static enum Status {
            VANILLA,
            MISSING,
            PRESENT;

        }
    }
}

