/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.network.packets;

import io.netty.buffer.Unpooled;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraftforge.event.network.CustomPayloadEvent;
import org.jetbrains.annotations.ApiStatus;

public class OpenContainer {
    private final int id;
    private final int windowId;
    private final Component name;
    private final FriendlyByteBuf additionalData;

    @ApiStatus.Internal
    public OpenContainer(MenuType<?> id, int windowId, Component name, FriendlyByteBuf additionalData) {
        this(BuiltInRegistries.f_256818_.m_7447_(id), windowId, name, additionalData);
    }

    private OpenContainer(int id, int windowId, Component name, FriendlyByteBuf additionalData) {
        this.id = id;
        this.windowId = windowId;
        this.name = name;
        this.additionalData = additionalData;
    }

    public static void encode(OpenContainer msg, FriendlyByteBuf buf) {
        buf.m_130130_(msg.id);
        buf.m_130130_(msg.windowId);
        buf.m_130083_(msg.name);
        msg.additionalData.markReaderIndex();
        buf.m_130087_(msg.additionalData.m_130052_());
        msg.additionalData.resetReaderIndex();
    }

    public static OpenContainer decode(FriendlyByteBuf buf) {
        return new OpenContainer(buf.m_130242_(), buf.m_130242_(), buf.m_130238_(), new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])buf.m_130101_(32600))));
    }

    public static void handle(OpenContainer msg, CustomPayloadEvent.Context ctx) {
        ctx.enqueueWork(() -> {
            try {
                Minecraft mc = Minecraft.m_91087_();
                Inventory inv = mc.f_91074_.m_150109_();
                MenuScreens.getScreenFactory(msg.getType(), (Minecraft)mc, (int)msg.getWindowId(), (Component)msg.getName()).ifPresent(f -> {
                    AbstractContainerMenu c = msg.getType().create(msg.getWindowId(), inv, msg.getAdditionalData());
                    Screen s = f.m_96214_(c, inv, msg.getName());
                    mc.f_91074_.f_36096_ = ((MenuAccess)s).m_6262_();
                    mc.m_91152_(s);
                });
            }
            finally {
                msg.getAdditionalData().release();
            }
        });
        ctx.setPacketHandled(true);
    }

    public final MenuType<?> getType() {
        return (MenuType)BuiltInRegistries.f_256818_.m_7942_(this.id);
    }

    public int getWindowId() {
        return this.windowId;
    }

    public Component getName() {
        return this.name;
    }

    public FriendlyByteBuf getAdditionalData() {
        return this.additionalData;
    }
}

