/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.network.packets;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.event.network.CustomPayloadEvent;

public class SpawnEntity {
    private final Entity entity;
    private final int typeId;
    private final int entityId;
    private final UUID uuid;
    private final double posX;
    private final double posY;
    private final double posZ;
    private final byte pitch;
    private final byte yaw;
    private final byte headYaw;
    private final int velX;
    private final int velY;
    private final int velZ;
    private final FriendlyByteBuf buf;

    SpawnEntity(Entity e) {
        this.entity = e;
        this.typeId = BuiltInRegistries.f_256780_.m_7447_((Object)e.m_6095_());
        this.entityId = e.m_19879_();
        this.uuid = e.m_20148_();
        this.posX = e.m_20185_();
        this.posY = e.m_20186_();
        this.posZ = e.m_20189_();
        this.pitch = (byte)Mth.m_14143_((float)(e.m_146909_() * 256.0f / 360.0f));
        this.yaw = (byte)Mth.m_14143_((float)(e.m_146908_() * 256.0f / 360.0f));
        this.headYaw = (byte)(e.m_6080_() * 256.0f / 360.0f);
        Vec3 vec3d = e.m_20184_();
        double d1 = Mth.m_14008_((double)vec3d.f_82479_, (double)-3.9, (double)3.9);
        double d2 = Mth.m_14008_((double)vec3d.f_82480_, (double)-3.9, (double)3.9);
        double d3 = Mth.m_14008_((double)vec3d.f_82481_, (double)-3.9, (double)3.9);
        this.velX = (int)(d1 * 8000.0);
        this.velY = (int)(d2 * 8000.0);
        this.velZ = (int)(d3 * 8000.0);
        this.buf = null;
    }

    private SpawnEntity(int typeId, int entityId, UUID uuid, double posX, double posY, double posZ, byte pitch, byte yaw, byte headYaw, int velX, int velY, int velZ, FriendlyByteBuf buf) {
        this.entity = null;
        this.typeId = typeId;
        this.entityId = entityId;
        this.uuid = uuid;
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.pitch = pitch;
        this.yaw = yaw;
        this.headYaw = headYaw;
        this.velX = velX;
        this.velY = velY;
        this.velZ = velZ;
        this.buf = buf;
    }

    public static void encode(SpawnEntity msg, FriendlyByteBuf buf) {
        buf.m_130130_(msg.typeId);
        buf.writeInt(msg.entityId);
        buf.writeLong(msg.uuid.getMostSignificantBits());
        buf.writeLong(msg.uuid.getLeastSignificantBits());
        buf.writeDouble(msg.posX);
        buf.writeDouble(msg.posY);
        buf.writeDouble(msg.posZ);
        buf.writeByte((int)msg.pitch);
        buf.writeByte((int)msg.yaw);
        buf.writeByte((int)msg.headYaw);
        buf.writeShort(msg.velX);
        buf.writeShort(msg.velY);
        buf.writeShort(msg.velZ);
        Entity entity = msg.entity;
        if (entity instanceof IEntityAdditionalSpawnData) {
            IEntityAdditionalSpawnData entityAdditionalSpawnData = (IEntityAdditionalSpawnData)entity;
            FriendlyByteBuf spawnDataBuffer = new FriendlyByteBuf(Unpooled.buffer());
            entityAdditionalSpawnData.writeSpawnData(spawnDataBuffer);
            buf.m_130130_(spawnDataBuffer.readableBytes());
            buf.writeBytes((ByteBuf)spawnDataBuffer);
            spawnDataBuffer.release();
        } else {
            buf.m_130130_(0);
        }
    }

    public static SpawnEntity decode(FriendlyByteBuf buf) {
        return new SpawnEntity(buf.m_130242_(), buf.readInt(), new UUID(buf.readLong(), buf.readLong()), buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readByte(), buf.readByte(), buf.readByte(), buf.readShort(), buf.readShort(), buf.readShort(), SpawnEntity.readSpawnDataPacket(buf));
    }

    private static FriendlyByteBuf readSpawnDataPacket(FriendlyByteBuf buf) {
        int count = buf.m_130242_();
        if (count > 0) {
            FriendlyByteBuf spawnDataBuffer = new FriendlyByteBuf(Unpooled.buffer());
            spawnDataBuffer.writeBytes((ByteBuf)buf, count);
            return spawnDataBuffer;
        }
        return new FriendlyByteBuf(Unpooled.buffer());
    }

    public static void handle(SpawnEntity msg, CustomPayloadEvent.Context ctx) {
        ctx.enqueueWork(() -> {
            try {
                EntityType type = (EntityType)BuiltInRegistries.f_256780_.m_7942_(msg.typeId);
                Optional<Level> world = LogicalSidedProvider.CLIENTWORLD.get(ctx.getDirection().getReceptionSide());
                Entity e = world.map(w -> type.customClientSpawn(msg, w)).orElse(null);
                if (e == null) {
                    return;
                }
                e.m_217006_(msg.posX, msg.posY, msg.posZ);
                e.m_19890_(msg.posX, msg.posY, msg.posZ, (float)(msg.yaw * 360) / 256.0f, (float)(msg.pitch * 360) / 256.0f);
                e.m_5616_((float)(msg.headYaw * 360) / 256.0f);
                e.m_5618_((float)(msg.headYaw * 360) / 256.0f);
                e.m_20234_(msg.entityId);
                e.m_20084_(msg.uuid);
                Object patt5879$temp = world.orElse(null);
                if (patt5879$temp instanceof ClientLevel) {
                    ClientLevel cworld = patt5879$temp;
                    cworld.m_104739_(e);
                }
                e.m_6001_((double)msg.velX / 8000.0, (double)msg.velY / 8000.0, (double)msg.velZ / 8000.0);
                if (e instanceof IEntityAdditionalSpawnData) {
                    IEntityAdditionalSpawnData entityAdditionalSpawnData = (IEntityAdditionalSpawnData)e;
                    entityAdditionalSpawnData.readSpawnData(msg.buf);
                }
            }
            finally {
                msg.buf.release();
            }
        });
        ctx.setPacketHandled(true);
    }

    public Entity getEntity() {
        return this.entity;
    }

    public int getTypeId() {
        return this.typeId;
    }

    public int getEntityId() {
        return this.entityId;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public double getPosX() {
        return this.posX;
    }

    public double getPosY() {
        return this.posY;
    }

    public double getPosZ() {
        return this.posZ;
    }

    public byte getPitch() {
        return this.pitch;
    }

    public byte getYaw() {
        return this.yaw;
    }

    public byte getHeadYaw() {
        return this.headYaw;
    }

    public int getVelX() {
        return this.velX;
    }

    public int getVelY() {
        return this.velY;
    }

    public int getVelZ() {
        return this.velZ;
    }

    public FriendlyByteBuf getAdditionalData() {
        return this.buf;
    }
}

