/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import org.slf4j.Logger;

public class LootTable {
    private static final Logger f_79107_ = LogUtils.getLogger();
    public static final LootTable f_79105_ = new LootTable(LootContextParamSets.f_81410_, Optional.empty(), List.of(), List.of());
    public static final LootContextParamSet f_79106_ = LootContextParamSets.f_81420_;
    public static final Codec<LootTable> f_290440_ = RecordCodecBuilder.create(p_297011_ -> p_297011_.group((App)LootContextParamSets.f_290720_.optionalFieldOf("type", (Object)f_79106_).forGetter(p_297013_ -> p_297013_.f_79108_), (App)ExtraCodecs.m_294263_(ResourceLocation.f_135803_, "random_sequence").forGetter(p_297014_ -> p_297014_.f_286958_), (App)ExtraCodecs.m_295827_(LootPool.f_290497_.listOf(), "pools", List.of()).forGetter(p_297012_ -> p_297012_.f_79109_), (App)ExtraCodecs.m_295827_(LootItemFunctions.f_291699_.listOf(), "functions", List.of()).forGetter(p_297010_ -> p_297010_.f_79110_)).apply((Applicative)p_297011_, LootTable::new));
    private final LootContextParamSet f_79108_;
    private final Optional<ResourceLocation> f_286958_;
    private final List<LootPool> f_79109_;
    private final List<LootItemFunction> f_79110_;
    private final BiFunction<ItemStack, LootContext, ItemStack> f_79111_;

    LootTable(LootContextParamSet p_287716_, Optional<ResourceLocation> p_298628_, List<LootPool> p_298771_, List<LootItemFunction> p_301234_) {
        this.f_79108_ = p_287716_;
        this.f_286958_ = p_298628_;
        this.f_79109_ = p_298771_;
        this.f_79110_ = p_301234_;
        this.f_79111_ = LootItemFunctions.m_80770_(p_301234_);
    }

    public static Consumer<ItemStack> m_246283_(ServerLevel p_287765_, Consumer<ItemStack> p_251308_) {
        return p_287570_ -> {
            if (!p_287570_.m_246617_(p_287765_.m_246046_())) {
                return;
            }
            if (p_287570_.m_41613_() < p_287570_.m_41741_()) {
                p_251308_.accept((ItemStack)p_287570_);
            } else {
                ItemStack $$4;
                for (int $$3 = p_287570_.m_41613_(); $$3 > 0; $$3 -= $$4.m_41613_()) {
                    $$4 = p_287570_.m_255036_(Math.min(p_287570_.m_41741_(), $$3));
                    p_251308_.accept($$4);
                }
            }
        };
    }

    public void m_287190_(LootParams p_287669_, Consumer<ItemStack> p_287781_) {
        this.m_79131_(new LootContext.Builder(p_287669_).m_287259_(this.f_286958_), p_287781_);
    }

    public void m_79131_(LootContext p_79132_, Consumer<ItemStack> p_79133_) {
        LootContext.VisitedEntry<LootTable> $$2 = LootContext.m_278811_(this);
        if (p_79132_.m_278759_($$2)) {
            Consumer<ItemStack> $$3 = LootItemFunction.m_80724_(this.f_79111_, p_79133_, p_79132_);
            for (LootPool $$4 : this.f_79109_) {
                $$4.m_79053_($$3, p_79132_);
            }
            p_79132_.m_278639_($$2);
        } else {
            f_79107_.warn("Detected infinite loop in loot tables");
        }
    }

    public void m_287276_(LootParams p_287748_, long p_287729_, Consumer<ItemStack> p_287583_) {
        this.m_79131_(new LootContext.Builder(p_287748_).m_78965_(p_287729_).m_287259_(this.f_286958_), LootTable.m_246283_(p_287748_.m_287182_(), p_287583_));
    }

    public void m_287228_(LootParams p_287704_, Consumer<ItemStack> p_287617_) {
        this.m_287190_(p_287704_, LootTable.m_246283_(p_287704_.m_287182_(), p_287617_));
    }

    public void m_79148_(LootContext p_79149_, Consumer<ItemStack> p_79150_) {
        this.m_79131_(p_79149_, LootTable.m_246283_(p_79149_.m_78952_(), p_79150_));
    }

    public ObjectArrayList<ItemStack> m_287214_(LootParams p_287574_, long p_287773_) {
        return this.m_230922_(new LootContext.Builder(p_287574_).m_78965_(p_287773_).m_287259_(this.f_286958_));
    }

    public ObjectArrayList<ItemStack> m_287195_(LootParams p_287616_) {
        return this.m_230922_(new LootContext.Builder(p_287616_).m_287259_(this.f_286958_));
    }

    private ObjectArrayList<ItemStack> m_230922_(LootContext p_230923_) {
        ObjectArrayList $$1 = new ObjectArrayList();
        this.m_79148_(p_230923_, arg_0 -> ((ObjectArrayList)$$1).add(arg_0));
        return $$1;
    }

    public LootContextParamSet m_79122_() {
        return this.f_79108_;
    }

    public void m_79136_(ValidationContext p_79137_) {
        for (int $$1 = 0; $$1 < this.f_79109_.size(); ++$$1) {
            this.f_79109_.get($$1).m_79051_(p_79137_.m_79365_(".pools[" + $$1 + "]"));
        }
        for (int $$2 = 0; $$2 < this.f_79110_.size(); ++$$2) {
            this.f_79110_.get($$2).m_6169_(p_79137_.m_79365_(".functions[" + $$2 + "]"));
        }
    }

    public void m_287188_(Container p_287662_, LootParams p_287743_, long p_287585_) {
        LootContext $$3 = new LootContext.Builder(p_287743_).m_78965_(p_287585_).m_287259_(this.f_286958_);
        ObjectArrayList<ItemStack> $$4 = this.m_230922_($$3);
        RandomSource $$5 = $$3.m_230907_();
        List<Integer> $$6 = this.m_230919_(p_287662_, $$5);
        this.m_230924_($$4, $$6.size(), $$5);
        for (ItemStack $$7 : $$4) {
            if ($$6.isEmpty()) {
                f_79107_.warn("Tried to over-fill a container");
                return;
            }
            if ($$7.m_41619_()) {
                p_287662_.m_6836_($$6.remove($$6.size() - 1), ItemStack.f_41583_);
                continue;
            }
            p_287662_.m_6836_($$6.remove($$6.size() - 1), $$7);
        }
    }

    private void m_230924_(ObjectArrayList<ItemStack> p_230925_, int p_230926_, RandomSource p_230927_) {
        ArrayList $$3 = Lists.newArrayList();
        ObjectListIterator $$4 = p_230925_.iterator();
        while ($$4.hasNext()) {
            ItemStack $$5 = (ItemStack)$$4.next();
            if ($$5.m_41619_()) {
                $$4.remove();
                continue;
            }
            if ($$5.m_41613_() <= 1) continue;
            $$3.add($$5);
            $$4.remove();
        }
        while (p_230926_ - p_230925_.size() - $$3.size() > 0 && !$$3.isEmpty()) {
            ItemStack $$6 = (ItemStack)$$3.remove(Mth.m_216271_(p_230927_, 0, $$3.size() - 1));
            int $$7 = Mth.m_216271_(p_230927_, 1, $$6.m_41613_() / 2);
            ItemStack $$8 = $$6.m_41620_($$7);
            if ($$6.m_41613_() > 1 && p_230927_.m_188499_()) {
                $$3.add($$6);
            } else {
                p_230925_.add((Object)$$6);
            }
            if ($$8.m_41613_() > 1 && p_230927_.m_188499_()) {
                $$3.add($$8);
                continue;
            }
            p_230925_.add((Object)$$8);
        }
        p_230925_.addAll((Collection)$$3);
        Util.m_214673_(p_230925_, p_230927_);
    }

    private List<Integer> m_230919_(Container p_230920_, RandomSource p_230921_) {
        ObjectArrayList $$2 = new ObjectArrayList();
        for (int $$3 = 0; $$3 < p_230920_.m_6643_(); ++$$3) {
            if (!p_230920_.m_8020_($$3).m_41619_()) continue;
            $$2.add((Object)$$3);
        }
        Util.m_214673_($$2, p_230921_);
        return $$2;
    }

    public static Builder m_79147_() {
        return new Builder();
    }

    public static class Builder
    implements FunctionUserBuilder<Builder> {
        private final ImmutableList.Builder<LootPool> f_79156_ = ImmutableList.builder();
        private final ImmutableList.Builder<LootItemFunction> f_79157_ = ImmutableList.builder();
        private LootContextParamSet f_79158_ = f_79106_;
        private Optional<ResourceLocation> f_287003_ = Optional.empty();

        public Builder m_79161_(LootPool.Builder p_79162_) {
            this.f_79156_.add((Object)p_79162_.m_79082_());
            return this;
        }

        public Builder m_79165_(LootContextParamSet p_79166_) {
            this.f_79158_ = p_79166_;
            return this;
        }

        public Builder m_287223_(ResourceLocation p_287667_) {
            this.f_287003_ = Optional.of(p_287667_);
            return this;
        }

        @Override
        public Builder m_79078_(LootItemFunction.Builder p_79164_) {
            this.f_79157_.add((Object)p_79164_.m_7453_());
            return this;
        }

        @Override
        public Builder m_79073_() {
            return this;
        }

        public LootTable m_79167_() {
            return new LootTable(this.f_79158_, this.f_287003_, (List<LootPool>)this.f_79156_.build(), (List<LootItemFunction>)this.f_79157_.build());
        }

        @Override
        public /* synthetic */ FunctionUserBuilder m_79073_() {
            return this.m_79073_();
        }

        @Override
        public /* synthetic */ FunctionUserBuilder m_79078_(LootItemFunction.Builder builder) {
            return this.m_79078_(builder);
        }
    }
}

