/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.google.common.collect.Lists;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSigningContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.SignedArgument;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.commands.arguments.selector.EntitySelectorParser;
import net.minecraft.network.chat.ChatDecorator;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.FilteredText;
import net.minecraftforge.common.ForgeHooks;

public class MessageArgument
implements SignedArgument<Message> {
    private static final Collection<String> f_96829_ = Arrays.asList("Hello world!", "foo", "@e", "Hello @p :)");

    public static MessageArgument m_96832_() {
        return new MessageArgument();
    }

    public static Component m_96835_(CommandContext<CommandSourceStack> p_96836_, String p_96837_) throws CommandSyntaxException {
        Message messageargument$message = (Message)p_96836_.getArgument(p_96837_, Message.class);
        return messageargument$message.m_232196_((CommandSourceStack)p_96836_.getSource());
    }

    public static void m_245478_(CommandContext<CommandSourceStack> p_249433_, String p_248718_, Consumer<PlayerChatMessage> p_249460_) throws CommandSyntaxException {
        Message messageargument$message = (Message)p_249433_.getArgument(p_248718_, Message.class);
        CommandSourceStack commandsourcestack = (CommandSourceStack)p_249433_.getSource();
        Component component = messageargument$message.m_232196_(commandsourcestack);
        CommandSigningContext commandsigningcontext = commandsourcestack.m_230898_();
        PlayerChatMessage playerchatmessage = commandsigningcontext.m_213987_(p_248718_);
        if (playerchatmessage != null) {
            MessageArgument.m_247736_(p_249460_, commandsourcestack, playerchatmessage.m_241956_(component));
        } else {
            MessageArgument.m_247098_(p_249460_, commandsourcestack, PlayerChatMessage.m_247306_((String)messageargument$message.f_96841_).m_241956_(component));
        }
    }

    private static void m_247736_(Consumer<PlayerChatMessage> p_250000_, CommandSourceStack p_252335_, PlayerChatMessage p_249420_) {
        MinecraftServer minecraftserver = p_252335_.m_81377_();
        CompletableFuture<FilteredText> completablefuture = MessageArgument.m_246606_(p_252335_, p_249420_);
        Component component = minecraftserver.m_236742_().m_236961_(p_252335_.m_230896_(), p_249420_.m_245692_());
        p_252335_.m_241923_().m_241849_(p_296321_ -> completablefuture.thenAcceptAsync(p_296325_ -> {
            PlayerChatMessage playerchatmessage = p_249420_.m_241956_(component).m_243072_(p_296325_.f_243010_());
            p_250000_.accept(playerchatmessage);
        }, p_296321_));
    }

    private static void m_247098_(Consumer<PlayerChatMessage> p_249162_, CommandSourceStack p_248759_, PlayerChatMessage p_252332_) {
        ChatDecorator chatdecorator = p_248759_.m_81377_().m_236742_();
        Component component = chatdecorator.m_236961_(p_248759_.m_230896_(), p_252332_.m_245692_());
        p_249162_.accept(p_252332_.m_241956_(component));
    }

    private static CompletableFuture<FilteredText> m_246606_(CommandSourceStack p_252063_, PlayerChatMessage p_251184_) {
        ServerPlayer serverplayer = p_252063_.m_230896_();
        return serverplayer != null && p_251184_.m_243088_(serverplayer.m_20148_()) ? serverplayer.m_8967_().m_6770_(p_251184_.m_245728_()) : CompletableFuture.completedFuture(FilteredText.m_243054_((String)p_251184_.m_245728_()));
    }

    public Message parse(StringReader p_96834_) throws CommandSyntaxException {
        return Message.m_96846_(p_96834_, true);
    }

    public Collection<String> getExamples() {
        return f_96829_;
    }

    public static class Message {
        final String f_96841_;
        private final Part[] f_96842_;

        public Message(String p_96844_, Part[] p_96845_) {
            this.f_96841_ = p_96844_;
            this.f_96842_ = p_96845_;
        }

        public String m_169112_() {
            return this.f_96841_;
        }

        public Part[] m_169113_() {
            return this.f_96842_;
        }

        Component m_232196_(CommandSourceStack p_232197_) throws CommandSyntaxException {
            return this.m_96849_(p_232197_, ForgeHooks.canUseEntitySelectors((SharedSuggestionProvider)p_232197_));
        }

        public Component m_96849_(CommandSourceStack p_96850_, boolean p_96851_) throws CommandSyntaxException {
            if (this.f_96842_.length != 0 && p_96851_) {
                MutableComponent mutablecomponent = Component.m_237113_((String)this.f_96841_.substring(0, this.f_96842_[0].m_96859_()));
                int i = this.f_96842_[0].m_96859_();
                for (Part messageargument$part : this.f_96842_) {
                    Component component = messageargument$part.m_96860_(p_96850_);
                    if (i < messageargument$part.m_96859_()) {
                        mutablecomponent.m_130946_(this.f_96841_.substring(i, messageargument$part.m_96859_()));
                    }
                    if (component != null) {
                        mutablecomponent.m_7220_(component);
                    }
                    i = messageargument$part.m_96862_();
                }
                if (i < this.f_96841_.length()) {
                    mutablecomponent.m_130946_(this.f_96841_.substring(i));
                }
                return mutablecomponent;
            }
            return Component.m_237113_((String)this.f_96841_);
        }

        public static Message m_96846_(StringReader p_96847_, boolean p_96848_) throws CommandSyntaxException {
            String s = p_96847_.getString().substring(p_96847_.getCursor(), p_96847_.getTotalLength());
            if (!p_96848_) {
                p_96847_.setCursor(p_96847_.getTotalLength());
                return new Message(s, new Part[0]);
            }
            ArrayList list = Lists.newArrayList();
            int i = p_96847_.getCursor();
            while (true) {
                EntitySelector entityselector;
                int j;
                block7: {
                    if (!p_96847_.canRead()) {
                        return new Message(s, list.toArray(new Part[0]));
                    }
                    if (p_96847_.peek() == '@') {
                        j = p_96847_.getCursor();
                        try {
                            EntitySelectorParser entityselectorparser = new EntitySelectorParser(p_96847_);
                            entityselector = entityselectorparser.m_121377_();
                            break block7;
                        }
                        catch (CommandSyntaxException commandsyntaxexception) {
                            if (commandsyntaxexception.getType() != EntitySelectorParser.f_121193_ && commandsyntaxexception.getType() != EntitySelectorParser.f_121191_) {
                                throw commandsyntaxexception;
                            }
                            p_96847_.setCursor(j + 1);
                            continue;
                        }
                    }
                    p_96847_.skip();
                    continue;
                }
                list.add(new Part(j - i, p_96847_.getCursor() - i, entityselector));
            }
        }
    }

    public static class Part {
        private final int f_96852_;
        private final int f_96853_;
        private final EntitySelector f_96854_;

        public Part(int p_96856_, int p_96857_, EntitySelector p_96858_) {
            this.f_96852_ = p_96856_;
            this.f_96853_ = p_96857_;
            this.f_96854_ = p_96858_;
        }

        public int m_96859_() {
            return this.f_96852_;
        }

        public int m_96862_() {
            return this.f_96853_;
        }

        public EntitySelector m_169114_() {
            return this.f_96854_;
        }

        @Nullable
        public Component m_96860_(CommandSourceStack p_96861_) throws CommandSyntaxException {
            return EntitySelector.m_175103_(this.f_96854_.m_121160_(p_96861_));
        }
    }
}

