/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.gossip;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.DoublePredicate;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.UUIDUtil;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.entity.ai.gossip.GossipType;
import org.slf4j.Logger;

public class GossipContainer {
    private static final Logger f_262760_ = LogUtils.getLogger();
    public static final int f_148158_ = 2;
    private final Map<UUID, EntityGossips> f_26156_ = Maps.newHashMap();

    @VisibleForDebug
    public Map<UUID, Object2IntMap<GossipType>> m_148159_() {
        HashMap $$0 = Maps.newHashMap();
        this.f_26156_.keySet().forEach(p_148167_ -> {
            EntityGossips $$2 = this.f_26156_.get(p_148167_);
            $$0.put(p_148167_, $$2.f_26204_);
        });
        return $$0;
    }

    public void m_26198_() {
        Iterator<EntityGossips> $$0 = this.f_26156_.values().iterator();
        while ($$0.hasNext()) {
            EntityGossips $$1 = $$0.next();
            $$1.m_26208_();
            if (!$$1.m_26225_()) continue;
            $$0.remove();
        }
    }

    private Stream<GossipEntry> m_26203_() {
        return this.f_26156_.entrySet().stream().flatMap(p_26185_ -> ((EntityGossips)p_26185_.getValue()).m_26215_((UUID)p_26185_.getKey()));
    }

    private Collection<GossipEntry> m_217759_(RandomSource p_217760_, int p_217761_) {
        List<GossipEntry> $$2 = this.m_26203_().toList();
        if ($$2.isEmpty()) {
            return Collections.emptyList();
        }
        int[] $$3 = new int[$$2.size()];
        int $$4 = 0;
        for (int $$5 = 0; $$5 < $$2.size(); ++$$5) {
            GossipEntry $$6 = $$2.get($$5);
            $$3[$$5] = ($$4 += Math.abs($$6.m_26235_())) - 1;
        }
        Set $$7 = Sets.newIdentityHashSet();
        for (int $$8 = 0; $$8 < p_217761_; ++$$8) {
            int $$9 = p_217760_.m_188503_($$4);
            int $$10 = Arrays.binarySearch($$3, $$9);
            $$7.add($$2.get($$10 < 0 ? -$$10 - 1 : $$10));
        }
        return $$7;
    }

    private EntityGossips m_26189_(UUID p_26190_) {
        return this.f_26156_.computeIfAbsent(p_26190_, p_26202_ -> new EntityGossips());
    }

    public void m_217762_(GossipContainer p_217763_, RandomSource p_217764_, int p_217765_) {
        Collection<GossipEntry> $$3 = p_217763_.m_217759_(p_217764_, p_217765_);
        $$3.forEach(p_26200_ -> {
            int $$1 = p_26200_.f_26230_ - p_26200_.f_26229_.f_26277_;
            if ($$1 >= 2) {
                this.m_26189_((UUID)p_26200_.f_26228_).f_26204_.mergeInt((Object)p_26200_.f_26229_, $$1, GossipContainer::m_26158_);
            }
        });
    }

    public int m_26195_(UUID p_26196_, Predicate<GossipType> p_26197_) {
        EntityGossips $$2 = this.f_26156_.get(p_26196_);
        return $$2 != null ? $$2.m_26220_(p_26197_) : 0;
    }

    public long m_148162_(GossipType p_148163_, DoublePredicate p_148164_) {
        return this.f_26156_.values().stream().filter(p_148174_ -> p_148164_.test(p_148174_.f_26204_.getOrDefault((Object)p_148163_, 0) * p_148173_.f_26274_)).count();
    }

    public void m_26191_(UUID p_26192_, GossipType p_26193_, int p_26194_) {
        EntityGossips $$3 = this.m_26189_(p_26192_);
        $$3.f_26204_.mergeInt((Object)p_26193_, p_26194_, (p_186096_, p_186097_) -> this.m_26167_(p_26193_, p_186096_, p_186097_));
        $$3.m_26211_(p_26193_);
        if ($$3.m_26225_()) {
            this.f_26156_.remove(p_26192_);
        }
    }

    public void m_148175_(UUID p_148176_, GossipType p_148177_, int p_148178_) {
        this.m_26191_(p_148176_, p_148177_, -p_148178_);
    }

    public void m_148168_(UUID p_148169_, GossipType p_148170_) {
        EntityGossips $$2 = this.f_26156_.get(p_148169_);
        if ($$2 != null) {
            $$2.m_26226_(p_148170_);
            if ($$2.m_26225_()) {
                this.f_26156_.remove(p_148169_);
            }
        }
    }

    public void m_148160_(GossipType p_148161_) {
        Iterator<EntityGossips> $$1 = this.f_26156_.values().iterator();
        while ($$1.hasNext()) {
            EntityGossips $$2 = $$1.next();
            $$2.m_26226_(p_148161_);
            if (!$$2.m_26225_()) continue;
            $$1.remove();
        }
    }

    public <T> T m_262795_(DynamicOps<T> p_262915_) {
        return (T)GossipEntry.f_262751_.encodeStart(p_262915_, this.m_26203_().toList()).resultOrPartial(p_262900_ -> f_262760_.warn("Failed to serialize gossips: {}", p_262900_)).orElseGet(() -> p_262915_.emptyList());
    }

    public void m_26177_(Dynamic<?> p_26178_) {
        GossipEntry.f_262751_.decode(p_26178_).resultOrPartial(p_262901_ -> f_262760_.warn("Failed to deserialize gossips: {}", p_262901_)).stream().flatMap(p_262899_ -> ((List)p_262899_.getFirst()).stream()).forEach(p_26162_ -> this.m_26189_((UUID)p_26162_.f_26228_).f_26204_.put((Object)p_26162_.f_26229_, p_26162_.f_26230_));
    }

    private static int m_26158_(int p_26159_, int p_26160_) {
        return Math.max(p_26159_, p_26160_);
    }

    private int m_26167_(GossipType p_26168_, int p_26169_, int p_26170_) {
        int $$3 = p_26169_ + p_26170_;
        return $$3 > p_26168_.f_26275_ ? Math.max(p_26168_.f_26275_, p_26169_) : $$3;
    }

    static class EntityGossips {
        final Object2IntMap<GossipType> f_26204_ = new Object2IntOpenHashMap();

        EntityGossips() {
        }

        public int m_26220_(Predicate<GossipType> p_26221_) {
            return this.f_26204_.object2IntEntrySet().stream().filter(p_26224_ -> p_26221_.test((GossipType)p_26224_.getKey())).mapToInt(p_26214_ -> p_26214_.getIntValue() * ((GossipType)p_26214_.getKey()).f_26274_).sum();
        }

        public Stream<GossipEntry> m_26215_(UUID p_26216_) {
            return this.f_26204_.object2IntEntrySet().stream().map(p_26219_ -> new GossipEntry(p_26216_, (GossipType)p_26219_.getKey(), p_26219_.getIntValue()));
        }

        public void m_26208_() {
            ObjectIterator $$0 = this.f_26204_.object2IntEntrySet().iterator();
            while ($$0.hasNext()) {
                Object2IntMap.Entry $$1 = (Object2IntMap.Entry)$$0.next();
                int $$2 = $$1.getIntValue() - ((GossipType)$$1.getKey()).f_26276_;
                if ($$2 < 2) {
                    $$0.remove();
                    continue;
                }
                $$1.setValue($$2);
            }
        }

        public boolean m_26225_() {
            return this.f_26204_.isEmpty();
        }

        public void m_26211_(GossipType p_26212_) {
            int $$1 = this.f_26204_.getInt((Object)p_26212_);
            if ($$1 > p_26212_.f_26275_) {
                this.f_26204_.put((Object)p_26212_, p_26212_.f_26275_);
            }
            if ($$1 < 2) {
                this.m_26226_(p_26212_);
            }
        }

        public void m_26226_(GossipType p_26227_) {
            this.f_26204_.removeInt((Object)p_26227_);
        }
    }

    record GossipEntry(UUID f_26228_, GossipType f_26229_, int f_26230_) {
        public static final Codec<GossipEntry> f_262739_ = RecordCodecBuilder.create(p_263007_ -> p_263007_.group((App)UUIDUtil.f_235867_.fieldOf("Target").forGetter(GossipEntry::f_26228_), (App)GossipType.f_262726_.fieldOf("Type").forGetter(GossipEntry::f_26229_), (App)ExtraCodecs.f_144629_.fieldOf("Value").forGetter(GossipEntry::f_26230_)).apply((Applicative)p_263007_, GossipEntry::new));
        public static final Codec<List<GossipEntry>> f_262751_ = f_262739_.listOf();

        public int m_26235_() {
            return this.f_26230_ * this.f_26229_.f_26274_;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{GossipEntry.class, "target;type;value", "f_26228_", "f_26229_", "f_26230_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{GossipEntry.class, "target;type;value", "f_26228_", "f_26229_", "f_26230_"}, this);
        }

        @Override
        public final boolean equals(Object p_263014_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{GossipEntry.class, "target;type;value", "f_26228_", "f_26229_", "f_26230_"}, this, p_263014_);
        }
    }
}

