/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block.model;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.ItemOverride;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BuiltInModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.RenderTypeGroup;
import net.minecraftforge.client.model.ExtendedBlockModelDeserializer;
import net.minecraftforge.client.model.geometry.BlockGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.UnbakedGeometryHelper;
import org.joml.Matrix4f;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class BlockModel
implements UnbakedModel {
    private static final Logger f_111420_ = LogUtils.getLogger();
    private static final FaceBakery f_111421_ = new FaceBakery();
    @VisibleForTesting
    static final Gson f_111415_ = new GsonBuilder().registerTypeAdapter(BlockModel.class, (Object)new Deserializer()).registerTypeAdapter(BlockElement.class, (Object)new BlockElement.Deserializer()).registerTypeAdapter(BlockElementFace.class, (Object)new BlockElementFace.Deserializer()).registerTypeAdapter(BlockFaceUV.class, (Object)new BlockFaceUV.Deserializer()).registerTypeAdapter(ItemTransform.class, (Object)new ItemTransform.Deserializer()).registerTypeAdapter(ItemTransforms.class, (Object)new ItemTransforms.Deserializer()).registerTypeAdapter(ItemOverride.class, (Object)new ItemOverride.Deserializer()).create();
    private static final char f_173419_ = '#';
    public static final String f_173418_ = "particle";
    private static final boolean f_271537_ = true;
    private final List<BlockElement> f_111422_;
    @Nullable
    private final GuiLight f_111423_;
    @Nullable
    public final Boolean f_111424_;
    private final ItemTransforms f_111425_;
    private final List<ItemOverride> f_111426_;
    public String f_111416_ = "";
    @VisibleForTesting
    public final Map<String, Either<Material, String>> f_111417_;
    @Nullable
    public BlockModel f_111418_;
    @Nullable
    protected ResourceLocation f_111419_;
    public final BlockGeometryBakingContext customData = new BlockGeometryBakingContext(this);

    public static BlockModel m_111461_(Reader p_111462_) {
        return (BlockModel)GsonHelper.m_13776_((Gson)ExtendedBlockModelDeserializer.INSTANCE, (Reader)p_111462_, BlockModel.class);
    }

    public static BlockModel m_111463_(String p_111464_) {
        return BlockModel.m_111461_(new StringReader(p_111464_));
    }

    public BlockModel(@Nullable ResourceLocation p_273263_, List<BlockElement> p_272668_, Map<String, Either<Material, String>> p_272821_, @Nullable Boolean p_272676_, @Nullable GuiLight p_273072_, ItemTransforms p_273480_, List<ItemOverride> p_273099_) {
        this.f_111422_ = p_272668_;
        this.f_111424_ = p_272676_;
        this.f_111423_ = p_273072_;
        this.f_111417_ = p_272821_;
        this.f_111419_ = p_273263_;
        this.f_111425_ = p_273480_;
        this.f_111426_ = p_273099_;
    }

    @Deprecated
    public List<BlockElement> m_111436_() {
        if (this.customData.hasCustomGeometry()) {
            return Collections.emptyList();
        }
        return this.f_111422_.isEmpty() && this.f_111418_ != null ? this.f_111418_.m_111436_() : this.f_111422_;
    }

    @Nullable
    public ResourceLocation getParentLocation() {
        return this.f_111419_;
    }

    public boolean m_111476_() {
        if (this.f_111424_ != null) {
            return this.f_111424_;
        }
        return this.f_111418_ != null ? this.f_111418_.m_111476_() : true;
    }

    public GuiLight m_111479_() {
        if (this.f_111423_ != null) {
            return this.f_111423_;
        }
        return this.f_111418_ != null ? this.f_111418_.m_111479_() : GuiLight.SIDE;
    }

    public boolean m_173420_() {
        return this.f_111419_ == null || this.f_111418_ != null && this.f_111418_.m_173420_();
    }

    public List<ItemOverride> m_111484_() {
        return this.f_111426_;
    }

    private ItemOverrides m_246736_(ModelBaker p_250138_, BlockModel p_251800_) {
        return this.f_111426_.isEmpty() ? ItemOverrides.f_111734_ : new ItemOverrides(p_250138_, p_251800_, this.f_111426_);
    }

    public ItemOverrides getOverrides(ModelBaker p_250138_, BlockModel p_251800_, Function<Material, TextureAtlasSprite> spriteGetter) {
        return this.f_111426_.isEmpty() ? ItemOverrides.f_111734_ : new ItemOverrides(p_250138_, p_251800_, this.f_111426_, spriteGetter);
    }

    public Collection<ResourceLocation> m_7970_() {
        HashSet set = Sets.newHashSet();
        for (ItemOverride itemoverride : this.f_111426_) {
            set.add(itemoverride.m_111718_());
        }
        if (this.f_111419_ != null) {
            set.add(this.f_111419_);
        }
        return set;
    }

    public void m_5500_(Function<ResourceLocation, UnbakedModel> p_249059_) {
        if (this.customData.hasCustomGeometry()) {
            this.customData.getCustomGeometry().resolveParents(p_249059_, (IGeometryBakingContext)this.customData);
        }
        LinkedHashSet set = Sets.newLinkedHashSet();
        BlockModel blockmodel = this;
        while (blockmodel.f_111419_ != null && blockmodel.f_111418_ == null) {
            set.add(blockmodel);
            UnbakedModel unbakedmodel = p_249059_.apply(blockmodel.f_111419_);
            if (unbakedmodel == null) {
                f_111420_.warn("No parent '{}' while loading model '{}'", (Object)this.f_111419_, (Object)blockmodel);
            }
            if (set.contains(unbakedmodel)) {
                f_111420_.warn("Found 'parent' loop while loading model '{}' in chain: {} -> {}", new Object[]{blockmodel, set.stream().map(Object::toString).collect(Collectors.joining(" -> ")), this.f_111419_});
                unbakedmodel = null;
            }
            if (unbakedmodel == null) {
                blockmodel.f_111419_ = ModelBakery.f_119230_;
                unbakedmodel = p_249059_.apply(blockmodel.f_111419_);
            }
            if (!(unbakedmodel instanceof BlockModel)) {
                throw new IllegalStateException("BlockModel parent has to be a block model.");
            }
            blockmodel = blockmodel.f_111418_ = (BlockModel)unbakedmodel;
        }
        this.f_111426_.forEach(p_247932_ -> {
            UnbakedModel unbakedmodel1 = (UnbakedModel)p_249059_.apply(p_247932_.m_111718_());
            if (!Objects.equals(unbakedmodel1, this)) {
                unbakedmodel1.m_5500_(p_249059_);
            }
        });
    }

    @Deprecated
    public BakedModel m_7611_(ModelBaker p_252120_, Function<Material, TextureAtlasSprite> p_250023_, ModelState p_251130_, ResourceLocation p_252208_) {
        return this.m_111449_(p_252120_, this, p_250023_, p_251130_, p_252208_, true);
    }

    public BakedModel m_111449_(ModelBaker p_249720_, BlockModel p_111451_, Function<Material, TextureAtlasSprite> p_111452_, ModelState p_111453_, ResourceLocation p_111454_, boolean p_111455_) {
        return UnbakedGeometryHelper.bake((BlockModel)this, (ModelBaker)p_249720_, (BlockModel)p_111451_, p_111452_, (ModelState)p_111453_, (ResourceLocation)p_111454_, (boolean)p_111455_);
    }

    private BakedModel bakeVanilla(ModelBaker p_249720_, BlockModel p_111451_, Function<Material, TextureAtlasSprite> p_111452_, ModelState p_111453_, ResourceLocation p_111454_, boolean p_111455_, RenderTypeGroup renderTypes) {
        TextureAtlasSprite textureatlassprite = p_111452_.apply(this.m_111480_(f_173418_));
        if (this.m_111490_() == ModelBakery.f_119233_) {
            return new BuiltInModel(this.m_111491_(), this.m_246736_(p_249720_, p_111451_), textureatlassprite, this.m_111479_().m_111526_());
        }
        SimpleBakedModel.Builder simplebakedmodel$builder = new SimpleBakedModel.Builder(this, this.m_246736_(p_249720_, p_111451_), p_111455_).m_119528_(textureatlassprite);
        for (BlockElement blockelement : this.m_111436_()) {
            for (Direction direction : blockelement.f_111310_.keySet()) {
                BlockElementFace blockelementface = blockelement.f_111310_.get(direction);
                TextureAtlasSprite textureatlassprite1 = p_111452_.apply(this.m_111480_(blockelementface.f_111356_));
                if (blockelementface.f_111354_ == null) {
                    simplebakedmodel$builder.m_119526_(BlockModel.m_111437_(blockelement, blockelementface, textureatlassprite1, direction, p_111453_, p_111454_));
                    continue;
                }
                simplebakedmodel$builder.m_119530_(Direction.m_252919_((Matrix4f)p_111453_.m_6189_().m_252783_(), (Direction)blockelementface.f_111354_), BlockModel.m_111437_(blockelement, blockelementface, textureatlassprite1, direction, p_111453_, p_111454_));
            }
        }
        return simplebakedmodel$builder.m_119533_();
    }

    public static BakedQuad m_111437_(BlockElement p_111438_, BlockElementFace p_111439_, TextureAtlasSprite p_111440_, Direction p_111441_, ModelState p_111442_, ResourceLocation p_111443_) {
        return f_111421_.m_111600_(p_111438_.f_111308_, p_111438_.f_111309_, p_111439_, p_111440_, p_111441_, p_111442_, p_111438_.f_111311_, p_111438_.f_111312_, p_111443_);
    }

    public boolean m_111477_(String p_111478_) {
        return !MissingTextureAtlasSprite.m_118071_().equals(this.m_111480_(p_111478_).m_119203_());
    }

    public Material m_111480_(String p_111481_) {
        if (BlockModel.m_111488_(p_111481_)) {
            p_111481_ = p_111481_.substring(1);
        }
        ArrayList list = Lists.newArrayList();
        Either<Material, String> either;
        Optional optional;
        while (!(optional = (either = this.m_111485_(p_111481_)).left()).isPresent()) {
            p_111481_ = (String)either.right().get();
            if (list.contains(p_111481_)) {
                f_111420_.warn("Unable to resolve texture due to reference chain {}->{} in {}", new Object[]{Joiner.on((String)"->").join((Iterable)list), p_111481_, this.f_111416_});
                return new Material(TextureAtlas.f_118259_, MissingTextureAtlasSprite.m_118071_());
            }
            list.add(p_111481_);
        }
        return (Material)optional.get();
    }

    private Either<Material, String> m_111485_(String p_111486_) {
        BlockModel blockmodel = this;
        while (blockmodel != null) {
            Either<Material, String> either = blockmodel.f_111417_.get(p_111486_);
            if (either != null) {
                return either;
            }
            blockmodel = blockmodel.f_111418_;
        }
        return Either.left((Object)new Material(TextureAtlas.f_118259_, MissingTextureAtlasSprite.m_118071_()));
    }

    static boolean m_111488_(String p_111489_) {
        return p_111489_.charAt(0) == '#';
    }

    public BlockModel m_111490_() {
        return this.f_111418_ == null ? this : this.f_111418_.m_111490_();
    }

    public ItemTransforms m_111491_() {
        ItemTransform itemtransform = this.m_269178_(ItemDisplayContext.THIRD_PERSON_LEFT_HAND);
        ItemTransform itemtransform1 = this.m_269178_(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND);
        ItemTransform itemtransform2 = this.m_269178_(ItemDisplayContext.FIRST_PERSON_LEFT_HAND);
        ItemTransform itemtransform3 = this.m_269178_(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND);
        ItemTransform itemtransform4 = this.m_269178_(ItemDisplayContext.HEAD);
        ItemTransform itemtransform5 = this.m_269178_(ItemDisplayContext.GUI);
        ItemTransform itemtransform6 = this.m_269178_(ItemDisplayContext.GROUND);
        ItemTransform itemtransform7 = this.m_269178_(ItemDisplayContext.FIXED);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ItemDisplayContext type : ItemDisplayContext.values()) {
            ItemTransform transform;
            if (!type.isModded() || (transform = this.m_269178_(type)) == ItemTransform.f_111754_) continue;
            builder.put((Object)type, (Object)transform);
        }
        return new ItemTransforms(itemtransform, itemtransform1, itemtransform2, itemtransform3, itemtransform4, itemtransform5, itemtransform6, itemtransform7, (ImmutableMap<ItemDisplayContext, ItemTransform>)builder.build());
    }

    private ItemTransform m_269178_(ItemDisplayContext p_270662_) {
        return this.f_111418_ != null && !this.f_111425_.m_269504_(p_270662_) ? this.f_111418_.m_269178_(p_270662_) : this.f_111425_.m_269404_(p_270662_);
    }

    public String toString() {
        return this.f_111416_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final class GuiLight
    extends Enum<GuiLight> {
        public static final /* enum */ GuiLight FRONT = new GuiLight("front");
        public static final /* enum */ GuiLight SIDE = new GuiLight("side");
        private final String f_111519_;
        private static final /* synthetic */ GuiLight[] $VALUES;

        public static GuiLight[] values() {
            return (GuiLight[])$VALUES.clone();
        }

        public static GuiLight valueOf(String p_111530_) {
            return Enum.valueOf(GuiLight.class, p_111530_);
        }

        private GuiLight(String p_111525_) {
            this.f_111519_ = p_111525_;
        }

        public static GuiLight m_111527_(String p_111528_) {
            for (GuiLight blockmodel$guilight : GuiLight.values()) {
                if (!blockmodel$guilight.f_111519_.equals(p_111528_)) continue;
                return blockmodel$guilight;
            }
            throw new IllegalArgumentException("Invalid gui light: " + p_111528_);
        }

        public boolean m_111526_() {
            return this == SIDE;
        }

        public String getSerializedName() {
            return this.f_111519_;
        }

        private static /* synthetic */ GuiLight[] m_173422_() {
            return new GuiLight[]{FRONT, SIDE};
        }

        static {
            $VALUES = GuiLight.m_173422_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Deserializer
    implements JsonDeserializer<BlockModel> {
        public BlockModel deserialize(JsonElement p_111498_, Type p_111499_, JsonDeserializationContext p_111500_) throws JsonParseException {
            JsonObject jsonobject = p_111498_.getAsJsonObject();
            List<BlockElement> list = this.m_111506_(p_111500_, jsonobject);
            String s = this.m_111511_(jsonobject);
            Map<String, Either<Material, String>> map = this.m_111509_(jsonobject);
            Boolean obool = this.m_271865_(jsonobject);
            ItemTransforms itemtransforms = ItemTransforms.f_111786_;
            if (jsonobject.has("display")) {
                JsonObject jsonobject1 = GsonHelper.m_13930_((JsonObject)jsonobject, (String)"display");
                itemtransforms = (ItemTransforms)p_111500_.deserialize((JsonElement)jsonobject1, ItemTransforms.class);
            }
            List<ItemOverride> list1 = this.m_111494_(p_111500_, jsonobject);
            GuiLight blockmodel$guilight = null;
            if (jsonobject.has("gui_light")) {
                blockmodel$guilight = GuiLight.m_111527_(GsonHelper.m_13906_((JsonObject)jsonobject, (String)"gui_light"));
            }
            ResourceLocation resourcelocation = s.isEmpty() ? null : new ResourceLocation(s);
            return new BlockModel(resourcelocation, list, map, obool, blockmodel$guilight, itemtransforms, list1);
        }

        protected List<ItemOverride> m_111494_(JsonDeserializationContext p_111495_, JsonObject p_111496_) {
            ArrayList list = Lists.newArrayList();
            if (p_111496_.has("overrides")) {
                for (JsonElement jsonelement : GsonHelper.m_13933_((JsonObject)p_111496_, (String)"overrides")) {
                    list.add((ItemOverride)p_111495_.deserialize(jsonelement, ItemOverride.class));
                }
            }
            return list;
        }

        private Map<String, Either<Material, String>> m_111509_(JsonObject p_111510_) {
            ResourceLocation resourcelocation = TextureAtlas.f_118259_;
            HashMap map = Maps.newHashMap();
            if (p_111510_.has("textures")) {
                JsonObject jsonobject = GsonHelper.m_13930_((JsonObject)p_111510_, (String)"textures");
                for (Map.Entry entry : jsonobject.entrySet()) {
                    map.put((String)entry.getKey(), Deserializer.m_111503_(resourcelocation, ((JsonElement)entry.getValue()).getAsString()));
                }
            }
            return map;
        }

        private static Either<Material, String> m_111503_(ResourceLocation p_111504_, String p_111505_) {
            if (BlockModel.m_111488_(p_111505_)) {
                return Either.right((Object)p_111505_.substring(1));
            }
            ResourceLocation resourcelocation = ResourceLocation.m_135820_(p_111505_);
            if (resourcelocation == null) {
                throw new JsonParseException(p_111505_ + " is not valid resource location");
            }
            return Either.left((Object)new Material(p_111504_, resourcelocation));
        }

        private String m_111511_(JsonObject p_111512_) {
            return GsonHelper.m_13851_((JsonObject)p_111512_, (String)"parent", (String)"");
        }

        @Nullable
        protected Boolean m_271865_(JsonObject p_273052_) {
            return p_273052_.has("ambientocclusion") ? Boolean.valueOf(GsonHelper.m_13912_((JsonObject)p_273052_, (String)"ambientocclusion")) : null;
        }

        protected List<BlockElement> m_111506_(JsonDeserializationContext p_111507_, JsonObject p_111508_) {
            ArrayList list = Lists.newArrayList();
            if (p_111508_.has("elements")) {
                for (JsonElement jsonelement : GsonHelper.m_13933_((JsonObject)p_111508_, (String)"elements")) {
                    list.add((BlockElement)p_111507_.deserialize(jsonelement, BlockElement.class));
                }
            }
            return list;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class LoopException
    extends RuntimeException {
        public LoopException(String p_173424_) {
            super(p_173424_);
        }
    }
}

