/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.google.common.primitives.Ints;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.exceptions.AuthenticationUnavailableException;
import com.mojang.logging.LogUtils;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.Connection;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.TickablePacketListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundDisconnectPacket;
import net.minecraft.network.protocol.login.ClientboundGameProfilePacket;
import net.minecraft.network.protocol.login.ClientboundHelloPacket;
import net.minecraft.network.protocol.login.ClientboundLoginCompressionPacket;
import net.minecraft.network.protocol.login.ClientboundLoginDisconnectPacket;
import net.minecraft.network.protocol.login.ServerLoginPacketListener;
import net.minecraft.network.protocol.login.ServerboundCustomQueryPacket;
import net.minecraft.network.protocol.login.ServerboundHelloPacket;
import net.minecraft.network.protocol.login.ServerboundKeyPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Crypt;
import net.minecraft.util.CryptException;
import net.minecraft.util.RandomSource;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;
import net.minecraftforge.network.ICustomPacket;
import net.minecraftforge.network.NetworkHooks;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;

public class ServerLoginPacketListenerImpl
implements ServerLoginPacketListener,
TickablePacketListener {
    private static final AtomicInteger f_10014_ = new AtomicInteger(0);
    static final Logger f_10015_ = LogUtils.getLogger();
    private static final int f_143698_ = 600;
    private static final RandomSource f_10016_ = RandomSource.m_216327_();
    private final byte[] f_252396_;
    final MinecraftServer f_10018_;
    final Connection f_10013_;
    State f_10019_ = State.HELLO;
    private int f_10020_;
    @Nullable
    public GameProfile f_10021_;
    private final String f_10022_ = "";
    @Nullable
    private ServerPlayer f_10024_;

    public ServerLoginPacketListenerImpl(MinecraftServer p_10027_, Connection p_10028_) {
        this.f_10018_ = p_10027_;
        this.f_10013_ = p_10028_;
        this.f_252396_ = Ints.toByteArray((int)f_10016_.m_188502_());
    }

    public void m_9933_() {
        ServerPlayer serverplayer;
        if (this.f_10019_ == State.NEGOTIATING) {
            boolean negotiationComplete = NetworkHooks.tickNegotiation((ServerLoginPacketListenerImpl)this, (Connection)this.f_10013_, (ServerPlayer)this.f_10024_);
            if (negotiationComplete) {
                this.f_10019_ = State.READY_TO_ACCEPT;
            }
        } else if (this.f_10019_ == State.READY_TO_ACCEPT) {
            this.m_10055_();
        } else if (this.f_10019_ == State.DELAY_ACCEPT && (serverplayer = this.f_10018_.m_6846_().m_11259_(this.f_10021_.getId())) == null) {
            this.f_10019_ = State.READY_TO_ACCEPT;
            this.m_143699_(this.f_10024_);
            this.f_10024_ = null;
        }
        if (this.f_10020_++ == 600) {
            this.m_10053_((Component)Component.m_237115_((String)"multiplayer.disconnect.slow_login"));
        }
    }

    public boolean m_6198_() {
        return this.f_10013_.m_129536_();
    }

    public void m_10053_(Component p_10054_) {
        try {
            f_10015_.info("Disconnecting {}: {}", (Object)this.m_10056_(), (Object)p_10054_.getString());
            this.f_10013_.m_129512_((Packet<?>)new ClientboundLoginDisconnectPacket(p_10054_));
            this.f_10013_.m_129507_(p_10054_);
        }
        catch (Exception exception) {
            f_10015_.error("Error whilst disconnecting player", (Throwable)exception);
        }
    }

    public void m_10055_() {
        Component component;
        if (!this.f_10021_.isComplete()) {
            this.f_10021_ = this.m_10038_(this.f_10021_);
        }
        if ((component = this.f_10018_.m_6846_().m_6418_(this.f_10013_.m_129523_(), this.f_10021_)) != null) {
            this.m_10053_(component);
        } else {
            this.f_10019_ = State.ACCEPTED;
            if (this.f_10018_.m_6328_() >= 0 && !this.f_10013_.m_129531_()) {
                this.f_10013_.m_243124_((Packet<?>)new ClientboundLoginCompressionPacket(this.f_10018_.m_6328_()), PacketSendListener.m_243092_(() -> this.f_10013_.m_129484_(this.f_10018_.m_6328_(), true)));
            }
            this.f_10013_.m_129512_((Packet<?>)new ClientboundGameProfilePacket(this.f_10021_));
            ServerPlayer serverplayer = this.f_10018_.m_6846_().m_11259_(this.f_10021_.getId());
            try {
                ServerPlayer serverplayer1 = this.f_10018_.m_6846_().m_215624_(this.f_10021_);
                if (serverplayer != null) {
                    this.f_10019_ = State.DELAY_ACCEPT;
                    this.f_10024_ = serverplayer1;
                } else {
                    this.m_143699_(serverplayer1);
                }
            }
            catch (Exception exception) {
                f_10015_.error("Couldn't place player in world", (Throwable)exception);
                MutableComponent component1 = Component.m_237115_((String)"multiplayer.disconnect.invalid_player_data");
                this.f_10013_.m_129512_((Packet<?>)new ClientboundDisconnectPacket((Component)component1));
                this.f_10013_.m_129507_((Component)component1);
            }
        }
    }

    private void m_143699_(ServerPlayer p_143700_) {
        this.f_10018_.m_6846_().m_11261_(this.f_10013_, p_143700_);
    }

    public void m_7026_(Component p_10043_) {
        f_10015_.info("{} lost connection: {}", (Object)this.m_10056_(), (Object)p_10043_.getString());
    }

    public String m_10056_() {
        return this.f_10021_ != null ? this.f_10021_ + " (" + this.f_10013_.m_129523_() + ")" : String.valueOf(this.f_10013_.m_129523_());
    }

    public void m_5990_(ServerboundHelloPacket p_10047_) {
        Validate.validState((this.f_10019_ == State.HELLO ? 1 : 0) != 0, (String)"Unexpected hello packet", (Object[])new Object[0]);
        Validate.validState((boolean)ServerLoginPacketListenerImpl.m_203792_(p_10047_.f_238040_()), (String)"Invalid characters in username", (Object[])new Object[0]);
        GameProfile gameprofile = this.f_10018_.m_236731_();
        if (gameprofile != null && p_10047_.f_238040_().equalsIgnoreCase(gameprofile.getName())) {
            this.f_10021_ = gameprofile;
            this.f_10019_ = State.NEGOTIATING;
        } else {
            this.f_10021_ = new GameProfile((UUID)null, p_10047_.f_238040_());
            if (this.f_10018_.m_129797_() && !this.f_10013_.m_129531_()) {
                this.f_10019_ = State.KEY;
                this.f_10013_.m_129512_((Packet<?>)new ClientboundHelloPacket("", this.f_10018_.m_129790_().getPublic().getEncoded(), this.f_252396_));
            } else {
                this.f_10019_ = State.NEGOTIATING;
            }
        }
    }

    public static boolean m_203792_(String p_203793_) {
        return p_203793_.chars().filter(p_203791_ -> p_203791_ <= 32 || p_203791_ >= 127).findAny().isEmpty();
    }

    public void m_8072_(ServerboundKeyPacket p_10049_) {
        String s;
        Validate.validState((this.f_10019_ == State.KEY ? 1 : 0) != 0, (String)"Unexpected key packet", (Object[])new Object[0]);
        try {
            PrivateKey privatekey = this.f_10018_.m_129790_().getPrivate();
            if (!p_10049_.m_253194_(this.f_252396_, privatekey)) {
                throw new IllegalStateException("Protocol error");
            }
            SecretKey secretkey = p_10049_.m_134859_(privatekey);
            Cipher cipher = Crypt.m_13583_((int)2, (Key)secretkey);
            Cipher cipher1 = Crypt.m_13583_((int)1, (Key)secretkey);
            s = new BigInteger(Crypt.m_13590_((String)"", (PublicKey)this.f_10018_.m_129790_().getPublic(), (SecretKey)secretkey)).toString(16);
            this.f_10019_ = State.AUTHENTICATING;
            this.f_10013_.m_129495_(cipher, cipher1);
        }
        catch (CryptException cryptexception) {
            throw new IllegalStateException("Protocol error", cryptexception);
        }
        Thread thread = new Thread((ThreadGroup)SidedThreadGroups.SERVER, "User Authenticator #" + f_10014_.incrementAndGet()){

            @Override
            public void run() {
                GameProfile gameprofile = ServerLoginPacketListenerImpl.this.f_10021_;
                try {
                    ServerLoginPacketListenerImpl.this.f_10021_ = ServerLoginPacketListenerImpl.this.f_10018_.m_129925_().hasJoinedServer(new GameProfile((UUID)null, gameprofile.getName()), s, this.m_10064_());
                    if (ServerLoginPacketListenerImpl.this.f_10021_ != null) {
                        f_10015_.info("UUID of player {} is {}", (Object)ServerLoginPacketListenerImpl.this.f_10021_.getName(), (Object)ServerLoginPacketListenerImpl.this.f_10021_.getId());
                        ServerLoginPacketListenerImpl.this.f_10019_ = State.NEGOTIATING;
                    } else if (ServerLoginPacketListenerImpl.this.f_10018_.m_129792_()) {
                        f_10015_.warn("Failed to verify username but will let them in anyway!");
                        ServerLoginPacketListenerImpl.this.f_10021_ = gameprofile;
                        ServerLoginPacketListenerImpl.this.f_10019_ = State.NEGOTIATING;
                    } else {
                        ServerLoginPacketListenerImpl.this.m_10053_((Component)Component.m_237115_((String)"multiplayer.disconnect.unverified_username"));
                        f_10015_.error("Username '{}' tried to join with an invalid session", (Object)gameprofile.getName());
                    }
                }
                catch (AuthenticationUnavailableException authenticationunavailableexception) {
                    if (ServerLoginPacketListenerImpl.this.f_10018_.m_129792_()) {
                        f_10015_.warn("Authentication servers are down but will let them in anyway!");
                        ServerLoginPacketListenerImpl.this.f_10021_ = gameprofile;
                        ServerLoginPacketListenerImpl.this.f_10019_ = State.NEGOTIATING;
                    }
                    ServerLoginPacketListenerImpl.this.m_10053_((Component)Component.m_237115_((String)"multiplayer.disconnect.authservers_down"));
                    f_10015_.error("Couldn't verify username because servers are unavailable");
                }
            }

            @Nullable
            private InetAddress m_10064_() {
                SocketAddress socketaddress = ServerLoginPacketListenerImpl.this.f_10013_.m_129523_();
                return ServerLoginPacketListenerImpl.this.f_10018_.m_129798_() && socketaddress instanceof InetSocketAddress ? ((InetSocketAddress)socketaddress).getAddress() : null;
            }
        };
        thread.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(f_10015_));
        thread.start();
    }

    public void m_7223_(ServerboundCustomQueryPacket p_10045_) {
        if (!NetworkHooks.onCustomPayload((ICustomPacket)p_10045_, (Connection)this.f_10013_)) {
            this.m_10053_((Component)Component.m_237115_((String)"multiplayer.disconnect.unexpected_query_response"));
        }
    }

    protected GameProfile m_10038_(GameProfile p_10039_) {
        UUID uuid = UUIDUtil.m_235879_((String)p_10039_.getName());
        return new GameProfile(uuid, p_10039_.getName());
    }

    static final class State
    extends Enum<State> {
        public static final /* enum */ State HELLO = new State();
        public static final /* enum */ State KEY = new State();
        public static final /* enum */ State AUTHENTICATING = new State();
        public static final /* enum */ State NEGOTIATING = new State();
        public static final /* enum */ State READY_TO_ACCEPT = new State();
        public static final /* enum */ State DELAY_ACCEPT = new State();
        public static final /* enum */ State ACCEPTED = new State();
        private static final /* synthetic */ State[] $VALUES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String p_10079_) {
            return Enum.valueOf(State.class, p_10079_);
        }

        private static /* synthetic */ State[] m_143701_() {
            return new State[]{HELLO, KEY, AUTHENTICATING, NEGOTIATING, READY_TO_ACCEPT, DELAY_ACCEPT, ACCEPTED};
        }

        static {
            $VALUES = State.m_143701_();
        }
    }
}

