/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.lighting;

import it.unimi.dsi.fastutil.longs.LongArrayFIFOQueue;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.chunk.LightChunk;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.lighting.DataLayerStorageMap;
import net.minecraft.world.level.lighting.LayerLightEventListener;
import net.minecraft.world.level.lighting.LayerLightSectionStorage;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class LightEngine<M extends DataLayerStorageMap<M>, S extends LayerLightSectionStorage<M>>
implements LayerLightEventListener {
    public static final int f_283746_ = 15;
    protected static final int f_283739_ = 1;
    protected static final long f_283854_ = QueueEntry.m_284290_(1);
    private static final int f_283747_ = 512;
    protected static final Direction[] f_283814_ = Direction.values();
    protected final LightChunkGetter f_283884_;
    protected final S f_283849_;
    private final LongOpenHashSet f_283863_ = new LongOpenHashSet(512, 0.5f);
    private final LongArrayFIFOQueue f_283823_ = new LongArrayFIFOQueue();
    private final LongArrayFIFOQueue f_283934_ = new LongArrayFIFOQueue();
    private final BlockPos.MutableBlockPos f_283920_ = new BlockPos.MutableBlockPos();
    private static final int f_283860_ = 2;
    private final long[] f_283833_ = new long[2];
    private final LightChunk[] f_283888_ = new LightChunk[2];

    protected LightEngine(LightChunkGetter p_285189_, S p_284964_) {
        this.f_283884_ = p_285189_;
        this.f_283849_ = p_284964_;
        this.m_284550_();
    }

    public static boolean m_284387_(BlockGetter p_285159_, BlockPos p_284985_, BlockState p_285110_, BlockState p_285372_) {
        if (p_285372_ == p_285110_) {
            return false;
        }
        return p_285372_.m_60739_(p_285159_, p_284985_) != p_285110_.m_60739_(p_285159_, p_284985_) || p_285372_.getLightEmission(p_285159_, p_284985_) != p_285110_.m_60739_(p_285159_, p_284985_) || p_285372_.m_60787_() || p_285110_.m_60787_();
    }

    public static int m_284282_(BlockGetter p_285330_, BlockState p_285453_, BlockPos p_285187_, BlockState p_285318_, BlockPos p_285240_, Direction p_285196_, int p_285248_) {
        boolean flag = LightEngine.m_284265_(p_285453_);
        boolean flag1 = LightEngine.m_284265_(p_285318_);
        if (flag && flag1) {
            return p_285248_;
        }
        VoxelShape voxelshape = flag ? Shapes.m_83040_() : p_285453_.m_60768_(p_285330_, p_285187_);
        VoxelShape voxelshape1 = flag1 ? Shapes.m_83040_() : p_285318_.m_60768_(p_285330_, p_285240_);
        return Shapes.m_83152_((VoxelShape)voxelshape, (VoxelShape)voxelshape1, (Direction)p_285196_) ? 16 : p_285248_;
    }

    public static VoxelShape m_284189_(BlockGetter p_285472_, BlockPos p_285229_, BlockState p_285020_, Direction p_285455_) {
        return LightEngine.m_284265_(p_285020_) ? Shapes.m_83040_() : p_285020_.m_60655_(p_285472_, p_285229_, p_285455_);
    }

    protected static boolean m_284265_(BlockState p_285133_) {
        return !p_285133_.m_60815_() || !p_285133_.m_60787_();
    }

    protected BlockState m_284512_(BlockPos p_285338_) {
        int j;
        int i = SectionPos.m_123171_((int)p_285338_.m_123341_());
        LightChunk lightchunk = this.m_284303_(i, j = SectionPos.m_123171_((int)p_285338_.m_123343_()));
        return lightchunk == null ? Blocks.f_50752_.m_49966_() : lightchunk.m_8055_(p_285338_);
    }

    protected int m_284404_(BlockState p_285084_, BlockPos p_285057_) {
        return Math.max(1, p_285084_.m_60739_(this.f_283884_.m_7653_(), p_285057_));
    }

    protected boolean m_284187_(long p_285115_, BlockState p_285154_, long p_284957_, BlockState p_285155_, Direction p_285327_) {
        VoxelShape voxelshape = this.m_284428_(p_285154_, p_285115_, p_285327_);
        VoxelShape voxelshape1 = this.m_284428_(p_285155_, p_284957_, p_285327_.m_122424_());
        return Shapes.m_83145_((VoxelShape)voxelshape, (VoxelShape)voxelshape1);
    }

    protected VoxelShape m_284428_(BlockState p_285136_, long p_285517_, Direction p_285376_) {
        return LightEngine.m_284189_(this.f_283884_.m_7653_(), (BlockPos)this.f_283920_.m_122188_(p_285517_), p_285136_, p_285376_);
    }

    @Nullable
    protected LightChunk m_284303_(int p_284967_, int p_285447_) {
        long i = ChunkPos.m_45589_((int)p_284967_, (int)p_285447_);
        for (int j = 0; j < 2; ++j) {
            if (i != this.f_283833_[j]) continue;
            return this.f_283888_[j];
        }
        LightChunk lightchunk = this.f_283884_.m_6196_(p_284967_, p_285447_);
        for (int k = 1; k > 0; --k) {
            this.f_283833_[k] = this.f_283833_[k - 1];
            this.f_283888_[k] = this.f_283888_[k - 1];
        }
        this.f_283833_[0] = i;
        this.f_283888_[0] = lightchunk;
        return lightchunk;
    }

    private void m_284550_() {
        Arrays.fill(this.f_283833_, ChunkPos.f_45577_);
        Arrays.fill(this.f_283888_, null);
    }

    public void m_7174_(BlockPos p_285352_) {
        this.f_283863_.add(p_285352_.m_121878_());
    }

    public void m_284203_(long p_285221_, @Nullable DataLayer p_285427_) {
        this.f_283849_.m_284542_(p_285221_, p_285427_);
    }

    public void m_284245_(ChunkPos p_285314_, boolean p_284937_) {
        this.f_283849_.m_75782_(SectionPos.m_284454_((int)p_285314_.f_45578_, (int)p_285314_.f_45579_), p_284937_);
    }

    public void m_6191_(SectionPos p_285167_, boolean p_284934_) {
        this.f_283849_.m_75787_(p_285167_.m_123252_(), p_284934_);
    }

    public void m_9335_(ChunkPos p_285116_, boolean p_285522_) {
        this.f_283849_.m_284259_(SectionPos.m_284454_((int)p_285116_.f_45578_, (int)p_285116_.f_45579_), p_285522_);
    }

    public int m_9323_() {
        LongIterator longiterator = this.f_283863_.iterator();
        while (longiterator.hasNext()) {
            this.m_75858_(longiterator.nextLong());
        }
        this.f_283863_.clear();
        this.f_283863_.trim(512);
        int i = 0;
        i += this.m_284399_();
        this.m_284550_();
        this.f_283849_.m_284283_(this);
        this.f_283849_.m_75790_();
        return i += this.m_284361_();
    }

    private int m_284361_() {
        int i = 0;
        while (!this.f_283934_.isEmpty()) {
            long j = this.f_283934_.dequeueLong();
            long k = this.f_283934_.dequeueLong();
            int l = this.f_283849_.m_75795_(j);
            int i1 = QueueEntry.m_284170_(k);
            if (QueueEntry.m_284312_(k) && l < i1) {
                this.f_283849_.m_75772_(j, i1);
                l = i1;
            }
            if (l == i1) {
                this.m_284316_(j, k, l);
            }
            ++i;
        }
        return i;
    }

    private int m_284399_() {
        int i = 0;
        while (!this.f_283823_.isEmpty()) {
            long j = this.f_283823_.dequeueLong();
            long k = this.f_283823_.dequeueLong();
            this.m_284321_(j, k);
            ++i;
        }
        return i;
    }

    protected void m_284343_(long p_285228_, long p_285464_) {
        this.f_283823_.enqueue(p_285228_);
        this.f_283823_.enqueue(p_285464_);
    }

    protected void m_284218_(long p_285223_, long p_285022_) {
        this.f_283934_.enqueue(p_285223_);
        this.f_283934_.enqueue(p_285022_);
    }

    public boolean m_75808_() {
        return this.f_283849_.m_6808_() || !this.f_283863_.isEmpty() || !this.f_283823_.isEmpty() || !this.f_283934_.isEmpty();
    }

    @Nullable
    public DataLayer m_8079_(SectionPos p_285093_) {
        return this.f_283849_.m_75793_(p_285093_.m_123252_());
    }

    public int m_7768_(BlockPos p_285149_) {
        return this.f_283849_.m_6181_(p_285149_.m_121878_());
    }

    public String m_284216_(long p_285363_) {
        return this.m_284437_(p_285363_).m_284377_();
    }

    public LayerLightSectionStorage.SectionType m_284437_(long p_285320_) {
        return this.f_283849_.m_284291_(p_285320_);
    }

    protected abstract void m_75858_(long var1);

    protected abstract void m_284316_(long var1, long var3, int var5);

    protected abstract void m_284321_(long var1, long var3);

    public static class QueueEntry {
        private static final int f_283813_ = 4;
        private static final int f_283763_ = 6;
        private static final long f_283912_ = 15L;
        private static final long f_283794_ = 1008L;
        private static final long f_283865_ = 1024L;
        private static final long f_283793_ = 2048L;

        public static long m_284546_(int p_285429_, Direction p_285207_) {
            long i = QueueEntry.m_284441_(1008L, p_285207_);
            return QueueEntry.m_284455_(i, p_285429_);
        }

        public static long m_284290_(int p_285144_) {
            return QueueEntry.m_284455_(1008L, p_285144_);
        }

        public static long m_284185_(int p_285199_, boolean p_284986_) {
            long i = 1008L;
            i |= 0x800L;
            if (p_284986_) {
                i |= 0x400L;
            }
            return QueueEntry.m_284455_(i, p_285199_);
        }

        public static long m_284188_(int p_285091_, boolean p_285186_, Direction p_285382_) {
            long i = QueueEntry.m_284441_(1008L, p_285382_);
            if (p_285186_) {
                i |= 0x400L;
            }
            return QueueEntry.m_284455_(i, p_285091_);
        }

        public static long m_284128_(int p_285025_, boolean p_285384_, Direction p_285072_) {
            long i = 0L;
            if (p_285384_) {
                i |= 0x400L;
            }
            i = QueueEntry.m_284335_(i, p_285072_);
            return QueueEntry.m_284455_(i, p_285025_);
        }

        public static long m_284543_(boolean p_285487_, boolean p_285390_, boolean p_285476_, boolean p_285505_, boolean p_285127_) {
            long i = QueueEntry.m_284455_(0L, 15);
            if (p_285487_) {
                i = QueueEntry.m_284335_(i, Direction.DOWN);
            }
            if (p_285390_) {
                i = QueueEntry.m_284335_(i, Direction.NORTH);
            }
            if (p_285476_) {
                i = QueueEntry.m_284335_(i, Direction.SOUTH);
            }
            if (p_285505_) {
                i = QueueEntry.m_284335_(i, Direction.WEST);
            }
            if (p_285127_) {
                i = QueueEntry.m_284335_(i, Direction.EAST);
            }
            return i;
        }

        public static int m_284170_(long p_285483_) {
            return (int)(p_285483_ & 0xFL);
        }

        public static boolean m_284390_(long p_285436_) {
            return (p_285436_ & 0x400L) != 0L;
        }

        public static boolean m_284312_(long p_285348_) {
            return (p_285348_ & 0x800L) != 0L;
        }

        public static boolean m_284416_(long p_285347_, Direction p_285291_) {
            return (p_285347_ & 1L << p_285291_.ordinal() + 4) != 0L;
        }

        private static long m_284455_(long p_285234_, int p_285042_) {
            return p_285234_ & 0xFFFFFFFFFFFFFFF0L | (long)p_285042_ & 0xFL;
        }

        private static long m_284335_(long p_285295_, Direction p_285016_) {
            return p_285295_ | 1L << p_285016_.ordinal() + 4;
        }

        private static long m_284441_(long p_285366_, Direction p_285489_) {
            return p_285366_ & (1L << p_285489_.ordinal() + 4 ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }
}

