/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client;

import com.google.common.base.Charsets;
import com.google.common.base.MoreObjects;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.AttackIndicatorStatus;
import net.minecraft.client.CameraType;
import net.minecraft.client.CloudStatus;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.InactivityFpsLimit;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.NarratorStatus;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.PrioritizeChunkUpdates;
import net.minecraft.client.ToggleKeyMapping;
import net.minecraft.client.gui.components.ChatComponent;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.renderer.GpuWarnlistManager;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundEngine;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.client.tutorial.TutorialSteps;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.ParticleStatus;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.ARGB;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.ChatVisiblity;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.loading.ClientModLoader;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class Options {
    static final Logger LOGGER = LogUtils.getLogger();
    static final Gson GSON = new Gson();
    private static final TypeToken<List<String>> LIST_OF_STRINGS_TYPE = new TypeToken<List<String>>(){};
    public static final int RENDER_DISTANCE_TINY = 2;
    public static final int RENDER_DISTANCE_SHORT = 4;
    public static final int RENDER_DISTANCE_NORMAL = 8;
    public static final int RENDER_DISTANCE_FAR = 12;
    public static final int RENDER_DISTANCE_REALLY_FAR = 16;
    public static final int RENDER_DISTANCE_EXTREME = 32;
    private static final Splitter OPTION_SPLITTER = Splitter.on((char)':').limit(2);
    public static final String DEFAULT_SOUND_DEVICE = "";
    private static final Component ACCESSIBILITY_TOOLTIP_DARK_MOJANG_BACKGROUND = Component.translatable("options.darkMojangStudiosBackgroundColor.tooltip");
    private final OptionInstance<Boolean> darkMojangStudiosBackground = OptionInstance.createBoolean((String)"options.darkMojangStudiosBackgroundColor", (OptionInstance.TooltipSupplier)OptionInstance.cachedConstantTooltip((Component)ACCESSIBILITY_TOOLTIP_DARK_MOJANG_BACKGROUND), (boolean)false);
    private static final Component ACCESSIBILITY_TOOLTIP_HIDE_LIGHTNING_FLASHES = Component.translatable("options.hideLightningFlashes.tooltip");
    private final OptionInstance<Boolean> hideLightningFlash = OptionInstance.createBoolean((String)"options.hideLightningFlashes", (OptionInstance.TooltipSupplier)OptionInstance.cachedConstantTooltip((Component)ACCESSIBILITY_TOOLTIP_HIDE_LIGHTNING_FLASHES), (boolean)false);
    private static final Component ACCESSIBILITY_TOOLTIP_HIDE_SPLASH_TEXTS = Component.translatable("options.hideSplashTexts.tooltip");
    private final OptionInstance<Boolean> hideSplashTexts = OptionInstance.createBoolean((String)"options.hideSplashTexts", (OptionInstance.TooltipSupplier)OptionInstance.cachedConstantTooltip((Component)ACCESSIBILITY_TOOLTIP_HIDE_SPLASH_TEXTS), (boolean)false);
    private final OptionInstance<Double> sensitivity = new OptionInstance("options.sensitivity", OptionInstance.noTooltip(), (p_232096_, p_232097_) -> {
        if (p_232097_ == 0.0) {
            return Options.genericValueLabel(p_232096_, Component.translatable("options.sensitivity.min"));
        }
        return p_232097_ == 1.0 ? Options.genericValueLabel(p_232096_, Component.translatable("options.sensitivity.max")) : Options.percentValueLabel(p_232096_, 2.0 * p_232097_);
    }, (OptionInstance.ValueSet)OptionInstance.UnitDouble.INSTANCE, (Object)0.5, p_232115_ -> {});
    private final OptionInstance<Integer> renderDistance;
    private final OptionInstance<Integer> simulationDistance;
    private int serverRenderDistance = 0;
    private final OptionInstance<Double> entityDistanceScaling = new OptionInstance("options.entityDistanceScaling", OptionInstance.noTooltip(), Options::percentValueLabel, (OptionInstance.ValueSet)new OptionInstance.IntRange(2, 20).xmap(p_232020_ -> (double)p_232020_ / 4.0, p_232112_ -> (int)(p_232112_ * 4.0)), Codec.doubleRange((double)0.5, (double)5.0), (Object)1.0, p_368317_ -> {});
    public static final int UNLIMITED_FRAMERATE_CUTOFF = 260;
    private final OptionInstance<Integer> framerateLimit = new OptionInstance("options.framerateLimit", OptionInstance.noTooltip(), (p_232048_, p_232049_) -> p_232049_ == 260 ? Options.genericValueLabel(p_232048_, Component.translatable("options.framerateLimit.max")) : Options.genericValueLabel(p_232048_, Component.translatable("options.framerate", p_232049_)), (OptionInstance.ValueSet)new OptionInstance.IntRange(1, 26).xmap(p_232003_ -> p_232003_ * 10, p_232094_ -> p_232094_ / 10), Codec.intRange((int)10, (int)260), (Object)120, p_357644_ -> Minecraft.getInstance().getFramerateLimitTracker().setFramerateLimit(p_357644_.intValue()));
    private static final Component INACTIVITY_FPS_LIMIT_TOOLTIP_MINIMIZED = Component.translatable("options.inactivityFpsLimit.minimized.tooltip");
    private static final Component INACTIVITY_FPS_LIMIT_TOOLTIP_AFK = Component.translatable("options.inactivityFpsLimit.afk.tooltip");
    private final OptionInstance<InactivityFpsLimit> inactivityFpsLimit = new OptionInstance("options.inactivityFpsLimit", p_357645_ -> switch (p_357645_) {
        default -> throw new MatchException(null, null);
        case InactivityFpsLimit.MINIMIZED -> Tooltip.create((Component)INACTIVITY_FPS_LIMIT_TOOLTIP_MINIMIZED);
        case InactivityFpsLimit.AFK -> Tooltip.create((Component)INACTIVITY_FPS_LIMIT_TOOLTIP_AFK);
    }, OptionInstance.forOptionEnum(), (OptionInstance.ValueSet)new OptionInstance.Enum(Arrays.asList(InactivityFpsLimit.values()), InactivityFpsLimit.CODEC), (Object)InactivityFpsLimit.AFK, p_364366_ -> {});
    private final OptionInstance<CloudStatus> cloudStatus = new OptionInstance("options.renderClouds", OptionInstance.noTooltip(), OptionInstance.forOptionEnum(), (OptionInstance.ValueSet)new OptionInstance.Enum(Arrays.asList(CloudStatus.values()), Codec.withAlternative((Codec)CloudStatus.CODEC, (Codec)Codec.BOOL, p_232082_ -> p_232082_ != false ? CloudStatus.FANCY : CloudStatus.OFF)), (Object)CloudStatus.FANCY, p_362401_ -> {});
    private static final Component GRAPHICS_TOOLTIP_FAST = Component.translatable("options.graphics.fast.tooltip");
    private static final Component GRAPHICS_TOOLTIP_FABULOUS = Component.translatable("options.graphics.fabulous.tooltip", Component.translatable("options.graphics.fabulous").withStyle(ChatFormatting.ITALIC));
    private static final Component GRAPHICS_TOOLTIP_FANCY = Component.translatable("options.graphics.fancy.tooltip");
    private final OptionInstance<GraphicsStatus> graphicsMode = new OptionInstance("options.graphics", p_325283_ -> switch (p_325283_) {
        default -> throw new MatchException(null, null);
        case GraphicsStatus.FANCY -> Tooltip.create((Component)GRAPHICS_TOOLTIP_FANCY);
        case GraphicsStatus.FAST -> Tooltip.create((Component)GRAPHICS_TOOLTIP_FAST);
        case GraphicsStatus.FABULOUS -> Tooltip.create((Component)GRAPHICS_TOOLTIP_FABULOUS);
    }, (p_231904_, p_231905_) -> {
        MutableComponent mutablecomponent = Component.translatable(p_231905_.getKey());
        return p_231905_ == GraphicsStatus.FABULOUS ? mutablecomponent.withStyle(ChatFormatting.ITALIC) : mutablecomponent;
    }, (OptionInstance.ValueSet)new OptionInstance.AltEnum(Arrays.asList(GraphicsStatus.values()), Stream.of(GraphicsStatus.values()).filter(p_231943_ -> p_231943_ != GraphicsStatus.FABULOUS).collect(Collectors.toList()), () -> Minecraft.getInstance().isRunning() && Minecraft.getInstance().getGpuWarnlistManager().isSkippingFabulous(), (p_231862_, p_231863_) -> {
        Minecraft minecraft = Minecraft.getInstance();
        GpuWarnlistManager gpuwarnlistmanager = minecraft.getGpuWarnlistManager();
        if (p_231863_ == GraphicsStatus.FABULOUS && gpuwarnlistmanager.willShowWarning()) {
            gpuwarnlistmanager.showWarning();
        } else {
            p_231862_.set(p_231863_);
            minecraft.levelRenderer.allChanged();
        }
    }, Codec.INT.xmap(GraphicsStatus::byId, GraphicsStatus::getId)), (Object)GraphicsStatus.FANCY, p_360811_ -> {});
    private final OptionInstance<Boolean> ambientOcclusion = OptionInstance.createBoolean((String)"options.ao", (boolean)true, p_263512_ -> Minecraft.getInstance().levelRenderer.allChanged());
    private static final Component PRIORITIZE_CHUNK_TOOLTIP_NONE = Component.translatable("options.prioritizeChunkUpdates.none.tooltip");
    private static final Component PRIORITIZE_CHUNK_TOOLTIP_PLAYER_AFFECTED = Component.translatable("options.prioritizeChunkUpdates.byPlayer.tooltip");
    private static final Component PRIORITIZE_CHUNK_TOOLTIP_NEARBY = Component.translatable("options.prioritizeChunkUpdates.nearby.tooltip");
    private final OptionInstance<PrioritizeChunkUpdates> prioritizeChunkUpdates = new OptionInstance("options.prioritizeChunkUpdates", p_325284_ -> switch (p_325284_) {
        default -> throw new MatchException(null, null);
        case PrioritizeChunkUpdates.NONE -> Tooltip.create((Component)PRIORITIZE_CHUNK_TOOLTIP_NONE);
        case PrioritizeChunkUpdates.PLAYER_AFFECTED -> Tooltip.create((Component)PRIORITIZE_CHUNK_TOOLTIP_PLAYER_AFFECTED);
        case PrioritizeChunkUpdates.NEARBY -> Tooltip.create((Component)PRIORITIZE_CHUNK_TOOLTIP_NEARBY);
    }, OptionInstance.forOptionEnum(), (OptionInstance.ValueSet)new OptionInstance.Enum(Arrays.asList(PrioritizeChunkUpdates.values()), Codec.INT.xmap(PrioritizeChunkUpdates::byId, PrioritizeChunkUpdates::getId)), (Object)PrioritizeChunkUpdates.NONE, p_361784_ -> {});
    public List<String> resourcePacks = Lists.newArrayList();
    public List<String> incompatibleResourcePacks = Lists.newArrayList();
    private final OptionInstance<ChatVisiblity> chatVisibility = new OptionInstance("options.chat.visibility", OptionInstance.noTooltip(), OptionInstance.forOptionEnum(), (OptionInstance.ValueSet)new OptionInstance.Enum(Arrays.asList(ChatVisiblity.values()), Codec.INT.xmap(ChatVisiblity::byId, ChatVisiblity::getId)), (Object)ChatVisiblity.FULL, p_364795_ -> {});
    private final OptionInstance<Double> chatOpacity = new OptionInstance("options.chat.opacity", OptionInstance.noTooltip(), (p_232088_, p_232089_) -> Options.percentValueLabel(p_232088_, p_232089_ * 0.9 + 0.1), (OptionInstance.ValueSet)OptionInstance.UnitDouble.INSTANCE, (Object)1.0, p_232106_ -> Minecraft.getInstance().gui.getChat().rescaleChat());
    private final OptionInstance<Double> chatLineSpacing = new OptionInstance("options.chat.line_spacing", OptionInstance.noTooltip(), Options::percentValueLabel, (OptionInstance.ValueSet)OptionInstance.UnitDouble.INSTANCE, (Object)0.0, p_232109_ -> {});
    private static final Component MENU_BACKGROUND_BLURRINESS_TOOLTIP = Component.translatable("options.accessibility.menu_background_blurriness.tooltip");
    private static final int BLURRINESS_DEFAULT_VALUE = 5;
    private final OptionInstance<Integer> menuBackgroundBlurriness = new OptionInstance("options.accessibility.menu_background_blurriness", OptionInstance.cachedConstantTooltip((Component)MENU_BACKGROUND_BLURRINESS_TOOLTIP), Options::genericValueOrOffLabel, (OptionInstance.ValueSet)new OptionInstance.IntRange(0, 10), (Object)5, p_364779_ -> {});
    private final OptionInstance<Double> textBackgroundOpacity = new OptionInstance("options.accessibility.text_background_opacity", OptionInstance.noTooltip(), Options::percentValueLabel, (OptionInstance.ValueSet)OptionInstance.UnitDouble.INSTANCE, (Object)0.5, p_232100_ -> Minecraft.getInstance().gui.getChat().rescaleChat());
    private final OptionInstance<Double> panoramaSpeed = new OptionInstance("options.accessibility.panorama_speed", OptionInstance.noTooltip(), Options::percentValueLabel, (OptionInstance.ValueSet)OptionInstance.UnitDouble.INSTANCE, (Object)1.0, p_328488_ -> {});
    private static final Component ACCESSIBILITY_TOOLTIP_CONTRAST_MODE = Component.translatable("options.accessibility.high_contrast.tooltip");
    private final OptionInstance<Boolean> highContrast = OptionInstance.createBoolean((String)"options.accessibility.high_contrast", (OptionInstance.TooltipSupplier)OptionInstance.cachedConstantTooltip((Component)ACCESSIBILITY_TOOLTIP_CONTRAST_MODE), (boolean)false, p_275860_ -> {
        PackRepository packrepository = Minecraft.getInstance().getResourcePackRepository();
        boolean flag1 = packrepository.getSelectedIds().contains("high_contrast");
        if (!flag1 && p_275860_.booleanValue()) {
            if (packrepository.addPack("high_contrast")) {
                this.updateResourcePacks(packrepository);
            }
        } else if (flag1 && !p_275860_.booleanValue() && packrepository.removePack("high_contrast")) {
            this.updateResourcePacks(packrepository);
        }
    });
    private static final Component HIGH_CONTRAST_BLOCK_OUTLINE_TOOLTIP = Component.translatable("options.accessibility.high_contrast_block_outline.tooltip");
    private final OptionInstance<Boolean> highContrastBlockOutline = OptionInstance.createBoolean((String)"options.accessibility.high_contrast_block_outline", (OptionInstance.TooltipSupplier)OptionInstance.cachedConstantTooltip((Component)HIGH_CONTRAST_BLOCK_OUTLINE_TOOLTIP), (boolean)false);
    private final OptionInstance<Boolean> narratorHotkey = OptionInstance.createBoolean((String)"options.accessibility.narrator_hotkey", (OptionInstance.TooltipSupplier)OptionInstance.cachedConstantTooltip((Component)(Minecraft.ON_OSX ? Component.translatable("options.accessibility.narrator_hotkey.mac.tooltip") : Component.translatable("options.accessibility.narrator_hotkey.tooltip"))), (boolean)true);
    @Nullable
    public String fullscreenVideoModeString;
    public boolean hideServerAddress;
    public boolean advancedItemTooltips;
    public boolean pauseOnLostFocus = true;
    private final Set<PlayerModelPart> modelParts = EnumSet.allOf(PlayerModelPart.class);
    private final OptionInstance<HumanoidArm> mainHand = new OptionInstance("options.mainHand", OptionInstance.noTooltip(), OptionInstance.forOptionEnum(), (OptionInstance.ValueSet)new OptionInstance.Enum(Arrays.asList(HumanoidArm.values()), HumanoidArm.CODEC), (Object)HumanoidArm.RIGHT, p_365752_ -> {});
    public int overrideWidth;
    public int overrideHeight;
    private final OptionInstance<Double> chatScale = new OptionInstance("options.chat.scale", OptionInstance.noTooltip(), (p_232078_, p_232079_) -> p_232079_ == 0.0 ? CommonComponents.optionStatus(p_232078_, false) : Options.percentValueLabel(p_232078_, p_232079_), (OptionInstance.ValueSet)OptionInstance.UnitDouble.INSTANCE, (Object)1.0, p_232092_ -> Minecraft.getInstance().gui.getChat().rescaleChat());
    private final OptionInstance<Double> chatWidth = new OptionInstance("options.chat.width", OptionInstance.noTooltip(), (p_232068_, p_232069_) -> Options.pixelValueLabel(p_232068_, ChatComponent.getWidth((double)p_232069_)), (OptionInstance.ValueSet)OptionInstance.UnitDouble.INSTANCE, (Object)1.0, p_232084_ -> Minecraft.getInstance().gui.getChat().rescaleChat());
    private final OptionInstance<Double> chatHeightUnfocused = new OptionInstance("options.chat.height.unfocused", OptionInstance.noTooltip(), (p_232058_, p_232059_) -> Options.pixelValueLabel(p_232058_, ChatComponent.getHeight((double)p_232059_)), (OptionInstance.ValueSet)OptionInstance.UnitDouble.INSTANCE, (Object)ChatComponent.defaultUnfocusedPct(), p_232074_ -> Minecraft.getInstance().gui.getChat().rescaleChat());
    private final OptionInstance<Double> chatHeightFocused = new OptionInstance("options.chat.height.focused", OptionInstance.noTooltip(), (p_232045_, p_232046_) -> Options.pixelValueLabel(p_232045_, ChatComponent.getHeight((double)p_232046_)), (OptionInstance.ValueSet)OptionInstance.UnitDouble.INSTANCE, (Object)1.0, p_232064_ -> Minecraft.getInstance().gui.getChat().rescaleChat());
    private final OptionInstance<Double> chatDelay = new OptionInstance("options.chat.delay_instant", OptionInstance.noTooltip(), (p_232030_, p_232031_) -> p_232031_ <= 0.0 ? Component.translatable("options.chat.delay_none") : Component.translatable("options.chat.delay", String.format(Locale.ROOT, "%.1f", p_232031_)), (OptionInstance.ValueSet)new OptionInstance.IntRange(0, 60).xmap(p_231986_ -> (double)p_231986_ / 10.0, p_232054_ -> (int)(p_232054_ * 10.0)), Codec.doubleRange((double)0.0, (double)6.0), (Object)0.0, p_232039_ -> Minecraft.getInstance().getChatListener().setMessageDelay((double)p_232039_));
    private static final Component ACCESSIBILITY_TOOLTIP_NOTIFICATION_DISPLAY_TIME = Component.translatable("options.notifications.display_time.tooltip");
    private final OptionInstance<Double> notificationDisplayTime = new OptionInstance("options.notifications.display_time", OptionInstance.cachedConstantTooltip((Component)ACCESSIBILITY_TOOLTIP_NOTIFICATION_DISPLAY_TIME), (p_231962_, p_300116_) -> Options.genericValueLabel(p_231962_, Component.translatable("options.multiplier", p_300116_)), (OptionInstance.ValueSet)new OptionInstance.IntRange(5, 100).xmap(p_264666_ -> (double)p_264666_ / 10.0, p_264667_ -> (int)(p_264667_ * 10.0)), Codec.doubleRange((double)0.5, (double)10.0), (Object)1.0, p_333143_ -> {});
    private final OptionInstance<Integer> mipmapLevels = new OptionInstance("options.mipmapLevels", OptionInstance.noTooltip(), (p_232033_, p_232034_) -> p_232034_ == 0 ? CommonComponents.optionStatus(p_232033_, false) : Options.genericValueLabel(p_232033_, p_232034_), (OptionInstance.ValueSet)new OptionInstance.IntRange(0, 4), (Object)4, p_368247_ -> {});
    public boolean useNativeTransport = true;
    private final OptionInstance<AttackIndicatorStatus> attackIndicator = new OptionInstance("options.attackIndicator", OptionInstance.noTooltip(), OptionInstance.forOptionEnum(), (OptionInstance.ValueSet)new OptionInstance.Enum(Arrays.asList(AttackIndicatorStatus.values()), Codec.INT.xmap(AttackIndicatorStatus::byId, AttackIndicatorStatus::getId)), (Object)AttackIndicatorStatus.CROSSHAIR, p_366798_ -> {});
    public TutorialSteps tutorialStep = TutorialSteps.MOVEMENT;
    public boolean joinedFirstServer = false;
    private final OptionInstance<Integer> biomeBlendRadius = new OptionInstance("options.biomeBlendRadius", OptionInstance.noTooltip(), (p_232016_, p_232017_) -> {
        int i = p_232017_ * 2 + 1;
        return Options.genericValueLabel(p_232016_, Component.translatable("options.biomeBlendRadius." + i));
    }, (OptionInstance.ValueSet)new OptionInstance.IntRange(0, 7, false), (Object)2, p_232026_ -> Minecraft.getInstance().levelRenderer.allChanged());
    private final OptionInstance<Double> mouseWheelSensitivity = new OptionInstance("options.mouseWheelSensitivity", OptionInstance.noTooltip(), (p_232013_, p_232014_) -> Options.genericValueLabel(p_232013_, Component.literal(String.format(Locale.ROOT, "%.2f", p_232014_))), (OptionInstance.ValueSet)new OptionInstance.IntRange(-200, 100).xmap(Options::logMouse, Options::unlogMouse), Codec.doubleRange((double)Options.logMouse(-200), (double)Options.logMouse(100)), (Object)Options.logMouse(0), p_368237_ -> {});
    private final OptionInstance<Boolean> rawMouseInput = OptionInstance.createBoolean((String)"options.rawMouseInput", (boolean)true, p_232062_ -> {
        Window window = Minecraft.getInstance().getWindow();
        if (window != null) {
            window.updateRawMouseInput((boolean)p_232062_);
        }
    });
    public int glDebugVerbosity = 1;
    private final OptionInstance<Boolean> autoJump = OptionInstance.createBoolean((String)"options.autoJump", (boolean)false);
    private static final Component ACCESSIBILITY_TOOLTIP_ROTATE_WITH_MINECART = Component.translatable("options.rotateWithMinecart.tooltip");
    private final OptionInstance<Boolean> rotateWithMinecart = OptionInstance.createBoolean((String)"options.rotateWithMinecart", (OptionInstance.TooltipSupplier)OptionInstance.cachedConstantTooltip((Component)ACCESSIBILITY_TOOLTIP_ROTATE_WITH_MINECART), (boolean)false);
    private final OptionInstance<Boolean> operatorItemsTab = OptionInstance.createBoolean((String)"options.operatorItemsTab", (boolean)false);
    private final OptionInstance<Boolean> autoSuggestions = OptionInstance.createBoolean((String)"options.autoSuggestCommands", (boolean)true);
    private final OptionInstance<Boolean> chatColors = OptionInstance.createBoolean((String)"options.chat.color", (boolean)true);
    private final OptionInstance<Boolean> chatLinks = OptionInstance.createBoolean((String)"options.chat.links", (boolean)true);
    private final OptionInstance<Boolean> chatLinksPrompt = OptionInstance.createBoolean((String)"options.chat.links.prompt", (boolean)true);
    private final OptionInstance<Boolean> enableVsync = OptionInstance.createBoolean((String)"options.vsync", (boolean)true, p_232052_ -> {
        if (Minecraft.getInstance().getWindow() != null) {
            Minecraft.getInstance().getWindow().updateVsync((boolean)p_232052_);
        }
    });
    private final OptionInstance<Boolean> entityShadows = OptionInstance.createBoolean((String)"options.entityShadows", (boolean)true);
    private final OptionInstance<Boolean> forceUnicodeFont = OptionInstance.createBoolean((String)"options.forceUnicodeFont", (boolean)false, p_325286_ -> Options.updateFontOptions());
    private final OptionInstance<Boolean> japaneseGlyphVariants = OptionInstance.createBoolean((String)"options.japaneseGlyphVariants", (OptionInstance.TooltipSupplier)OptionInstance.cachedConstantTooltip((Component)Component.translatable("options.japaneseGlyphVariants.tooltip")), (boolean)Options.japaneseGlyphVariantsDefault(), p_325287_ -> Options.updateFontOptions());
    private final OptionInstance<Boolean> invertYMouse = OptionInstance.createBoolean((String)"options.invertMouse", (boolean)false);
    private final OptionInstance<Boolean> discreteMouseScroll = OptionInstance.createBoolean((String)"options.discrete_mouse_scroll", (boolean)false);
    private static final Component REALMS_NOTIFICATIONS_TOOLTIP = Component.translatable("options.realmsNotifications.tooltip");
    private final OptionInstance<Boolean> realmsNotifications = OptionInstance.createBoolean((String)"options.realmsNotifications", (OptionInstance.TooltipSupplier)OptionInstance.cachedConstantTooltip((Component)REALMS_NOTIFICATIONS_TOOLTIP), (boolean)true);
    private static final Component ALLOW_SERVER_LISTING_TOOLTIP = Component.translatable("options.allowServerListing.tooltip");
    private final OptionInstance<Boolean> allowServerListing = OptionInstance.createBoolean((String)"options.allowServerListing", (OptionInstance.TooltipSupplier)OptionInstance.cachedConstantTooltip((Component)ALLOW_SERVER_LISTING_TOOLTIP), (boolean)true, p_334201_ -> {});
    private final OptionInstance<Boolean> reducedDebugInfo = OptionInstance.createBoolean((String)"options.reducedDebugInfo", (boolean)false);
    private final Map<SoundSource, OptionInstance<Double>> soundSourceVolumes = Util.make(new EnumMap(SoundSource.class), p_247766_ -> {
        for (SoundSource soundsource : SoundSource.values()) {
            p_247766_.put(soundsource, this.createSoundSliderOptionInstance("soundCategory." + soundsource.getName(), soundsource));
        }
    });
    private final OptionInstance<Boolean> showSubtitles = OptionInstance.createBoolean((String)"options.showSubtitles", (boolean)false);
    private static final Component DIRECTIONAL_AUDIO_TOOLTIP_ON = Component.translatable("options.directionalAudio.on.tooltip");
    private static final Component DIRECTIONAL_AUDIO_TOOLTIP_OFF = Component.translatable("options.directionalAudio.off.tooltip");
    private final OptionInstance<Boolean> directionalAudio = OptionInstance.createBoolean((String)"options.directionalAudio", p_231858_ -> p_231858_ != false ? Tooltip.create((Component)DIRECTIONAL_AUDIO_TOOLTIP_ON) : Tooltip.create((Component)DIRECTIONAL_AUDIO_TOOLTIP_OFF), (boolean)false, p_298396_ -> {
        SoundManager soundmanager = Minecraft.getInstance().getSoundManager();
        soundmanager.reload();
        soundmanager.play((SoundInstance)SimpleSoundInstance.forUI(SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
    });
    private final OptionInstance<Boolean> backgroundForChatOnly = new OptionInstance("options.accessibility.text_background", OptionInstance.noTooltip(), (p_231976_, p_231977_) -> p_231977_ != false ? Component.translatable("options.accessibility.text_background.chat") : Component.translatable("options.accessibility.text_background.everywhere"), (OptionInstance.ValueSet)OptionInstance.BOOLEAN_VALUES, (Object)true, p_362316_ -> {});
    private final OptionInstance<Boolean> touchscreen = OptionInstance.createBoolean((String)"options.touchscreen", (boolean)false);
    private final OptionInstance<Boolean> fullscreen = OptionInstance.createBoolean((String)"options.fullscreen", (boolean)false, p_231970_ -> {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.getWindow() != null && minecraft.getWindow().isFullscreen() != p_231970_.booleanValue()) {
            minecraft.getWindow().toggleFullScreen();
            this.fullscreen().set((Object)minecraft.getWindow().isFullscreen());
        }
    });
    private final OptionInstance<Boolean> bobView = OptionInstance.createBoolean((String)"options.viewBobbing", (boolean)true);
    private static final Component MOVEMENT_TOGGLE = Component.translatable("options.key.toggle");
    private static final Component MOVEMENT_HOLD = Component.translatable("options.key.hold");
    private final OptionInstance<Boolean> toggleCrouch = new OptionInstance("key.sneak", OptionInstance.noTooltip(), (p_231956_, p_231957_) -> p_231957_ != false ? MOVEMENT_TOGGLE : MOVEMENT_HOLD, (OptionInstance.ValueSet)OptionInstance.BOOLEAN_VALUES, (Object)false, p_367178_ -> {});
    private final OptionInstance<Boolean> toggleSprint = new OptionInstance("key.sprint", OptionInstance.noTooltip(), (p_231910_, p_231911_) -> p_231911_ != false ? MOVEMENT_TOGGLE : MOVEMENT_HOLD, (OptionInstance.ValueSet)OptionInstance.BOOLEAN_VALUES, (Object)false, p_367542_ -> {});
    public boolean skipMultiplayerWarning;
    private static final Component CHAT_TOOLTIP_HIDE_MATCHED_NAMES = Component.translatable("options.hideMatchedNames.tooltip");
    private final OptionInstance<Boolean> hideMatchedNames = OptionInstance.createBoolean((String)"options.hideMatchedNames", (OptionInstance.TooltipSupplier)OptionInstance.cachedConstantTooltip((Component)CHAT_TOOLTIP_HIDE_MATCHED_NAMES), (boolean)true);
    private final OptionInstance<Boolean> showAutosaveIndicator = OptionInstance.createBoolean((String)"options.autosaveIndicator", (boolean)true);
    private static final Component CHAT_TOOLTIP_ONLY_SHOW_SECURE = Component.translatable("options.onlyShowSecureChat.tooltip");
    private final OptionInstance<Boolean> onlyShowSecureChat = OptionInstance.createBoolean((String)"options.onlyShowSecureChat", (OptionInstance.TooltipSupplier)OptionInstance.cachedConstantTooltip((Component)CHAT_TOOLTIP_ONLY_SHOW_SECURE), (boolean)false);
    public final KeyMapping keyUp = new KeyMapping("key.forward", 87, "key.categories.movement");
    public final KeyMapping keyLeft = new KeyMapping("key.left", 65, "key.categories.movement");
    public final KeyMapping keyDown = new KeyMapping("key.back", 83, "key.categories.movement");
    public final KeyMapping keyRight = new KeyMapping("key.right", 68, "key.categories.movement");
    public final KeyMapping keyJump = new KeyMapping("key.jump", 32, "key.categories.movement");
    public final KeyMapping keyShift = new ToggleKeyMapping("key.sneak", 340, "key.categories.movement", () -> this.toggleCrouch.get());
    public final KeyMapping keySprint = new ToggleKeyMapping("key.sprint", 341, "key.categories.movement", () -> this.toggleSprint.get());
    public final KeyMapping keyInventory = new KeyMapping("key.inventory", 69, "key.categories.inventory");
    public final KeyMapping keySwapOffhand = new KeyMapping("key.swapOffhand", 70, "key.categories.inventory");
    public final KeyMapping keyDrop = new KeyMapping("key.drop", 81, "key.categories.inventory");
    public final KeyMapping keyUse = new KeyMapping("key.use", InputConstants.Type.MOUSE, 1, "key.categories.gameplay");
    public final KeyMapping keyAttack = new KeyMapping("key.attack", InputConstants.Type.MOUSE, 0, "key.categories.gameplay");
    public final KeyMapping keyPickItem = new KeyMapping("key.pickItem", InputConstants.Type.MOUSE, 2, "key.categories.gameplay");
    public final KeyMapping keyChat = new KeyMapping("key.chat", 84, "key.categories.multiplayer");
    public final KeyMapping keyPlayerList = new KeyMapping("key.playerlist", 258, "key.categories.multiplayer");
    public final KeyMapping keyCommand = new KeyMapping("key.command", 47, "key.categories.multiplayer");
    public final KeyMapping keySocialInteractions = new KeyMapping("key.socialInteractions", 80, "key.categories.multiplayer");
    public final KeyMapping keyScreenshot = new KeyMapping("key.screenshot", 291, "key.categories.misc");
    public final KeyMapping keyTogglePerspective = new KeyMapping("key.togglePerspective", 294, "key.categories.misc");
    public final KeyMapping keySmoothCamera = new KeyMapping("key.smoothCamera", InputConstants.UNKNOWN.getValue(), "key.categories.misc");
    public final KeyMapping keyFullscreen = new KeyMapping("key.fullscreen", 300, "key.categories.misc");
    public final KeyMapping keySpectatorOutlines = new KeyMapping("key.spectatorOutlines", InputConstants.UNKNOWN.getValue(), "key.categories.misc");
    public final KeyMapping keyAdvancements = new KeyMapping("key.advancements", 76, "key.categories.misc");
    public final KeyMapping[] keyHotbarSlots = new KeyMapping[]{new KeyMapping("key.hotbar.1", 49, "key.categories.inventory"), new KeyMapping("key.hotbar.2", 50, "key.categories.inventory"), new KeyMapping("key.hotbar.3", 51, "key.categories.inventory"), new KeyMapping("key.hotbar.4", 52, "key.categories.inventory"), new KeyMapping("key.hotbar.5", 53, "key.categories.inventory"), new KeyMapping("key.hotbar.6", 54, "key.categories.inventory"), new KeyMapping("key.hotbar.7", 55, "key.categories.inventory"), new KeyMapping("key.hotbar.8", 56, "key.categories.inventory"), new KeyMapping("key.hotbar.9", 57, "key.categories.inventory")};
    public final KeyMapping keySaveHotbarActivator = new KeyMapping("key.saveToolbarActivator", 67, "key.categories.creative");
    public final KeyMapping keyLoadHotbarActivator = new KeyMapping("key.loadToolbarActivator", 88, "key.categories.creative");
    public KeyMapping[] keyMappings = (KeyMapping[])ArrayUtils.addAll((Object[])new KeyMapping[]{this.keyAttack, this.keyUse, this.keyUp, this.keyLeft, this.keyDown, this.keyRight, this.keyJump, this.keyShift, this.keySprint, this.keyDrop, this.keyInventory, this.keyChat, this.keyPlayerList, this.keyPickItem, this.keyCommand, this.keySocialInteractions, this.keyScreenshot, this.keyTogglePerspective, this.keySmoothCamera, this.keyFullscreen, this.keySpectatorOutlines, this.keySwapOffhand, this.keySaveHotbarActivator, this.keyLoadHotbarActivator, this.keyAdvancements}, (Object[])this.keyHotbarSlots);
    protected Minecraft minecraft;
    private final File optionsFile;
    public boolean hideGui;
    private CameraType cameraType = CameraType.FIRST_PERSON;
    public String lastMpIp = "";
    public boolean smoothCamera;
    private final OptionInstance<Integer> fov = new OptionInstance("options.fov", OptionInstance.noTooltip(), (p_231999_, p_232000_) -> switch (p_232000_) {
        case 70 -> Options.genericValueLabel(p_231999_, Component.translatable("options.fov.min"));
        case 110 -> Options.genericValueLabel(p_231999_, Component.translatable("options.fov.max"));
        default -> Options.genericValueLabel(p_231999_, p_232000_);
    }, (OptionInstance.ValueSet)new OptionInstance.IntRange(30, 110), Codec.DOUBLE.xmap(p_232007_ -> (int)(p_232007_ * 40.0 + 70.0), p_232009_ -> ((double)p_232009_.intValue() - 70.0) / 40.0), (Object)70, p_231992_ -> Minecraft.getInstance().levelRenderer.needsUpdate());
    private static final Component TELEMETRY_TOOLTIP = Component.translatable("options.telemetry.button.tooltip", Component.translatable("options.telemetry.state.minimal"), Component.translatable("options.telemetry.state.all"));
    private final OptionInstance<Boolean> telemetryOptInExtra = OptionInstance.createBoolean((String)"options.telemetry.button", (OptionInstance.TooltipSupplier)OptionInstance.cachedConstantTooltip((Component)TELEMETRY_TOOLTIP), (p_261356_, p_261357_) -> {
        Minecraft minecraft = Minecraft.getInstance();
        if (!minecraft.allowsTelemetry()) {
            return Component.translatable("options.telemetry.state.none");
        }
        return p_261357_ != false && minecraft.extraTelemetryAvailable() ? Component.translatable("options.telemetry.state.all") : Component.translatable("options.telemetry.state.minimal");
    }, (boolean)false, p_366394_ -> {});
    private static final Component ACCESSIBILITY_TOOLTIP_SCREEN_EFFECT = Component.translatable("options.screenEffectScale.tooltip");
    private final OptionInstance<Double> screenEffectScale = new OptionInstance("options.screenEffectScale", OptionInstance.cachedConstantTooltip((Component)ACCESSIBILITY_TOOLTIP_SCREEN_EFFECT), Options::percentValueOrOffLabel, (OptionInstance.ValueSet)OptionInstance.UnitDouble.INSTANCE, (Object)1.0, p_268127_ -> {});
    private static final Component ACCESSIBILITY_TOOLTIP_FOV_EFFECT = Component.translatable("options.fovEffectScale.tooltip");
    private final OptionInstance<Double> fovEffectScale = new OptionInstance("options.fovEffectScale", OptionInstance.cachedConstantTooltip((Component)ACCESSIBILITY_TOOLTIP_FOV_EFFECT), Options::percentValueOrOffLabel, (OptionInstance.ValueSet)OptionInstance.UnitDouble.INSTANCE.xmap(Mth::square, Math::sqrt), Codec.doubleRange((double)0.0, (double)1.0), (Object)1.0, p_332854_ -> {});
    private static final Component ACCESSIBILITY_TOOLTIP_DARKNESS_EFFECT = Component.translatable("options.darknessEffectScale.tooltip");
    private final OptionInstance<Double> darknessEffectScale = new OptionInstance("options.darknessEffectScale", OptionInstance.cachedConstantTooltip((Component)ACCESSIBILITY_TOOLTIP_DARKNESS_EFFECT), Options::percentValueOrOffLabel, (OptionInstance.ValueSet)OptionInstance.UnitDouble.INSTANCE.xmap(Mth::square, Math::sqrt), (Object)1.0, p_368983_ -> {});
    private static final Component ACCESSIBILITY_TOOLTIP_GLINT_SPEED = Component.translatable("options.glintSpeed.tooltip");
    private final OptionInstance<Double> glintSpeed = new OptionInstance("options.glintSpeed", OptionInstance.cachedConstantTooltip((Component)ACCESSIBILITY_TOOLTIP_GLINT_SPEED), Options::percentValueOrOffLabel, (OptionInstance.ValueSet)OptionInstance.UnitDouble.INSTANCE, (Object)0.5, p_363697_ -> {});
    private static final Component ACCESSIBILITY_TOOLTIP_GLINT_STRENGTH = Component.translatable("options.glintStrength.tooltip");
    private final OptionInstance<Double> glintStrength = new OptionInstance("options.glintStrength", OptionInstance.cachedConstantTooltip((Component)ACCESSIBILITY_TOOLTIP_GLINT_STRENGTH), Options::percentValueOrOffLabel, (OptionInstance.ValueSet)OptionInstance.UnitDouble.INSTANCE, (Object)0.75, RenderSystem::setShaderGlintAlpha);
    private static final Component ACCESSIBILITY_TOOLTIP_DAMAGE_TILT_STRENGTH = Component.translatable("options.damageTiltStrength.tooltip");
    private final OptionInstance<Double> damageTiltStrength = new OptionInstance("options.damageTiltStrength", OptionInstance.cachedConstantTooltip((Component)ACCESSIBILITY_TOOLTIP_DAMAGE_TILT_STRENGTH), Options::percentValueOrOffLabel, (OptionInstance.ValueSet)OptionInstance.UnitDouble.INSTANCE, (Object)1.0, p_357646_ -> {});
    private final OptionInstance<Double> gamma = new OptionInstance("options.gamma", OptionInstance.noTooltip(), (p_231913_, p_231914_) -> {
        int i = (int)(p_231914_ * 100.0);
        if (i == 0) {
            return Options.genericValueLabel(p_231913_, Component.translatable("options.gamma.min"));
        }
        if (i == 50) {
            return Options.genericValueLabel(p_231913_, Component.translatable("options.gamma.default"));
        }
        return i == 100 ? Options.genericValueLabel(p_231913_, Component.translatable("options.gamma.max")) : Options.genericValueLabel(p_231913_, i);
    }, (OptionInstance.ValueSet)OptionInstance.UnitDouble.INSTANCE, (Object)0.5, p_357643_ -> {});
    public static final int AUTO_GUI_SCALE = 0;
    private static final int MAX_GUI_SCALE_INCLUSIVE = 0x7FFFFFFE;
    private final OptionInstance<Integer> guiScale = new OptionInstance("options.guiScale", OptionInstance.noTooltip(), (p_231982_, p_231983_) -> p_231983_ == 0 ? Component.translatable("options.guiScale.auto") : Component.literal(Integer.toString(p_231983_)), (OptionInstance.ValueSet)new OptionInstance.ClampingLazyMaxIntRange(0, () -> {
        Minecraft minecraft = Minecraft.getInstance();
        return !minecraft.isRunning() ? 0x7FFFFFFE : minecraft.getWindow().calculateScale(0, minecraft.isEnforceUnicode());
    }, 0x7FFFFFFE), (Object)0, p_325288_ -> this.minecraft.resizeDisplay());
    private final OptionInstance<ParticleStatus> particles = new OptionInstance("options.particles", OptionInstance.noTooltip(), OptionInstance.forOptionEnum(), (OptionInstance.ValueSet)new OptionInstance.Enum(Arrays.asList(ParticleStatus.values()), Codec.INT.xmap(ParticleStatus::byId, ParticleStatus::getId)), (Object)ParticleStatus.ALL, p_357647_ -> {});
    private final OptionInstance<NarratorStatus> narrator = new OptionInstance("options.narrator", OptionInstance.noTooltip(), (p_231907_, p_231908_) -> this.minecraft.getNarrator().isActive() ? p_231908_.getName() : Component.translatable("options.narrator.notavailable"), (OptionInstance.ValueSet)new OptionInstance.Enum(Arrays.asList(NarratorStatus.values()), Codec.INT.xmap(NarratorStatus::byId, NarratorStatus::getId)), (Object)NarratorStatus.OFF, p_231860_ -> this.minecraft.getNarrator().updateNarratorStatus(p_231860_));
    public String languageCode = "en_us";
    private final OptionInstance<String> soundDevice = new OptionInstance("options.audioDevice", OptionInstance.noTooltip(), (p_231919_, p_231920_) -> {
        if (DEFAULT_SOUND_DEVICE.equals(p_231920_)) {
            return Component.translatable("options.audioDevice.default");
        }
        return p_231920_.startsWith("OpenAL Soft on ") ? Component.literal(p_231920_.substring(SoundEngine.OPEN_AL_SOFT_PREFIX_LENGTH)) : Component.literal(p_231920_);
    }, (OptionInstance.ValueSet)new OptionInstance.LazyEnum(() -> Stream.concat(Stream.of(DEFAULT_SOUND_DEVICE), Minecraft.getInstance().getSoundManager().getAvailableSoundDevices().stream()).toList(), p_232011_ -> Minecraft.getInstance().isRunning() && (p_232011_ == null || !p_232011_.isEmpty()) && !Minecraft.getInstance().getSoundManager().getAvailableSoundDevices().contains(p_232011_) ? Optional.empty() : Optional.of(p_232011_), (Codec)Codec.STRING), (Object)"", p_299350_ -> {
        SoundManager soundmanager = Minecraft.getInstance().getSoundManager();
        soundmanager.reload();
        soundmanager.play((SoundInstance)SimpleSoundInstance.forUI(SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
    });
    public boolean onboardAccessibility = true;
    public boolean syncWrites;

    public OptionInstance<Boolean> darkMojangStudiosBackground() {
        return this.darkMojangStudiosBackground;
    }

    public OptionInstance<Boolean> hideLightningFlash() {
        return this.hideLightningFlash;
    }

    public OptionInstance<Boolean> hideSplashTexts() {
        return this.hideSplashTexts;
    }

    public OptionInstance<Double> sensitivity() {
        return this.sensitivity;
    }

    public OptionInstance<Integer> renderDistance() {
        return this.renderDistance;
    }

    public OptionInstance<Integer> simulationDistance() {
        return this.simulationDistance;
    }

    public OptionInstance<Double> entityDistanceScaling() {
        return this.entityDistanceScaling;
    }

    public OptionInstance<Integer> framerateLimit() {
        return this.framerateLimit;
    }

    public OptionInstance<InactivityFpsLimit> inactivityFpsLimit() {
        return this.inactivityFpsLimit;
    }

    public OptionInstance<CloudStatus> cloudStatus() {
        return this.cloudStatus;
    }

    public OptionInstance<GraphicsStatus> graphicsMode() {
        return this.graphicsMode;
    }

    public OptionInstance<Boolean> ambientOcclusion() {
        return this.ambientOcclusion;
    }

    public OptionInstance<PrioritizeChunkUpdates> prioritizeChunkUpdates() {
        return this.prioritizeChunkUpdates;
    }

    public void updateResourcePacks(PackRepository p_275268_) {
        ImmutableList list = ImmutableList.copyOf(this.resourcePacks);
        this.resourcePacks.clear();
        this.incompatibleResourcePacks.clear();
        for (Pack pack : p_275268_.getSelectedPacks()) {
            if (pack.isFixedPosition()) continue;
            this.resourcePacks.add(pack.getId());
            if (pack.getCompatibility().isCompatible()) continue;
            this.incompatibleResourcePacks.add(pack.getId());
        }
        this.save();
        ImmutableList list1 = ImmutableList.copyOf(this.resourcePacks);
        if (!list1.equals(list)) {
            this.minecraft.reloadResourcePacks();
        }
    }

    public OptionInstance<ChatVisiblity> chatVisibility() {
        return this.chatVisibility;
    }

    public OptionInstance<Double> chatOpacity() {
        return this.chatOpacity;
    }

    public OptionInstance<Double> chatLineSpacing() {
        return this.chatLineSpacing;
    }

    public OptionInstance<Integer> menuBackgroundBlurriness() {
        return this.menuBackgroundBlurriness;
    }

    public int getMenuBackgroundBlurriness() {
        return (Integer)this.menuBackgroundBlurriness().get();
    }

    public OptionInstance<Double> textBackgroundOpacity() {
        return this.textBackgroundOpacity;
    }

    public OptionInstance<Double> panoramaSpeed() {
        return this.panoramaSpeed;
    }

    public OptionInstance<Boolean> highContrast() {
        return this.highContrast;
    }

    public OptionInstance<Boolean> highContrastBlockOutline() {
        return this.highContrastBlockOutline;
    }

    public OptionInstance<Boolean> narratorHotkey() {
        return this.narratorHotkey;
    }

    public OptionInstance<HumanoidArm> mainHand() {
        return this.mainHand;
    }

    public OptionInstance<Double> chatScale() {
        return this.chatScale;
    }

    public OptionInstance<Double> chatWidth() {
        return this.chatWidth;
    }

    public OptionInstance<Double> chatHeightUnfocused() {
        return this.chatHeightUnfocused;
    }

    public OptionInstance<Double> chatHeightFocused() {
        return this.chatHeightFocused;
    }

    public OptionInstance<Double> chatDelay() {
        return this.chatDelay;
    }

    public OptionInstance<Double> notificationDisplayTime() {
        return this.notificationDisplayTime;
    }

    public OptionInstance<Integer> mipmapLevels() {
        return this.mipmapLevels;
    }

    public OptionInstance<AttackIndicatorStatus> attackIndicator() {
        return this.attackIndicator;
    }

    public OptionInstance<Integer> biomeBlendRadius() {
        return this.biomeBlendRadius;
    }

    private static double logMouse(int p_231966_) {
        return Math.pow(10.0, (double)p_231966_ / 100.0);
    }

    private static int unlogMouse(double p_231840_) {
        return Mth.floor(Math.log10(p_231840_) * 100.0);
    }

    public OptionInstance<Double> mouseWheelSensitivity() {
        return this.mouseWheelSensitivity;
    }

    public OptionInstance<Boolean> rawMouseInput() {
        return this.rawMouseInput;
    }

    public OptionInstance<Boolean> autoJump() {
        return this.autoJump;
    }

    public OptionInstance<Boolean> rotateWithMinecart() {
        return this.rotateWithMinecart;
    }

    public OptionInstance<Boolean> operatorItemsTab() {
        return this.operatorItemsTab;
    }

    public OptionInstance<Boolean> autoSuggestions() {
        return this.autoSuggestions;
    }

    public OptionInstance<Boolean> chatColors() {
        return this.chatColors;
    }

    public OptionInstance<Boolean> chatLinks() {
        return this.chatLinks;
    }

    public OptionInstance<Boolean> chatLinksPrompt() {
        return this.chatLinksPrompt;
    }

    public OptionInstance<Boolean> enableVsync() {
        return this.enableVsync;
    }

    public OptionInstance<Boolean> entityShadows() {
        return this.entityShadows;
    }

    private static void updateFontOptions() {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.getWindow() != null) {
            minecraft.updateFontOptions();
            minecraft.resizeDisplay();
        }
    }

    public OptionInstance<Boolean> forceUnicodeFont() {
        return this.forceUnicodeFont;
    }

    private static boolean japaneseGlyphVariantsDefault() {
        return Locale.getDefault().getLanguage().equalsIgnoreCase("ja");
    }

    public OptionInstance<Boolean> japaneseGlyphVariants() {
        return this.japaneseGlyphVariants;
    }

    public OptionInstance<Boolean> invertYMouse() {
        return this.invertYMouse;
    }

    public OptionInstance<Boolean> discreteMouseScroll() {
        return this.discreteMouseScroll;
    }

    public OptionInstance<Boolean> realmsNotifications() {
        return this.realmsNotifications;
    }

    public OptionInstance<Boolean> allowServerListing() {
        return this.allowServerListing;
    }

    public OptionInstance<Boolean> reducedDebugInfo() {
        return this.reducedDebugInfo;
    }

    public final float getSoundSourceVolume(SoundSource p_92148_) {
        return ((Double)this.getSoundSourceOptionInstance(p_92148_).get()).floatValue();
    }

    public final OptionInstance<Double> getSoundSourceOptionInstance(SoundSource p_251574_) {
        return Objects.requireNonNull(this.soundSourceVolumes.get((Object)p_251574_));
    }

    private OptionInstance<Double> createSoundSliderOptionInstance(String p_250353_, SoundSource p_249262_) {
        return new OptionInstance(p_250353_, OptionInstance.noTooltip(), Options::percentValueOrOffLabel, (OptionInstance.ValueSet)OptionInstance.UnitDouble.INSTANCE, (Object)1.0, p_247768_ -> Minecraft.getInstance().getSoundManager().updateSourceVolume(p_249262_, p_247768_.floatValue()));
    }

    public OptionInstance<Boolean> showSubtitles() {
        return this.showSubtitles;
    }

    public OptionInstance<Boolean> directionalAudio() {
        return this.directionalAudio;
    }

    public OptionInstance<Boolean> backgroundForChatOnly() {
        return this.backgroundForChatOnly;
    }

    public OptionInstance<Boolean> touchscreen() {
        return this.touchscreen;
    }

    public OptionInstance<Boolean> fullscreen() {
        return this.fullscreen;
    }

    public OptionInstance<Boolean> bobView() {
        return this.bobView;
    }

    public OptionInstance<Boolean> toggleCrouch() {
        return this.toggleCrouch;
    }

    public OptionInstance<Boolean> toggleSprint() {
        return this.toggleSprint;
    }

    public OptionInstance<Boolean> hideMatchedNames() {
        return this.hideMatchedNames;
    }

    public OptionInstance<Boolean> showAutosaveIndicator() {
        return this.showAutosaveIndicator;
    }

    public OptionInstance<Boolean> onlyShowSecureChat() {
        return this.onlyShowSecureChat;
    }

    public OptionInstance<Integer> fov() {
        return this.fov;
    }

    public OptionInstance<Boolean> telemetryOptInExtra() {
        return this.telemetryOptInExtra;
    }

    public OptionInstance<Double> screenEffectScale() {
        return this.screenEffectScale;
    }

    public OptionInstance<Double> fovEffectScale() {
        return this.fovEffectScale;
    }

    public OptionInstance<Double> darknessEffectScale() {
        return this.darknessEffectScale;
    }

    public OptionInstance<Double> glintSpeed() {
        return this.glintSpeed;
    }

    public OptionInstance<Double> glintStrength() {
        return this.glintStrength;
    }

    public OptionInstance<Double> damageTiltStrength() {
        return this.damageTiltStrength;
    }

    public OptionInstance<Double> gamma() {
        return this.gamma;
    }

    public OptionInstance<Integer> guiScale() {
        return this.guiScale;
    }

    public OptionInstance<ParticleStatus> particles() {
        return this.particles;
    }

    public OptionInstance<NarratorStatus> narrator() {
        return this.narrator;
    }

    public OptionInstance<String> soundDevice() {
        return this.soundDevice;
    }

    public void onboardingAccessibilityFinished() {
        this.onboardAccessibility = false;
        this.save();
    }

    public Options(Minecraft p_92138_, File p_92139_) {
        this.setForgeKeybindProperties();
        this.minecraft = p_92138_;
        this.optionsFile = new File(p_92139_, "options.txt");
        boolean flag = Runtime.getRuntime().maxMemory() >= 1000000000L;
        this.renderDistance = new OptionInstance("options.renderDistance", OptionInstance.noTooltip(), (p_231916_, p_270801_) -> Options.genericValueLabel(p_231916_, Component.translatable("options.chunks", p_270801_)), (OptionInstance.ValueSet)new OptionInstance.IntRange(2, flag ? 32 : 16, false), (Object)12, p_231951_ -> Minecraft.getInstance().levelRenderer.needsUpdate());
        this.simulationDistance = new OptionInstance("options.simulationDistance", OptionInstance.noTooltip(), (p_264664_, p_300054_) -> Options.genericValueLabel(p_264664_, Component.translatable("options.chunks", p_300054_)), (OptionInstance.ValueSet)new OptionInstance.IntRange(5, flag ? 32 : 16, false), (Object)12, p_357642_ -> {});
        this.syncWrites = Util.getPlatform() == Util.OS.WINDOWS;
        this.load();
    }

    public float getBackgroundOpacity(float p_92142_) {
        return (Boolean)this.backgroundForChatOnly.get() != false ? p_92142_ : ((Double)this.textBackgroundOpacity().get()).floatValue();
    }

    public int getBackgroundColor(float p_92171_) {
        return ARGB.colorFromFloat(this.getBackgroundOpacity(p_92171_), 0.0f, 0.0f, 0.0f);
    }

    public int getBackgroundColor(int p_92144_) {
        return (Boolean)this.backgroundForChatOnly.get() != false ? p_92144_ : ARGB.colorFromFloat(((Double)this.textBackgroundOpacity.get()).floatValue(), 0.0f, 0.0f, 0.0f);
    }

    private void processDumpedOptions(OptionAccess p_329807_) {
        p_329807_.process("ao", this.ambientOcclusion);
        p_329807_.process("biomeBlendRadius", this.biomeBlendRadius);
        p_329807_.process("enableVsync", this.enableVsync);
        p_329807_.process("entityDistanceScaling", this.entityDistanceScaling);
        p_329807_.process("entityShadows", this.entityShadows);
        p_329807_.process("forceUnicodeFont", this.forceUnicodeFont);
        p_329807_.process("japaneseGlyphVariants", this.japaneseGlyphVariants);
        p_329807_.process("fov", this.fov);
        p_329807_.process("fovEffectScale", this.fovEffectScale);
        p_329807_.process("darknessEffectScale", this.darknessEffectScale);
        p_329807_.process("glintSpeed", this.glintSpeed);
        p_329807_.process("glintStrength", this.glintStrength);
        p_329807_.process("prioritizeChunkUpdates", this.prioritizeChunkUpdates);
        p_329807_.process("fullscreen", this.fullscreen);
        p_329807_.process("gamma", this.gamma);
        p_329807_.process("graphicsMode", this.graphicsMode);
        p_329807_.process("guiScale", this.guiScale);
        p_329807_.process("maxFps", this.framerateLimit);
        p_329807_.process("inactivityFpsLimit", this.inactivityFpsLimit);
        p_329807_.process("mipmapLevels", this.mipmapLevels);
        p_329807_.process("narrator", this.narrator);
        p_329807_.process("particles", this.particles);
        p_329807_.process("reducedDebugInfo", this.reducedDebugInfo);
        p_329807_.process("renderClouds", this.cloudStatus);
        p_329807_.process("renderDistance", this.renderDistance);
        p_329807_.process("simulationDistance", this.simulationDistance);
        p_329807_.process("screenEffectScale", this.screenEffectScale);
        p_329807_.process("soundDevice", this.soundDevice);
    }

    private void processOptions(FieldAccess p_168428_) {
        this.processDumpedOptions(p_168428_);
        p_168428_.process("autoJump", this.autoJump);
        p_168428_.process("rotateWithMinecart", this.rotateWithMinecart);
        p_168428_.process("operatorItemsTab", this.operatorItemsTab);
        p_168428_.process("autoSuggestions", this.autoSuggestions);
        p_168428_.process("chatColors", this.chatColors);
        p_168428_.process("chatLinks", this.chatLinks);
        p_168428_.process("chatLinksPrompt", this.chatLinksPrompt);
        p_168428_.process("discrete_mouse_scroll", this.discreteMouseScroll);
        p_168428_.process("invertYMouse", this.invertYMouse);
        p_168428_.process("realmsNotifications", this.realmsNotifications);
        p_168428_.process("showSubtitles", this.showSubtitles);
        p_168428_.process("directionalAudio", this.directionalAudio);
        p_168428_.process("touchscreen", this.touchscreen);
        p_168428_.process("bobView", this.bobView);
        p_168428_.process("toggleCrouch", this.toggleCrouch);
        p_168428_.process("toggleSprint", this.toggleSprint);
        p_168428_.process("darkMojangStudiosBackground", this.darkMojangStudiosBackground);
        p_168428_.process("hideLightningFlashes", this.hideLightningFlash);
        p_168428_.process("hideSplashTexts", this.hideSplashTexts);
        p_168428_.process("mouseSensitivity", this.sensitivity);
        p_168428_.process("damageTiltStrength", this.damageTiltStrength);
        p_168428_.process("highContrast", this.highContrast);
        p_168428_.process("highContrastBlockOutline", this.highContrastBlockOutline);
        p_168428_.process("narratorHotkey", this.narratorHotkey);
        this.resourcePacks = p_168428_.process("resourcePacks", this.resourcePacks, Options::readListOfStrings, arg_0 -> ((Gson)GSON).toJson(arg_0));
        this.incompatibleResourcePacks = p_168428_.process("incompatibleResourcePacks", this.incompatibleResourcePacks, Options::readListOfStrings, arg_0 -> ((Gson)GSON).toJson(arg_0));
        this.lastMpIp = p_168428_.process("lastServer", this.lastMpIp);
        this.languageCode = p_168428_.process("lang", this.languageCode);
        p_168428_.process("chatVisibility", this.chatVisibility);
        p_168428_.process("chatOpacity", this.chatOpacity);
        p_168428_.process("chatLineSpacing", this.chatLineSpacing);
        p_168428_.process("textBackgroundOpacity", this.textBackgroundOpacity);
        p_168428_.process("backgroundForChatOnly", this.backgroundForChatOnly);
        this.hideServerAddress = p_168428_.process("hideServerAddress", this.hideServerAddress);
        this.advancedItemTooltips = p_168428_.process("advancedItemTooltips", this.advancedItemTooltips);
        this.pauseOnLostFocus = p_168428_.process("pauseOnLostFocus", this.pauseOnLostFocus);
        this.overrideWidth = p_168428_.process("overrideWidth", this.overrideWidth);
        this.overrideHeight = p_168428_.process("overrideHeight", this.overrideHeight);
        p_168428_.process("chatHeightFocused", this.chatHeightFocused);
        p_168428_.process("chatDelay", this.chatDelay);
        p_168428_.process("chatHeightUnfocused", this.chatHeightUnfocused);
        p_168428_.process("chatScale", this.chatScale);
        p_168428_.process("chatWidth", this.chatWidth);
        p_168428_.process("notificationDisplayTime", this.notificationDisplayTime);
        this.useNativeTransport = p_168428_.process("useNativeTransport", this.useNativeTransport);
        p_168428_.process("mainHand", this.mainHand);
        p_168428_.process("attackIndicator", this.attackIndicator);
        this.tutorialStep = p_168428_.process("tutorialStep", this.tutorialStep, TutorialSteps::getByName, TutorialSteps::getName);
        p_168428_.process("mouseWheelSensitivity", this.mouseWheelSensitivity);
        p_168428_.process("rawMouseInput", this.rawMouseInput);
        this.glDebugVerbosity = p_168428_.process("glDebugVerbosity", this.glDebugVerbosity);
        this.skipMultiplayerWarning = p_168428_.process("skipMultiplayerWarning", this.skipMultiplayerWarning);
        p_168428_.process("hideMatchedNames", this.hideMatchedNames);
        this.joinedFirstServer = p_168428_.process("joinedFirstServer", this.joinedFirstServer);
        this.syncWrites = p_168428_.process("syncChunkWrites", this.syncWrites);
        p_168428_.process("showAutosaveIndicator", this.showAutosaveIndicator);
        p_168428_.process("allowServerListing", this.allowServerListing);
        p_168428_.process("onlyShowSecureChat", this.onlyShowSecureChat);
        p_168428_.process("panoramaScrollSpeed", this.panoramaSpeed);
        p_168428_.process("telemetryOptInExtra", this.telemetryOptInExtra);
        this.onboardAccessibility = p_168428_.process("onboardAccessibility", this.onboardAccessibility);
        p_168428_.process("menuBackgroundBlurriness", this.menuBackgroundBlurriness);
        this.processOptionsForge(p_168428_);
    }

    private void processOptionsForge(FieldAccess p_168428_) {
        for (KeyMapping keyMapping : this.keyMappings) {
            String s1;
            String s = keyMapping.saveString() + (String)(keyMapping.getKeyModifier() != KeyModifier.NONE ? ":" + String.valueOf(keyMapping.getKeyModifier()) : DEFAULT_SOUND_DEVICE);
            if (s.equals(s1 = p_168428_.process("key_" + keyMapping.getName(), s))) continue;
            keyMapping.setKey(InputConstants.getKey((String)s1));
            if (s1.indexOf(58) != -1) {
                String[] pts = s1.split(":");
                keyMapping.setKeyModifierAndCode(KeyModifier.valueFromString((String)pts[1]), InputConstants.getKey((String)pts[0]));
                continue;
            }
            keyMapping.setKeyModifierAndCode(KeyModifier.NONE, InputConstants.getKey((String)s1));
        }
        for (SoundSource soundSource : SoundSource.values()) {
            p_168428_.process("soundCategory_" + soundSource.getName(), this.soundSourceVolumes.get((Object)soundSource));
        }
        for (PlayerModelPart playerModelPart : PlayerModelPart.values()) {
            boolean flag = this.modelParts.contains((Object)playerModelPart);
            boolean flag1 = p_168428_.process("modelPart_" + playerModelPart.getId(), flag);
            if (flag1 == flag) continue;
            this.setModelPart(playerModelPart, flag1);
        }
    }

    public void load() {
        this.load(false);
    }

    public void load(boolean limited) {
        try {
            if (!this.optionsFile.exists()) {
                return;
            }
            CompoundTag compoundtag = new CompoundTag();
            try (BufferedReader bufferedreader = Files.newReader((File)this.optionsFile, (Charset)Charsets.UTF_8);){
                bufferedreader.lines().forEach(p_231896_ -> {
                    try {
                        Iterator iterator = OPTION_SPLITTER.split((CharSequence)p_231896_).iterator();
                        compoundtag.putString((String)iterator.next(), (String)iterator.next());
                    }
                    catch (Exception exception1) {
                        LOGGER.warn("Skipping bad option: {}", p_231896_);
                    }
                });
            }
            final CompoundTag compoundtag1 = this.dataFix(compoundtag);
            if (!compoundtag1.contains("graphicsMode") && compoundtag1.contains("fancyGraphics")) {
                if (Options.isTrue(compoundtag1.getString("fancyGraphics"))) {
                    this.graphicsMode.set((Object)GraphicsStatus.FANCY);
                } else {
                    this.graphicsMode.set((Object)GraphicsStatus.FAST);
                }
            }
            Consumer<FieldAccess> processor = limited ? this::processOptionsForge : this::processOptions;
            processor.accept(new FieldAccess(){

                @Nullable
                private String getValueOrNull(String p_168459_) {
                    return compoundtag1.contains(p_168459_) ? compoundtag1.get(p_168459_).getAsString() : null;
                }

                @Override
                public <T> void process(String p_232125_, OptionInstance<T> p_232126_) {
                    String s = this.getValueOrNull(p_232125_);
                    if (s != null) {
                        JsonReader jsonreader = new JsonReader((Reader)new StringReader(s.isEmpty() ? "\"\"" : s));
                        JsonElement jsonelement = JsonParser.parseReader((JsonReader)jsonreader);
                        DataResult dataresult = p_232126_.codec().parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonelement);
                        dataresult.error().ifPresent(p_325291_ -> LOGGER.error("Error parsing option value " + s + " for option " + String.valueOf(p_232126_) + ": " + p_325291_.message()));
                        dataresult.ifSuccess(arg_0 -> p_232126_.set(arg_0));
                    }
                }

                @Override
                public int process(String p_168467_, int p_168468_) {
                    String s = this.getValueOrNull(p_168467_);
                    if (s != null) {
                        try {
                            return Integer.parseInt(s);
                        }
                        catch (NumberFormatException numberformatexception) {
                            LOGGER.warn("Invalid integer value for option {} = {}", new Object[]{p_168467_, s, numberformatexception});
                        }
                    }
                    return p_168468_;
                }

                @Override
                public boolean process(String p_168483_, boolean p_168484_) {
                    String s = this.getValueOrNull(p_168483_);
                    return s != null ? Options.isTrue(s) : p_168484_;
                }

                @Override
                public String process(String p_168480_, String p_168481_) {
                    return (String)MoreObjects.firstNonNull((Object)this.getValueOrNull(p_168480_), (Object)p_168481_);
                }

                @Override
                public float process(String p_168464_, float p_168465_) {
                    String s = this.getValueOrNull(p_168464_);
                    if (s == null) {
                        return p_168465_;
                    }
                    if (Options.isTrue(s)) {
                        return 1.0f;
                    }
                    if (Options.isFalse(s)) {
                        return 0.0f;
                    }
                    try {
                        return Float.parseFloat(s);
                    }
                    catch (NumberFormatException numberformatexception) {
                        LOGGER.warn("Invalid floating point value for option {} = {}", new Object[]{p_168464_, s, numberformatexception});
                        return p_168465_;
                    }
                }

                @Override
                public <T> T process(String p_168470_, T p_168471_, Function<String, T> p_168472_, Function<T, String> p_168473_) {
                    String s = this.getValueOrNull(p_168470_);
                    return s == null ? p_168471_ : p_168472_.apply(s);
                }
            });
            if (compoundtag1.contains("fullscreenResolution")) {
                this.fullscreenVideoModeString = compoundtag1.getString("fullscreenResolution");
            }
            KeyMapping.resetMapping();
        }
        catch (Exception exception) {
            LOGGER.error("Failed to load options", (Throwable)exception);
        }
    }

    static boolean isTrue(String p_168436_) {
        return "true".equals(p_168436_);
    }

    static boolean isFalse(String p_168441_) {
        return "false".equals(p_168441_);
    }

    private CompoundTag dataFix(CompoundTag p_92165_) {
        int i = 0;
        try {
            i = Integer.parseInt(p_92165_.getString("version"));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return DataFixTypes.OPTIONS.updateToCurrentVersion(this.minecraft.getFixerUpper(), p_92165_, i);
    }

    public void save() {
        try (final PrintWriter printwriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.optionsFile), StandardCharsets.UTF_8));){
            printwriter.println("version:" + SharedConstants.getCurrentVersion().getDataVersion().getVersion());
            this.processOptions(new FieldAccess(){

                public void writePrefix(String p_168491_) {
                    printwriter.print(p_168491_);
                    printwriter.print(':');
                }

                @Override
                public <T> void process(String p_232135_, OptionInstance<T> p_232136_) {
                    p_232136_.codec().encodeStart((DynamicOps)JsonOps.INSTANCE, p_232136_.get()).ifError(p_325293_ -> LOGGER.error("Error saving option " + String.valueOf(p_232136_) + ": " + String.valueOf(p_325293_))).ifSuccess(p_232140_ -> {
                        this.writePrefix(p_232135_);
                        printwriter.println(GSON.toJson(p_232140_));
                    });
                }

                @Override
                public int process(String p_168499_, int p_168500_) {
                    this.writePrefix(p_168499_);
                    printwriter.println(p_168500_);
                    return p_168500_;
                }

                @Override
                public boolean process(String p_168515_, boolean p_168516_) {
                    this.writePrefix(p_168515_);
                    printwriter.println(p_168516_);
                    return p_168516_;
                }

                @Override
                public String process(String p_168512_, String p_168513_) {
                    this.writePrefix(p_168512_);
                    printwriter.println(p_168513_);
                    return p_168513_;
                }

                @Override
                public float process(String p_168496_, float p_168497_) {
                    this.writePrefix(p_168496_);
                    printwriter.println(p_168497_);
                    return p_168497_;
                }

                @Override
                public <T> T process(String p_168502_, T p_168503_, Function<String, T> p_168504_, Function<T, String> p_168505_) {
                    this.writePrefix(p_168502_);
                    printwriter.println(p_168505_.apply(p_168503_));
                    return p_168503_;
                }
            });
            if (this.minecraft.getWindow().getPreferredFullscreenVideoMode().isPresent()) {
                printwriter.println("fullscreenResolution:" + this.minecraft.getWindow().getPreferredFullscreenVideoMode().get().write());
            }
        }
        catch (Exception exception) {
            LOGGER.error("Failed to save options", (Throwable)exception);
        }
        this.broadcastOptions();
    }

    public ClientInformation buildPlayerInformation() {
        int i = 0;
        for (PlayerModelPart playermodelpart : this.modelParts) {
            i |= playermodelpart.getMask();
        }
        return new ClientInformation(this.languageCode, (Integer)this.renderDistance.get(), (ChatVisiblity)this.chatVisibility.get(), (Boolean)this.chatColors.get(), i, (HumanoidArm)this.mainHand.get(), this.minecraft.isTextFilteringEnabled(), (Boolean)this.allowServerListing.get(), (ParticleStatus)this.particles.get());
    }

    public void broadcastOptions() {
        if (ClientModLoader.isLoading()) {
            return;
        }
        if (this.minecraft.player != null) {
            this.minecraft.player.connection.broadcastClientInformation(this.buildPlayerInformation());
        }
    }

    public void setModelPart(PlayerModelPart p_92155_, boolean p_92156_) {
        if (p_92156_) {
            this.modelParts.add(p_92155_);
        } else {
            this.modelParts.remove((Object)p_92155_);
        }
    }

    public boolean isModelPartEnabled(PlayerModelPart p_168417_) {
        return this.modelParts.contains((Object)p_168417_);
    }

    public CloudStatus getCloudsType() {
        return this.getEffectiveRenderDistance() >= 4 ? (CloudStatus)this.cloudStatus.get() : CloudStatus.OFF;
    }

    public boolean useNativeTransport() {
        return this.useNativeTransport;
    }

    public void loadSelectedResourcePacks(PackRepository p_92146_) {
        LinkedHashSet set = Sets.newLinkedHashSet();
        Iterator<String> iterator = this.resourcePacks.iterator();
        while (iterator.hasNext()) {
            String s = iterator.next();
            Pack pack = p_92146_.getPack(s);
            if (pack == null && !s.startsWith("file/")) {
                pack = p_92146_.getPack("file/" + s);
            }
            if (pack == null) {
                LOGGER.warn("Removed resource pack {} from options because it doesn't seem to exist anymore", (Object)s);
                iterator.remove();
                continue;
            }
            if (!pack.getCompatibility().isCompatible() && !this.incompatibleResourcePacks.contains(s)) {
                LOGGER.warn("Removed resource pack {} from options because it is no longer compatible", (Object)s);
                iterator.remove();
                continue;
            }
            if (pack.getCompatibility().isCompatible() && this.incompatibleResourcePacks.contains(s)) {
                LOGGER.info("Removed resource pack {} from incompatibility list because it's now compatible", (Object)s);
                this.incompatibleResourcePacks.remove(s);
                continue;
            }
            set.add(pack.getId());
        }
        p_92146_.setSelected(set);
    }

    public CameraType getCameraType() {
        return this.cameraType;
    }

    public void setCameraType(CameraType p_92158_) {
        this.cameraType = p_92158_;
    }

    private static List<String> readListOfStrings(String p_298720_) {
        ArrayList list = GsonHelper.fromNullableJson(GSON, p_298720_, LIST_OF_STRINGS_TYPE);
        return list != null ? list : Lists.newArrayList();
    }

    public File getFile() {
        return this.optionsFile;
    }

    public String dumpOptionsForReport() {
        final ArrayList<Pair> list = new ArrayList<Pair>();
        this.processDumpedOptions(new OptionAccess(){

            @Override
            public <T> void process(String p_328704_, OptionInstance<T> p_330356_) {
                list.add(Pair.of((Object)p_328704_, (Object)p_330356_.get()));
            }
        });
        list.add(Pair.of((Object)"fullscreenResolution", (Object)String.valueOf(this.fullscreenVideoModeString)));
        list.add(Pair.of((Object)"glDebugVerbosity", (Object)this.glDebugVerbosity));
        list.add(Pair.of((Object)"overrideHeight", (Object)this.overrideHeight));
        list.add(Pair.of((Object)"overrideWidth", (Object)this.overrideWidth));
        list.add(Pair.of((Object)"syncChunkWrites", (Object)this.syncWrites));
        list.add(Pair.of((Object)"useNativeTransport", (Object)this.useNativeTransport));
        list.add(Pair.of((Object)"resourcePacks", this.resourcePacks));
        return list.stream().sorted(Comparator.comparing(Pair::getFirst)).map(p_325285_ -> (String)p_325285_.getFirst() + ": " + String.valueOf(p_325285_.getSecond())).collect(Collectors.joining(System.lineSeparator()));
    }

    public void setServerRenderDistance(int p_193771_) {
        this.serverRenderDistance = p_193771_;
    }

    public int getEffectiveRenderDistance() {
        return this.serverRenderDistance > 0 ? Math.min((Integer)this.renderDistance.get(), this.serverRenderDistance) : (Integer)this.renderDistance.get();
    }

    private static Component pixelValueLabel(Component p_231953_, int p_231954_) {
        return Component.translatable("options.pixel_value", p_231953_, p_231954_);
    }

    private static Component percentValueLabel(Component p_231898_, double p_231899_) {
        return Component.translatable("options.percent_value", p_231898_, (int)(p_231899_ * 100.0));
    }

    public static Component genericValueLabel(Component p_231922_, Component p_231923_) {
        return Component.translatable("options.generic_value", p_231922_, p_231923_);
    }

    public static Component genericValueLabel(Component p_231901_, int p_231902_) {
        return Options.genericValueLabel(p_231901_, Component.literal(Integer.toString(p_231902_)));
    }

    private void setForgeKeybindProperties() {
        KeyConflictContext inGame = KeyConflictContext.IN_GAME;
        this.keyUp.setKeyConflictContext((IKeyConflictContext)inGame);
        this.keyLeft.setKeyConflictContext((IKeyConflictContext)inGame);
        this.keyDown.setKeyConflictContext((IKeyConflictContext)inGame);
        this.keyRight.setKeyConflictContext((IKeyConflictContext)inGame);
        this.keyJump.setKeyConflictContext((IKeyConflictContext)inGame);
        this.keyShift.setKeyConflictContext((IKeyConflictContext)inGame);
        this.keySprint.setKeyConflictContext((IKeyConflictContext)inGame);
        this.keyAttack.setKeyConflictContext((IKeyConflictContext)inGame);
        this.keyChat.setKeyConflictContext((IKeyConflictContext)inGame);
        this.keyPlayerList.setKeyConflictContext((IKeyConflictContext)inGame);
        this.keyCommand.setKeyConflictContext((IKeyConflictContext)inGame);
        this.keyTogglePerspective.setKeyConflictContext((IKeyConflictContext)inGame);
        this.keySmoothCamera.setKeyConflictContext((IKeyConflictContext)inGame);
    }

    public static Component genericValueOrOffLabel(Component p_345288_, int p_344826_) {
        return p_344826_ == 0 ? Options.genericValueLabel(p_345288_, CommonComponents.OPTION_OFF) : Options.genericValueLabel(p_345288_, p_344826_);
    }

    private static Component percentValueOrOffLabel(Component p_335881_, double p_328979_) {
        return p_328979_ == 0.0 ? Options.genericValueLabel(p_335881_, CommonComponents.OPTION_OFF) : Options.percentValueLabel(p_335881_, p_328979_);
    }

    @OnlyIn(value=Dist.CLIENT)
    static interface OptionAccess {
        public <T> void process(String var1, OptionInstance<T> var2);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface FieldAccess
    extends OptionAccess {
        public int process(String var1, int var2);

        public boolean process(String var1, boolean var2);

        public String process(String var1, String var2);

        public float process(String var1, float var2);

        public <T> T process(String var1, T var2, Function<String, T> var3, Function<T, String> var4);
    }
}

