/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.shaders.FogShape;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.FogParameters;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.ARGB;
import net.minecraft.util.CubicSampler;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

@OnlyIn(value=Dist.CLIENT)
public class FogRenderer {
    private static final int WATER_FOG_DISTANCE = 96;
    private static final List<MobEffectFogFunction> MOB_EFFECT_FOG = Lists.newArrayList((Object[])new MobEffectFogFunction[]{new BlindnessFogFunction(), new DarknessFogFunction()});
    public static final float BIOME_FOG_TRANSITION_TIME = 5000.0f;
    private static int targetBiomeFog = -1;
    private static int previousBiomeFog = -1;
    private static long biomeChangedTime = -1L;
    private static boolean fogEnabled = true;

    public static Vector4f computeFogColor(Camera p_362477_, float p_364035_, ClientLevel p_361507_, int p_361512_, float p_367602_) {
        LivingEntity livingentity1;
        float f2;
        float f1;
        float f;
        FogType fogtype = p_362477_.getFluidInCamera();
        Entity entity = p_362477_.getEntity();
        if (fogtype == FogType.WATER) {
            long i = Util.getMillis();
            int k = ((Biome)p_361507_.getBiome(BlockPos.containing(p_362477_.getPosition())).value()).getWaterFogColor();
            if (biomeChangedTime < 0L) {
                targetBiomeFog = k;
                previousBiomeFog = k;
                biomeChangedTime = i;
            }
            int l = targetBiomeFog >> 16 & 0xFF;
            int i1 = targetBiomeFog >> 8 & 0xFF;
            int j1 = targetBiomeFog & 0xFF;
            int k1 = previousBiomeFog >> 16 & 0xFF;
            int l1 = previousBiomeFog >> 8 & 0xFF;
            int i2 = previousBiomeFog & 0xFF;
            float f3 = Mth.clamp((float)(i - biomeChangedTime) / 5000.0f, 0.0f, 1.0f);
            float f4 = Mth.lerp(f3, k1, l);
            float f5 = Mth.lerp(f3, l1, i1);
            float f6 = Mth.lerp(f3, i2, j1);
            f = f4 / 255.0f;
            f1 = f5 / 255.0f;
            f2 = f6 / 255.0f;
            if (targetBiomeFog != k) {
                targetBiomeFog = k;
                previousBiomeFog = Mth.floor(f4) << 16 | Mth.floor(f5) << 8 | Mth.floor(f6);
                biomeChangedTime = i;
            }
        } else if (fogtype == FogType.LAVA) {
            f = 0.6f;
            f1 = 0.1f;
            f2 = 0.0f;
            biomeChangedTime = -1L;
        } else if (fogtype == FogType.POWDER_SNOW) {
            f = 0.623f;
            f1 = 0.734f;
            f2 = 0.785f;
            biomeChangedTime = -1L;
        } else {
            float f18;
            float f7 = 0.25f + 0.75f * (float)p_361512_ / 32.0f;
            f7 = 1.0f - (float)Math.pow(f7, 0.25);
            int j = p_361507_.getSkyColor(p_362477_.getPosition(), p_364035_);
            float f9 = ARGB.from8BitChannel(ARGB.red(j));
            float f11 = ARGB.from8BitChannel(ARGB.green(j));
            float f13 = ARGB.from8BitChannel(ARGB.blue(j));
            float f14 = Mth.clamp(Mth.cos(p_361507_.getTimeOfDay(p_364035_) * ((float)Math.PI * 2)) * 2.0f + 0.5f, 0.0f, 1.0f);
            BiomeManager biomemanager = p_361507_.getBiomeManager();
            Vec3 vec3 = p_362477_.getPosition().subtract(2.0, 2.0, 2.0).scale(0.25);
            Vec3 vec31 = CubicSampler.gaussianSampleVec3(vec3, (p_109033_, p_109034_, p_109035_) -> p_361507_.effects().getBrightnessDependentFogColor(Vec3.fromRGB24(biomemanager.getNoiseBiomeAtQuart(p_109033_, p_109034_, p_109035_).value().getFogColor()), f14));
            f = (float)vec31.x();
            f1 = (float)vec31.y();
            f2 = (float)vec31.z();
            if (p_361512_ >= 4) {
                float f15 = Mth.sin(p_361507_.getSunAngle(p_364035_)) > 0.0f ? -1.0f : 1.0f;
                Vector3f vector3f = new Vector3f(f15, 0.0f, 0.0f);
                float f19 = p_362477_.getLookVector().dot((Vector3fc)vector3f);
                if (f19 < 0.0f) {
                    f19 = 0.0f;
                }
                if (f19 > 0.0f && p_361507_.effects().isSunriseOrSunset(p_361507_.getTimeOfDay(p_364035_))) {
                    int j2 = p_361507_.effects().getSunriseOrSunsetColor(p_361507_.getTimeOfDay(p_364035_));
                    f = f * (1.0f - (f19 *= ARGB.from8BitChannel(ARGB.alpha(j2)))) + ARGB.from8BitChannel(ARGB.red(j2)) * f19;
                    f1 = f1 * (1.0f - f19) + ARGB.from8BitChannel(ARGB.green(j2)) * f19;
                    f2 = f2 * (1.0f - f19) + ARGB.from8BitChannel(ARGB.blue(j2)) * f19;
                }
            }
            f += (f9 - f) * f7;
            f1 += (f11 - f1) * f7;
            f2 += (f13 - f2) * f7;
            float f16 = p_361507_.getRainLevel(p_364035_);
            if (f16 > 0.0f) {
                float f17 = 1.0f - f16 * 0.5f;
                float f20 = 1.0f - f16 * 0.4f;
                f *= f17;
                f1 *= f17;
                f2 *= f20;
            }
            if ((f18 = p_361507_.getThunderLevel(p_364035_)) > 0.0f) {
                float f21 = 1.0f - f18 * 0.5f;
                f *= f21;
                f1 *= f21;
                f2 *= f21;
            }
            biomeChangedTime = -1L;
        }
        float f8 = ((float)p_362477_.getPosition().y - (float)p_361507_.getMinY()) * p_361507_.getLevelData().getClearColorScale();
        MobEffectFogFunction fogrenderer$mobeffectfogfunction = FogRenderer.getPriorityFogFunction(entity, p_364035_);
        if (fogrenderer$mobeffectfogfunction != null) {
            LivingEntity livingentity = (LivingEntity)entity;
            f8 = fogrenderer$mobeffectfogfunction.getModifiedVoidDarkness(livingentity, livingentity.getEffect(fogrenderer$mobeffectfogfunction.getMobEffect()), f8, p_364035_);
        }
        if (f8 < 1.0f && fogtype != FogType.LAVA && fogtype != FogType.POWDER_SNOW) {
            if (f8 < 0.0f) {
                f8 = 0.0f;
            }
            f8 *= f8;
            f *= f8;
            f1 *= f8;
            f2 *= f8;
        }
        if (p_367602_ > 0.0f) {
            f = f * (1.0f - p_367602_) + f * 0.7f * p_367602_;
            f1 = f1 * (1.0f - p_367602_) + f1 * 0.6f * p_367602_;
            f2 = f2 * (1.0f - p_367602_) + f2 * 0.6f * p_367602_;
        }
        float f10 = fogtype == FogType.WATER ? (entity instanceof LocalPlayer ? ((LocalPlayer)entity).getWaterVision() : 1.0f) : (entity instanceof LivingEntity && (livingentity1 = (LivingEntity)entity).hasEffect(MobEffects.NIGHT_VISION) && !livingentity1.hasEffect(MobEffects.DARKNESS) ? GameRenderer.getNightVisionScale(livingentity1, p_364035_) : 0.0f);
        if (f != 0.0f && f1 != 0.0f && f2 != 0.0f) {
            float f12 = Math.min(1.0f / f, Math.min(1.0f / f1, 1.0f / f2));
            f = f * (1.0f - f10) + f * f12 * f10;
            f1 = f1 * (1.0f - f10) + f1 * f12 * f10;
            f2 = f2 * (1.0f - f10) + f2 * f12 * f10;
        }
        Vector3f fogColor = ForgeHooksClient.getFogColor((Camera)p_362477_, (float)p_364035_, (ClientLevel)p_361507_, (int)p_361512_, (float)p_367602_, (float)f, (float)f1, (float)f2);
        f = fogColor.x();
        f1 = fogColor.y();
        f2 = fogColor.z();
        return new Vector4f(f, f1, f2, 1.0f);
    }

    public static boolean toggleFog() {
        fogEnabled = !fogEnabled;
        return fogEnabled;
    }

    @Nullable
    private static MobEffectFogFunction getPriorityFogFunction(Entity p_234166_, float p_234167_) {
        MobEffectFogFunction mobEffectFogFunction;
        if (p_234166_ instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)p_234166_;
            mobEffectFogFunction = MOB_EFFECT_FOG.stream().filter(p_234171_ -> p_234171_.isEnabled(livingentity, p_234167_)).findFirst().orElse(null);
        } else {
            mobEffectFogFunction = null;
        }
        return mobEffectFogFunction;
    }

    public static FogParameters setupFog(Camera p_234173_, FogMode p_234174_, Vector4f p_365589_, float p_234175_, boolean p_234176_, float p_234177_) {
        if (!fogEnabled) {
            return FogParameters.NO_FOG;
        }
        FogType fogtype = p_234173_.getFluidInCamera();
        Entity entity = p_234173_.getEntity();
        FogData fogrenderer$fogdata = new FogData(p_234174_);
        MobEffectFogFunction fogrenderer$mobeffectfogfunction = FogRenderer.getPriorityFogFunction(entity, p_234177_);
        if (fogtype == FogType.LAVA) {
            if (entity.isSpectator()) {
                fogrenderer$fogdata.start = -8.0f;
                fogrenderer$fogdata.end = p_234175_ * 0.5f;
            } else if (entity instanceof LivingEntity && ((LivingEntity)entity).hasEffect(MobEffects.FIRE_RESISTANCE)) {
                fogrenderer$fogdata.start = 0.0f;
                fogrenderer$fogdata.end = 5.0f;
            } else {
                fogrenderer$fogdata.start = 0.25f;
                fogrenderer$fogdata.end = 1.0f;
            }
        } else if (fogtype == FogType.POWDER_SNOW) {
            if (entity.isSpectator()) {
                fogrenderer$fogdata.start = -8.0f;
                fogrenderer$fogdata.end = p_234175_ * 0.5f;
            } else {
                fogrenderer$fogdata.start = 0.0f;
                fogrenderer$fogdata.end = 2.0f;
            }
        } else if (fogrenderer$mobeffectfogfunction != null) {
            LivingEntity livingentity = (LivingEntity)entity;
            MobEffectInstance mobeffectinstance = livingentity.getEffect(fogrenderer$mobeffectfogfunction.getMobEffect());
            if (mobeffectinstance != null) {
                fogrenderer$mobeffectfogfunction.setupFog(fogrenderer$fogdata, livingentity, mobeffectinstance, p_234175_, p_234177_);
            }
        } else if (fogtype == FogType.WATER) {
            fogrenderer$fogdata.start = -8.0f;
            fogrenderer$fogdata.end = 96.0f;
            if (entity instanceof LocalPlayer) {
                LocalPlayer localplayer = (LocalPlayer)entity;
                fogrenderer$fogdata.end *= Math.max(0.25f, localplayer.getWaterVision());
                Holder holder = localplayer.level().getBiome(localplayer.blockPosition());
                if (holder.is(BiomeTags.HAS_CLOSER_WATER_FOG)) {
                    fogrenderer$fogdata.end *= 0.85f;
                }
            }
            if (fogrenderer$fogdata.end > p_234175_) {
                fogrenderer$fogdata.end = p_234175_;
                fogrenderer$fogdata.shape = FogShape.CYLINDER;
            }
        } else if (p_234176_) {
            fogrenderer$fogdata.start = p_234175_ * 0.05f;
            fogrenderer$fogdata.end = Math.min(p_234175_, 192.0f) * 0.5f;
        } else if (p_234174_ == FogMode.FOG_SKY) {
            fogrenderer$fogdata.start = 0.0f;
            fogrenderer$fogdata.end = p_234175_;
            fogrenderer$fogdata.shape = FogShape.CYLINDER;
        } else if (p_234174_ == FogMode.FOG_TERRAIN) {
            float f = Mth.clamp(p_234175_ / 10.0f, 4.0f, 64.0f);
            fogrenderer$fogdata.start = p_234175_ - f;
            fogrenderer$fogdata.end = p_234175_;
            fogrenderer$fogdata.shape = FogShape.CYLINDER;
        }
        FogParameters original = new FogParameters(fogrenderer$fogdata.start, fogrenderer$fogdata.end, fogrenderer$fogdata.shape, p_365589_.x, p_365589_.y, p_365589_.z, p_365589_.w);
        return ForgeHooksClient.getFogParameters((FogMode)p_234174_, (FogType)fogtype, (Camera)p_234173_, (float)p_234177_, (float)p_234175_, (FogParameters)original);
    }

    @OnlyIn(value=Dist.CLIENT)
    static interface MobEffectFogFunction {
        public Holder<MobEffect> getMobEffect();

        public void setupFog(FogData var1, LivingEntity var2, MobEffectInstance var3, float var4, float var5);

        default public boolean isEnabled(LivingEntity p_234206_, float p_234207_) {
            return p_234206_.hasEffect(this.getMobEffect());
        }

        default public float getModifiedVoidDarkness(LivingEntity p_234208_, MobEffectInstance p_234209_, float p_234210_, float p_234211_) {
            MobEffectInstance mobeffectinstance = p_234208_.getEffect(this.getMobEffect());
            if (mobeffectinstance != null) {
                p_234210_ = mobeffectinstance.endsWithin(19) ? 1.0f - (float)mobeffectinstance.getDuration() / 20.0f : 0.0f;
            }
            return p_234210_;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class FogData {
        public final FogMode mode;
        public float start;
        public float end;
        public FogShape shape = FogShape.SPHERE;

        public FogData(FogMode p_234204_) {
            this.mode = p_234204_;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum FogMode {
        FOG_SKY,
        FOG_TERRAIN;

    }

    @OnlyIn(value=Dist.CLIENT)
    static class BlindnessFogFunction
    implements MobEffectFogFunction {
        BlindnessFogFunction() {
        }

        @Override
        public Holder<MobEffect> getMobEffect() {
            return MobEffects.BLINDNESS;
        }

        @Override
        public void setupFog(FogData p_234181_, LivingEntity p_234182_, MobEffectInstance p_234183_, float p_234184_, float p_234185_) {
            float f;
            float f2 = f = p_234183_.isInfiniteDuration() ? 5.0f : Mth.lerp(Math.min(1.0f, (float)p_234183_.getDuration() / 20.0f), p_234184_, 5.0f);
            if (p_234181_.mode == FogMode.FOG_SKY) {
                p_234181_.start = 0.0f;
                p_234181_.end = f * 0.8f;
            } else if (p_234181_.mode == FogMode.FOG_TERRAIN) {
                p_234181_.start = f * 0.25f;
                p_234181_.end = f;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class DarknessFogFunction
    implements MobEffectFogFunction {
        DarknessFogFunction() {
        }

        @Override
        public Holder<MobEffect> getMobEffect() {
            return MobEffects.DARKNESS;
        }

        @Override
        public void setupFog(FogData p_234194_, LivingEntity p_234195_, MobEffectInstance p_234196_, float p_234197_, float p_234198_) {
            float f = Mth.lerp(p_234196_.getBlendFactor(p_234195_, p_234198_), p_234197_, 15.0f);
            p_234194_.start = switch (p_234194_.mode.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> 0.0f;
                case 1 -> f * 0.75f;
            };
            p_234194_.end = f;
        }

        @Override
        public float getModifiedVoidDarkness(LivingEntity p_234189_, MobEffectInstance p_234190_, float p_234191_, float p_234192_) {
            return 1.0f - p_234190_.getBlendFactor(p_234189_, p_234192_);
        }
    }
}

