/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture.atlas;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.client.resources.metadata.animation.FrameSize;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceMetadata;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import org.slf4j.Logger;

@FunctionalInterface
@OnlyIn(value=Dist.CLIENT)
public interface SpriteResourceLoader {
    public static final Logger LOGGER = LogUtils.getLogger();

    public static SpriteResourceLoader create(Collection<MetadataSectionSerializer<?>> p_299052_) {
        return (p_296303_, p_296304_) -> {
            NativeImage nativeimage;
            ResourceMetadata resourcemetadata;
            try {
                resourcemetadata = p_296304_.metadata().copySections(p_299052_);
            }
            catch (Exception exception) {
                LOGGER.error("Unable to parse metadata from {}", (Object)p_296303_, (Object)exception);
                return null;
            }
            try (InputStream inputstream = p_296304_.open();){
                nativeimage = NativeImage.read((InputStream)inputstream);
            }
            catch (IOException ioexception) {
                LOGGER.error("Using missing texture, unable to load {}", (Object)p_296303_, (Object)ioexception);
                return null;
            }
            AnimationMetadataSection animationmetadatasection = resourcemetadata.getSection(AnimationMetadataSection.SERIALIZER).orElse(AnimationMetadataSection.EMPTY);
            FrameSize framesize = animationmetadatasection.calculateFrameSize(nativeimage.getWidth(), nativeimage.getHeight());
            if (Mth.isMultipleOf(nativeimage.getWidth(), framesize.width()) && Mth.isMultipleOf(nativeimage.getHeight(), framesize.height())) {
                SpriteContents contents = ForgeHooksClient.loadSpriteContents((ResourceLocation)p_296303_, (Resource)p_296304_, (FrameSize)framesize, (NativeImage)nativeimage, (ResourceMetadata)resourcemetadata);
                if (contents != null) {
                    return contents;
                }
                return new SpriteContents(p_296303_, framesize, nativeimage, resourcemetadata);
            }
            LOGGER.error("Image {} size {},{} is not multiple of frame size {},{}", new Object[]{p_296303_, nativeimage.getWidth(), nativeimage.getHeight(), framesize.width(), framesize.height()});
            nativeimage.close();
            return null;
        };
    }

    @Nullable
    public SpriteContents loadSprite(ResourceLocation var1, Resource var2);
}

