/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources.model;

import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.DelegateBakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.MultipartModelData;
import net.minecraftforge.common.util.ConcatenatedListView;

@OnlyIn(value=Dist.CLIENT)
public class MultiPartBakedModel
extends DelegateBakedModel {
    private final List<Selector> selectors;
    private final Map<BlockState, BitSet> selectorCache = new Reference2ObjectOpenHashMap();

    private static BakedModel getFirstModel(List<Selector> p_367507_) {
        if (p_367507_.isEmpty()) {
            throw new IllegalArgumentException("Model must have at least one selector");
        }
        return p_367507_.getFirst().model();
    }

    public MultiPartBakedModel(List<Selector> p_119462_) {
        super(MultiPartBakedModel.getFirstModel(p_119462_));
        this.selectors = p_119462_;
    }

    public BitSet getSelectors(@Nullable BlockState p_235050_) {
        BitSet bitset = this.selectorCache.get(p_235050_);
        if (bitset == null) {
            bitset = new BitSet();
            for (int i = 0; i < this.selectors.size(); ++i) {
                if (!this.selectors.get((int)i).condition.test(p_235050_)) continue;
                bitset.set(i);
            }
            this.selectorCache.put(p_235050_, bitset);
        }
        return bitset;
    }

    @Override
    public List<BakedQuad> getQuads(@Nullable BlockState p_235050_, @Nullable Direction p_235051_, RandomSource p_235052_, ModelData modelData, @Nullable RenderType renderType) {
        if (p_235050_ == null) {
            return Collections.emptyList();
        }
        BitSet bitset = this.getSelectors(p_235050_);
        ArrayList list = new ArrayList();
        long j = p_235052_.nextLong();
        for (int k = 0; k < bitset.length(); ++k) {
            if (!bitset.get(k)) continue;
            p_235052_.setSeed(j);
            BakedModel model = this.selectors.get(k).model();
            if (renderType != null && !model.getRenderTypes(p_235050_, p_235052_, modelData).contains(renderType)) continue;
            ModelData data = MultipartModelData.resolve((ModelData)modelData, (BakedModel)model);
            list.addAll(model.getQuads(p_235050_, p_235051_, p_235052_, data, renderType));
        }
        return ConcatenatedListView.of((List[])new List[]{list});
    }

    public ChunkRenderTypeSet getRenderTypes(BlockState state, RandomSource rand, ModelData data) {
        LinkedList<ChunkRenderTypeSet> renderTypeSets = new LinkedList<ChunkRenderTypeSet>();
        BitSet selectors = this.getSelectors(state);
        for (int i = 0; i < selectors.length(); ++i) {
            if (!selectors.get(i)) continue;
            renderTypeSets.add(this.selectors.get(i).model().getRenderTypes(state, rand, data));
        }
        return ChunkRenderTypeSet.union(renderTypeSets);
    }

    @OnlyIn(value=Dist.CLIENT)
    public record Selector(Predicate<BlockState> condition, BakedModel model) {
    }
}

