/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.models;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.models.BlockModelGenerators;
import net.minecraft.data.models.ItemModelGenerators;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.data.models.model.DelegatedModel;
import net.minecraft.data.models.model.ModelLocationUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class ModelProvider
implements DataProvider {
    private final PackOutput.PathProvider blockStatePathProvider;
    private final PackOutput.PathProvider modelPathProvider;

    public ModelProvider(PackOutput $$0) {
        this.blockStatePathProvider = $$0.createPathProvider(PackOutput.Target.RESOURCE_PACK, "blockstates");
        this.modelPathProvider = $$0.createPathProvider(PackOutput.Target.RESOURCE_PACK, "models");
    }

    @Override
    public CompletableFuture<?> run(CachedOutput $$02) {
        HashMap $$12 = Maps.newHashMap();
        Consumer<BlockStateGenerator> $$22 = $$1 -> {
            Block $$2 = $$1.getBlock();
            BlockStateGenerator $$3 = $$12.put($$2, $$1);
            if ($$3 != null) {
                throw new IllegalStateException("Duplicate blockstate definition for " + String.valueOf($$2));
            }
        };
        HashMap $$3 = Maps.newHashMap();
        HashSet $$4 = Sets.newHashSet();
        BiConsumer<ResourceLocation, Supplier<JsonElement>> $$5 = ($$1, $$2) -> {
            Supplier $$3 = $$3.put($$1, $$2);
            if ($$3 != null) {
                throw new IllegalStateException("Duplicate model definition for " + String.valueOf($$1));
            }
        };
        Consumer<Item> $$6 = $$4::add;
        new BlockModelGenerators($$22, $$5, $$6).run();
        new ItemModelGenerators($$5).run();
        List<Block> $$7 = BuiltInRegistries.BLOCK.entrySet().stream().filter($$0 -> true).map(Map.Entry::getValue).filter($$1 -> !$$12.containsKey($$1)).toList();
        if (!$$7.isEmpty()) {
            throw new IllegalStateException("Missing blockstate definitions for: " + String.valueOf($$7));
        }
        BuiltInRegistries.BLOCK.forEach($$2 -> {
            Item $$3 = Item.BY_BLOCK.get($$2);
            if ($$3 != null) {
                if ($$4.contains($$3)) {
                    return;
                }
                ResourceLocation $$4 = ModelLocationUtils.getModelLocation($$3);
                if (!$$3.containsKey($$4)) {
                    $$3.put($$4, new DelegatedModel(ModelLocationUtils.getModelLocation($$2)));
                }
            }
        });
        CompletableFuture[] completableFutureArray = new CompletableFuture[2];
        completableFutureArray[0] = this.saveCollection($$02, $$12, $$0 -> this.blockStatePathProvider.json($$0.builtInRegistryHolder().key().location()));
        completableFutureArray[1] = this.saveCollection($$02, $$3, this.modelPathProvider::json);
        return CompletableFuture.allOf(completableFutureArray);
    }

    private <T> CompletableFuture<?> saveCollection(CachedOutput $$0, Map<T, ? extends Supplier<JsonElement>> $$1, Function<T, Path> $$22) {
        return CompletableFuture.allOf((CompletableFuture[])$$1.entrySet().stream().map($$2 -> {
            Path $$3 = (Path)$$22.apply($$2.getKey());
            JsonElement $$4 = (JsonElement)((Supplier)$$2.getValue()).get();
            return DataProvider.saveStable($$0, $$4, $$3);
        }).toArray(CompletableFuture[]::new));
    }

    @Override
    public final String getName() {
        return "Model Definitions";
    }
}

