/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistrySynchronization;
import net.minecraft.core.WritableRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.ChatType;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.repository.KnownPack;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.tags.TagLoader;
import net.minecraft.tags.TagNetworkSerialization;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.animal.WolfVariant;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.item.Instrument;
import net.minecraft.world.item.JukeboxSong;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.providers.EnchantmentProvider;
import net.minecraft.world.item.equipment.trim.TrimMaterial;
import net.minecraft.world.item.equipment.trim.TrimPattern;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterList;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerConfig;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.flat.FlatLevelGeneratorPreset;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.minecraftforge.common.crafting.conditions.ConditionCodec;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.registries.DataPackRegistriesHooks;
import org.slf4j.Logger;

public class RegistryDataLoader {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Comparator<ResourceKey<?>> ERROR_KEY_COMPARATOR = Comparator.comparing(ResourceKey::registry).thenComparing(ResourceKey::location);
    private static final RegistrationInfo NETWORK_REGISTRATION_INFO = new RegistrationInfo(Optional.empty(), Lifecycle.experimental());
    private static final Function<Optional<KnownPack>, RegistrationInfo> REGISTRATION_INFO_CACHE = Util.memoize(p_326161_ -> {
        Lifecycle lifecycle = p_326161_.map(KnownPack::isVanilla).map(p_326166_ -> Lifecycle.stable()).orElse(Lifecycle.experimental());
        return new RegistrationInfo((Optional<KnownPack>)p_326161_, lifecycle);
    });
    public static final List<RegistryData<?>> WORLDGEN_REGISTRIES = DataPackRegistriesHooks.grabWorldgenRegistries((RegistryData[])new RegistryData[]{new RegistryData<DimensionType>(Registries.DIMENSION_TYPE, DimensionType.DIRECT_CODEC), new RegistryData<Biome>(Registries.BIOME, Biome.DIRECT_CODEC), new RegistryData<ChatType>(Registries.CHAT_TYPE, ChatType.DIRECT_CODEC), new RegistryData(Registries.CONFIGURED_CARVER, ConfiguredWorldCarver.DIRECT_CODEC), new RegistryData(Registries.CONFIGURED_FEATURE, ConfiguredFeature.DIRECT_CODEC), new RegistryData<PlacedFeature>(Registries.PLACED_FEATURE, PlacedFeature.DIRECT_CODEC), new RegistryData<Structure>(Registries.STRUCTURE, Structure.DIRECT_CODEC), new RegistryData<StructureSet>(Registries.STRUCTURE_SET, StructureSet.DIRECT_CODEC), new RegistryData<StructureProcessorList>(Registries.PROCESSOR_LIST, StructureProcessorType.DIRECT_CODEC), new RegistryData<StructureTemplatePool>(Registries.TEMPLATE_POOL, StructureTemplatePool.DIRECT_CODEC), new RegistryData<NoiseGeneratorSettings>(Registries.NOISE_SETTINGS, NoiseGeneratorSettings.DIRECT_CODEC), new RegistryData<NormalNoise.NoiseParameters>(Registries.NOISE, NormalNoise.NoiseParameters.DIRECT_CODEC), new RegistryData<DensityFunction>(Registries.DENSITY_FUNCTION, DensityFunction.DIRECT_CODEC), new RegistryData<WorldPreset>(Registries.WORLD_PRESET, WorldPreset.DIRECT_CODEC), new RegistryData<FlatLevelGeneratorPreset>(Registries.FLAT_LEVEL_GENERATOR_PRESET, FlatLevelGeneratorPreset.DIRECT_CODEC), new RegistryData<TrimPattern>(Registries.TRIM_PATTERN, TrimPattern.DIRECT_CODEC), new RegistryData<TrimMaterial>(Registries.TRIM_MATERIAL, TrimMaterial.DIRECT_CODEC), new RegistryData<TrialSpawnerConfig>(Registries.TRIAL_SPAWNER_CONFIG, TrialSpawnerConfig.DIRECT_CODEC), new RegistryData<WolfVariant>(Registries.WOLF_VARIANT, WolfVariant.DIRECT_CODEC, true), new RegistryData<PaintingVariant>(Registries.PAINTING_VARIANT, PaintingVariant.DIRECT_CODEC, true), new RegistryData<DamageType>(Registries.DAMAGE_TYPE, DamageType.DIRECT_CODEC), new RegistryData<MultiNoiseBiomeSourceParameterList>(Registries.MULTI_NOISE_BIOME_SOURCE_PARAMETER_LIST, MultiNoiseBiomeSourceParameterList.DIRECT_CODEC), new RegistryData<BannerPattern>(Registries.BANNER_PATTERN, BannerPattern.DIRECT_CODEC), new RegistryData<Enchantment>(Registries.ENCHANTMENT, Enchantment.DIRECT_CODEC), new RegistryData<EnchantmentProvider>(Registries.ENCHANTMENT_PROVIDER, EnchantmentProvider.DIRECT_CODEC), new RegistryData<JukeboxSong>(Registries.JUKEBOX_SONG, JukeboxSong.DIRECT_CODEC), new RegistryData<Instrument>(Registries.INSTRUMENT, Instrument.DIRECT_CODEC)});
    public static final List<RegistryData<?>> DIMENSION_REGISTRIES = List.of(new RegistryData<LevelStem>(Registries.LEVEL_STEM, LevelStem.CODEC));
    public static final List<RegistryData<?>> SYNCHRONIZED_REGISTRIES = DataPackRegistriesHooks.grabSynchronizedRegistries((RegistryData[])new RegistryData[]{new RegistryData<Biome>(Registries.BIOME, Biome.NETWORK_CODEC), new RegistryData<ChatType>(Registries.CHAT_TYPE, ChatType.DIRECT_CODEC), new RegistryData<TrimPattern>(Registries.TRIM_PATTERN, TrimPattern.DIRECT_CODEC), new RegistryData<TrimMaterial>(Registries.TRIM_MATERIAL, TrimMaterial.DIRECT_CODEC), new RegistryData<WolfVariant>(Registries.WOLF_VARIANT, WolfVariant.DIRECT_CODEC, true), new RegistryData<PaintingVariant>(Registries.PAINTING_VARIANT, PaintingVariant.DIRECT_CODEC, true), new RegistryData<DimensionType>(Registries.DIMENSION_TYPE, DimensionType.DIRECT_CODEC), new RegistryData<DamageType>(Registries.DAMAGE_TYPE, DamageType.DIRECT_CODEC), new RegistryData<BannerPattern>(Registries.BANNER_PATTERN, BannerPattern.DIRECT_CODEC), new RegistryData<Enchantment>(Registries.ENCHANTMENT, Enchantment.DIRECT_CODEC), new RegistryData<JukeboxSong>(Registries.JUKEBOX_SONG, JukeboxSong.DIRECT_CODEC), new RegistryData<Instrument>(Registries.INSTRUMENT, Instrument.DIRECT_CODEC)});

    public static Stream<RegistryData<?>> getWorldGenAndDimensionStream() {
        return Stream.concat(WORLDGEN_REGISTRIES.stream(), DIMENSION_REGISTRIES.stream());
    }

    public static RegistryAccess.Frozen load(ResourceManager p_252046_, List<HolderLookup.RegistryLookup<?>> p_250344_, List<RegistryData<?>> p_366741_) {
        return RegistryDataLoader.load((Loader<?> p_326156_, RegistryOps.RegistryInfoLookup p_326157_) -> p_326156_.loadFromResources(p_252046_, p_326157_), p_250344_, p_366741_);
    }

    public static RegistryAccess.Frozen load(Map<ResourceKey<? extends Registry<?>>, NetworkedRegistryData> p_328212_, ResourceProvider p_335625_, List<HolderLookup.RegistryLookup<?>> p_329346_, List<RegistryData<?>> p_362679_) {
        return RegistryDataLoader.load((Loader<?> p_326153_, RegistryOps.RegistryInfoLookup p_326154_) -> p_326153_.loadFromNetwork(p_328212_, p_335625_, p_326154_), p_329346_, p_362679_);
    }

    private static RegistryAccess.Frozen load(LoadingFunction p_332256_, List<HolderLookup.RegistryLookup<?>> p_333463_, List<RegistryData<?>> p_368458_) {
        HashMap map = new HashMap();
        List<Loader<?>> list = p_368458_.stream().map(p_326168_ -> p_326168_.create(Lifecycle.stable(), map)).collect(Collectors.toUnmodifiableList());
        RegistryOps.RegistryInfoLookup registryops$registryinfolookup = RegistryDataLoader.createContext(p_333463_, list);
        list.forEach(p_326160_ -> p_332256_.apply((Loader<?>)p_326160_, registryops$registryinfolookup));
        list.forEach(p_358491_ -> {
            WritableRegistry registry = p_358491_.registry();
            try {
                registry.freeze();
            }
            catch (Exception exception) {
                map.put(registry.key(), exception);
            }
            if (p_358491_.data.requiredNonEmpty && registry.size() == 0) {
                map.put(registry.key(), new IllegalStateException("Registry must be non-empty"));
            }
        });
        if (!map.isEmpty()) {
            throw RegistryDataLoader.logErrors(map);
        }
        return new RegistryAccess.ImmutableRegistryAccess(list.stream().map(Loader::registry).toList()).freeze();
    }

    private static RegistryOps.RegistryInfoLookup createContext(List<HolderLookup.RegistryLookup<?>> p_255821_, List<Loader<?>> p_365131_) {
        final HashMap map = new HashMap();
        p_255821_.forEach(p_358498_ -> map.put(p_358498_.key(), RegistryDataLoader.createInfoForContextRegistry(p_358498_)));
        p_365131_.forEach(p_358493_ -> map.put(p_358493_.registry.key(), RegistryDataLoader.createInfoForNewRegistry(p_358493_.registry)));
        return new RegistryOps.RegistryInfoLookup(){

            @Override
            public <T> Optional<RegistryOps.RegistryInfo<T>> lookup(ResourceKey<? extends Registry<? extends T>> p_256014_) {
                return Optional.ofNullable((RegistryOps.RegistryInfo)map.get(p_256014_));
            }
        };
    }

    private static <T> RegistryOps.RegistryInfo<T> createInfoForNewRegistry(WritableRegistry<T> p_256020_) {
        return new RegistryOps.RegistryInfo<T>(p_256020_, p_256020_.createRegistrationLookup(), p_256020_.registryLifecycle());
    }

    private static <T> RegistryOps.RegistryInfo<T> createInfoForContextRegistry(HolderLookup.RegistryLookup<T> p_367102_) {
        return new RegistryOps.RegistryInfo<T>(p_367102_, p_367102_, p_367102_.registryLifecycle());
    }

    private static ReportedException logErrors(Map<ResourceKey<?>, Exception> p_361753_) {
        RegistryDataLoader.printFullDetailsToLog(p_361753_);
        return RegistryDataLoader.createReportWithBriefInfo(p_361753_);
    }

    private static void printFullDetailsToLog(Map<ResourceKey<?>, Exception> p_252325_) {
        StringWriter stringwriter = new StringWriter();
        PrintWriter printwriter = new PrintWriter(stringwriter);
        Map<ResourceLocation, Map<ResourceLocation, Exception>> map = p_252325_.entrySet().stream().collect(Collectors.groupingBy(p_249353_ -> ((ResourceKey)p_249353_.getKey()).registry(), Collectors.toMap(p_251444_ -> ((ResourceKey)p_251444_.getKey()).location(), Map.Entry::getValue)));
        map.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(p_249838_ -> {
            printwriter.printf("> Errors in registry %s:%n", p_249838_.getKey());
            ((Map)p_249838_.getValue()).entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(p_250688_ -> {
                printwriter.printf(">> Errors in element %s:%n", p_250688_.getKey());
                ((Exception)p_250688_.getValue()).printStackTrace(printwriter);
            });
        });
        printwriter.flush();
        LOGGER.error("Registry loading errors:\n{}", (Object)stringwriter);
    }

    private static ReportedException createReportWithBriefInfo(Map<ResourceKey<?>, Exception> p_368267_) {
        CrashReport crashreport = CrashReport.forThrowable(new IllegalStateException("Failed to load registries due to errors"), "Registry Loading");
        CrashReportCategory crashreportcategory = crashreport.addCategory("Loading info");
        crashreportcategory.setDetail("Errors", () -> {
            StringBuilder stringbuilder = new StringBuilder();
            p_368267_.entrySet().stream().sorted(Map.Entry.comparingByKey(ERROR_KEY_COMPARATOR)).forEach(p_358496_ -> stringbuilder.append("\n\t\t").append(((ResourceKey)p_358496_.getKey()).registry()).append("/").append(((ResourceKey)p_358496_.getKey()).location()).append(": ").append(((Exception)p_358496_.getValue()).getMessage()));
            return stringbuilder.toString();
        });
        return new ReportedException(crashreport);
    }

    private static <E> void loadElementFromResource(WritableRegistry<E> p_330991_, Decoder<Optional<E>> p_333909_, RegistryOps<JsonElement> p_332135_, ResourceKey<E> p_332850_, Resource p_335244_, RegistrationInfo p_332222_) throws IOException {
        try (BufferedReader reader = p_335244_.openAsReader();){
            JsonElement jsonelement = JsonParser.parseReader((Reader)reader);
            DataResult result = p_333909_.decode(p_332135_, (Object)jsonelement);
            if (result.isError()) {
                LOGGER.error("Couldn't parse data file {}: {}", p_332850_, (Object)((DataResult.Error)result.error().get()).message());
                throw new IllegalStateException("Couldn't parse data file " + String.valueOf(p_332850_) + ": " + ((DataResult.Error)result.error().get()).message());
            }
            Optional<Optional> mappedResult = result.result().map(a -> (Optional)a.getFirst());
            if (mappedResult.get().isEmpty()) {
                LOGGER.debug("Skipping {} conditions not met", p_332850_);
                return;
            }
            DataResult dataresult = result.map(p -> p.mapFirst(Optional::get)).map(p -> p.getFirst());
            Object e = dataresult.getOrThrow();
            p_330991_.register(p_332850_, e, p_332222_);
        }
    }

    static <E> void loadContentsFromManager(ResourceManager p_335634_, RegistryOps.RegistryInfoLookup p_333035_, WritableRegistry<E> p_331358_, Decoder<E> p_329404_, Map<ResourceKey<?>, Exception> p_335074_) {
        String s = Registries.elementsDirPath(p_331358_.key());
        FileToIdConverter filetoidconverter = FileToIdConverter.json(s);
        RegistryOps<JsonElement> registryops = RegistryOps.create(JsonOps.INSTANCE, p_333035_);
        Decoder conditional = ConditionCodec.wrap(p_329404_);
        for (Map.Entry<ResourceLocation, Resource> entry : filetoidconverter.listMatchingResources(p_335634_).entrySet()) {
            ResourceLocation resourcelocation = entry.getKey();
            ResourceKey resourcekey = ResourceKey.create(p_331358_.key(), filetoidconverter.fileToId(resourcelocation));
            Resource resource = entry.getValue();
            RegistrationInfo registrationinfo = REGISTRATION_INFO_CACHE.apply(resource.knownPackInfo());
            try {
                RegistryDataLoader.loadElementFromResource(p_331358_, conditional, registryops, resourcekey, resource, registrationinfo);
            }
            catch (Exception exception) {
                p_335074_.put(resourcekey, new IllegalStateException(String.format(Locale.ROOT, "Failed to parse %s from pack %s", resourcelocation, resource.sourcePackId()), exception));
            }
        }
        TagLoader.loadTagsForRegistry(p_335634_, p_331358_);
    }

    static <E> void loadContentsFromNetwork(Map<ResourceKey<? extends Registry<?>>, NetworkedRegistryData> p_331925_, ResourceProvider p_332010_, RegistryOps.RegistryInfoLookup p_329253_, WritableRegistry<E> p_332518_, Decoder<E> p_328898_, Map<ResourceKey<?>, Exception> p_335768_) {
        NetworkedRegistryData registrydataloader$networkedregistrydata = p_331925_.get(p_332518_.key());
        if (registrydataloader$networkedregistrydata != null) {
            RegistryOps<Tag> registryops = RegistryOps.create(NbtOps.INSTANCE, p_329253_);
            RegistryOps registryops1 = (RegistryOps)RegistryOps.create(JsonOps.INSTANCE, p_329253_).withContext(ICondition.IContext.KEY, ICondition.IContext.TAGS_INVALID);
            Decoder conditional = ConditionCodec.wrap(p_328898_);
            String s = Registries.elementsDirPath(p_332518_.key());
            FileToIdConverter filetoidconverter = FileToIdConverter.json(s);
            for (RegistrySynchronization.PackedRegistryEntry registrysynchronization$packedregistryentry : registrydataloader$networkedregistrydata.elements) {
                ResourceKey resourcekey = ResourceKey.create(p_332518_.key(), registrysynchronization$packedregistryentry.id());
                Optional<Tag> optional = registrysynchronization$packedregistryentry.data();
                if (optional.isPresent()) {
                    try {
                        DataResult dataresult = p_328898_.parse(registryops, (Object)optional.get());
                        Object e = dataresult.getOrThrow();
                        p_332518_.register(resourcekey, e, NETWORK_REGISTRATION_INFO);
                    }
                    catch (Exception exception) {
                        p_335768_.put(resourcekey, new IllegalStateException(String.format(Locale.ROOT, "Failed to parse value %s from server", optional.get()), exception));
                    }
                    continue;
                }
                ResourceLocation resourcelocation = filetoidconverter.idToFile(registrysynchronization$packedregistryentry.id());
                try {
                    Resource resource = p_332010_.getResourceOrThrow(resourcelocation);
                    RegistryDataLoader.loadElementFromResource(p_332518_, conditional, registryops1, resourcekey, resource, NETWORK_REGISTRATION_INFO);
                }
                catch (Exception exception1) {
                    p_335768_.put(resourcekey, new IllegalStateException("Failed to parse local data", exception1));
                }
            }
            TagLoader.loadTagsFromNetwork(registrydataloader$networkedregistrydata.tags, p_332518_);
        }
    }

    @FunctionalInterface
    static interface LoadingFunction {
        public void apply(Loader<?> var1, RegistryOps.RegistryInfoLookup var2);
    }

    public record NetworkedRegistryData(List<RegistrySynchronization.PackedRegistryEntry> elements, TagNetworkSerialization.NetworkPayload tags) {
    }

    record Loader<T>(RegistryData<T> data, WritableRegistry<T> registry, Map<ResourceKey<?>, Exception> loadingErrors) {
        public void loadFromResources(ResourceManager p_328137_, RegistryOps.RegistryInfoLookup p_330371_) {
            RegistryDataLoader.loadContentsFromManager(p_328137_, p_330371_, this.registry, this.data.elementCodec, this.loadingErrors);
        }

        public void loadFromNetwork(Map<ResourceKey<? extends Registry<?>>, NetworkedRegistryData> p_333047_, ResourceProvider p_333682_, RegistryOps.RegistryInfoLookup p_330665_) {
            RegistryDataLoader.loadContentsFromNetwork(p_333047_, p_333682_, p_330665_, this.registry, this.data.elementCodec, this.loadingErrors);
        }
    }

    public record RegistryData<T>(ResourceKey<? extends Registry<T>> key, Codec<T> elementCodec, boolean requiredNonEmpty) {
        RegistryData(ResourceKey<? extends Registry<T>> p_251360_, Codec<T> p_248976_) {
            this(p_251360_, p_248976_, false);
        }

        Loader<T> create(Lifecycle p_251662_, Map<ResourceKey<?>, Exception> p_251565_) {
            MappedRegistry writableregistry = new MappedRegistry(this.key, p_251662_);
            return new Loader(this, writableregistry, p_251565_);
        }

        public void runWithArguments(BiConsumer<ResourceKey<? extends Registry<T>>, Codec<T>> p_310351_) {
            p_310351_.accept(this.key, this.elementCodec);
        }
    }
}

