/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.equipment;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.StringRepresentable;

public record EquipmentModel(Map<LayerType, List<Layer>> layers) {
    private static final Codec<List<Layer>> LAYER_LIST_CODEC = ExtraCodecs.nonEmptyList(Layer.CODEC.listOf());
    public static final Codec<EquipmentModel> CODEC = RecordCodecBuilder.create($$0 -> $$0.group((App)ExtraCodecs.nonEmptyMap(Codec.unboundedMap(LayerType.CODEC, LAYER_LIST_CODEC)).fieldOf("layers").forGetter(EquipmentModel::layers)).apply((Applicative)$$0, EquipmentModel::new));

    public static Builder builder() {
        return new Builder();
    }

    public List<Layer> getLayers(LayerType $$0) {
        return this.layers.getOrDefault($$0, List.of());
    }

    public static class Builder {
        private final Map<LayerType, List<Layer>> layersByType = new EnumMap<LayerType, List<Layer>>(LayerType.class);

        Builder() {
        }

        public Builder addHumanoidLayers(ResourceLocation $$0) {
            return this.addHumanoidLayers($$0, false);
        }

        public Builder addHumanoidLayers(ResourceLocation $$0, boolean $$1) {
            this.addLayers(LayerType.HUMANOID_LEGGINGS, Layer.leatherDyeable($$0, $$1));
            this.addMainHumanoidLayer($$0, $$1);
            return this;
        }

        public Builder addMainHumanoidLayer(ResourceLocation $$0, boolean $$1) {
            return this.addLayers(LayerType.HUMANOID, Layer.leatherDyeable($$0, $$1));
        }

        public Builder addLayers(LayerType $$02, Layer ... $$1) {
            Collections.addAll(this.layersByType.computeIfAbsent($$02, $$0 -> new ArrayList()), $$1);
            return this;
        }

        public EquipmentModel build() {
            return new EquipmentModel((Map)this.layersByType.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, $$0 -> List.copyOf((Collection)$$0.getValue()))));
        }
    }

    public static enum LayerType implements StringRepresentable
    {
        HUMANOID("humanoid"),
        HUMANOID_LEGGINGS("humanoid_leggings"),
        WINGS("wings"),
        WOLF_BODY("wolf_body"),
        HORSE_BODY("horse_body"),
        LLAMA_BODY("llama_body");

        public static final Codec<LayerType> CODEC;
        private final String id;

        private LayerType(String $$0) {
            this.id = $$0;
        }

        @Override
        public String getSerializedName() {
            return this.id;
        }

        static {
            CODEC = StringRepresentable.fromEnum(LayerType::values);
        }
    }

    public record Layer(ResourceLocation textureId, Optional<Dyeable> dyeable, boolean usePlayerTexture) {
        public static final Codec<Layer> CODEC = RecordCodecBuilder.create($$0 -> $$0.group((App)ResourceLocation.CODEC.fieldOf("texture").forGetter(Layer::textureId), (App)Dyeable.CODEC.optionalFieldOf("dyeable").forGetter(Layer::dyeable), (App)Codec.BOOL.optionalFieldOf("use_player_texture", (Object)false).forGetter(Layer::usePlayerTexture)).apply((Applicative)$$0, Layer::new));

        public Layer(ResourceLocation $$0) {
            this($$0, Optional.empty(), false);
        }

        public static Layer leatherDyeable(ResourceLocation $$0, boolean $$1) {
            return new Layer($$0, $$1 ? Optional.of(new Dyeable(Optional.of(-6265536))) : Optional.empty(), false);
        }

        public static Layer onlyIfDyed(ResourceLocation $$0, boolean $$1) {
            return new Layer($$0, $$1 ? Optional.of(new Dyeable(Optional.empty())) : Optional.empty(), false);
        }

        public ResourceLocation getTextureLocation(LayerType $$0) {
            return this.textureId.withPath($$1 -> "textures/entity/equipment/" + $$0.getSerializedName() + "/" + $$1 + ".png");
        }
    }

    public record Dyeable(Optional<Integer> colorWhenUndyed) {
        public static final Codec<Dyeable> CODEC = RecordCodecBuilder.create($$0 -> $$0.group((App)ExtraCodecs.RGB_COLOR_CODEC.optionalFieldOf("color_when_undyed").forGetter(Dyeable::colorWhenUndyed)).apply((Applicative)$$0, Dyeable::new));
    }
}

