/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.treedecorators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.features.VegetationFeatures;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HangingMossBlock;
import net.minecraft.world.level.block.MossyCarpetBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;

public class PaleMossDecorator
extends TreeDecorator {
    public static final MapCodec<PaleMossDecorator> CODEC = RecordCodecBuilder.mapCodec($$02 -> $$02.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("leaves_probability").forGetter($$0 -> Float.valueOf($$0.leavesProbability)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("trunk_probability").forGetter($$0 -> Float.valueOf($$0.trunkProbability)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("ground_probability").forGetter($$0 -> Float.valueOf($$0.groundProbability))).apply((Applicative)$$02, PaleMossDecorator::new));
    private final float leavesProbability;
    private final float trunkProbability;
    private final float groundProbability;

    @Override
    protected TreeDecoratorType<?> type() {
        return TreeDecoratorType.PALE_MOSS;
    }

    public PaleMossDecorator(float $$0, float $$1, float $$2) {
        this.leavesProbability = $$0;
        this.trunkProbability = $$1;
        this.groundProbability = $$2;
    }

    @Override
    public void place(TreeDecorator.Context $$02) {
        RandomSource $$1 = $$02.random();
        WorldGenLevel $$22 = (WorldGenLevel)$$02.level();
        List<BlockPos> $$32 = Util.shuffledCopy($$02.logs(), $$1);
        if ($$32.isEmpty()) {
            return;
        }
        MutableObject $$4 = new MutableObject((Object)$$32.getFirst());
        $$32.forEach(arg_0 -> PaleMossDecorator.lambda$place$4((Mutable)$$4, arg_0));
        BlockPos $$5 = (BlockPos)$$4.getValue();
        if ($$1.nextFloat() < this.groundProbability) {
            $$22.registryAccess().lookup(Registries.CONFIGURED_FEATURE).flatMap($$0 -> $$0.get(VegetationFeatures.PALE_MOSS_PATCH_BONEMEAL)).ifPresent($$3 -> ((ConfiguredFeature)$$3.value()).place($$22, $$22.getLevel().getChunkSource().getGenerator(), $$1, $$5.above()));
        }
        $$02.logs().forEach($$2 -> {
            BlockPos $$4;
            BlockPos $$3;
            if ($$1.nextFloat() < this.trunkProbability && $$02.isAir($$3 = $$2.below())) {
                PaleMossDecorator.addMossHanger($$3, $$02);
            }
            if ($$1.nextFloat() < this.trunkProbability && $$02.isAir($$4 = $$2.above())) {
                MossyCarpetBlock.placeAt((WorldGenLevel)$$02.level(), $$4, $$02.random(), 3);
            }
        });
        $$02.leaves().forEach($$2 -> {
            BlockPos $$3;
            if ($$1.nextFloat() < this.leavesProbability && $$02.isAir($$3 = $$2.below())) {
                PaleMossDecorator.addMossHanger($$3, $$02);
            }
        });
    }

    private static void addMossHanger(BlockPos $$0, TreeDecorator.Context $$1) {
        while ($$1.isAir($$0.below()) && !((double)$$1.random().nextFloat() < 0.5)) {
            $$1.setBlock($$0, (BlockState)Blocks.PALE_HANGING_MOSS.defaultBlockState().setValue(HangingMossBlock.TIP, false));
            $$0 = $$0.below();
        }
        $$1.setBlock($$0, (BlockState)Blocks.PALE_HANGING_MOSS.defaultBlockState().setValue(HangingMossBlock.TIP, true));
    }

    private static /* synthetic */ void lambda$place$4(Mutable $$0, BlockPos $$1) {
        if ($$1.getY() < ((BlockPos)$$0.getValue()).getY()) {
            $$0.setValue((Object)$$1);
        }
    }
}

