/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.IModLoadingState;
import net.minecraftforge.fml.IModStateTransition;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingPhase;
import net.minecraftforge.fml.loading.progress.ProgressMeter;

public record ModLoadingState(String name, String previous, Function<ModList, String> message, ToIntFunction<ModList> size, ModLoadingPhase phase, Optional<Consumer<ModList>> inlineRunnable, Optional<IModStateTransition> transition) implements IModLoadingState
{
    @Override
    public <T extends Event> Optional<CompletableFuture<Void>> buildTransition(Executor syncExecutor, Executor parallelExecutor, ProgressMeter progressBar, Function<Executor, CompletableFuture<Void>> preSyncTask, Function<Executor, CompletableFuture<Void>> postSyncTask) {
        IModStateTransition transition = this.transition.orElse(null);
        return transition == null ? Optional.empty() : Optional.ofNullable(transition.build(this.name, syncExecutor, parallelExecutor, progressBar, preSyncTask, postSyncTask));
    }

    @Deprecated(since="1.21.3", forRemoval=true)
    public static ModLoadingState empty(String name, String previous, ModLoadingPhase phase) {
        return ModLoadingState.of(name, phase).after(previous).empty();
    }

    @Deprecated(since="1.21.3", forRemoval=true)
    public static ModLoadingState withTransition(String name, String previous, ModLoadingPhase phase, IModStateTransition transition) {
        return ModLoadingState.of(name, phase).after(previous).withTransition(transition);
    }

    @Deprecated(since="1.21.3", forRemoval=true)
    public static ModLoadingState withTransition(String name, String previous, Function<ModList, String> message, ModLoadingPhase phase, IModStateTransition transition) {
        return ModLoadingState.of(name, phase).after(previous).message(message).withTransition(transition);
    }

    @Deprecated(since="1.21.3", forRemoval=true)
    public static ModLoadingState withInline(String name, String previous, ModLoadingPhase phase, Consumer<ModList> inline) {
        return ModLoadingState.of(name, phase).after(previous).withInline(inline);
    }

    public static Builder of(String name, ModLoadingPhase phase) {
        return new Builder(name, phase);
    }

    public static class Builder {
        private final String name;
        private final ModLoadingPhase phase;
        private String after;
        private Function<ModList, String> message = null;
        private ToIntFunction<ModList> size = null;

        private Builder(String name, ModLoadingPhase phase) {
            this.name = name;
            this.phase = phase;
        }

        public Builder after(ModLoadingState value) {
            return this.after(value.name());
        }

        public Builder after(String value) {
            this.after = value;
            return this;
        }

        public Builder message(String value) {
            return this.message((ModList ml) -> value);
        }

        public Builder message(Function<ModList, String> value) {
            this.message = value;
            return this;
        }

        public Builder size(int value) {
            return this.size(ml -> value);
        }

        public Builder size(ToIntFunction<ModList> value) {
            this.size = value;
            return this;
        }

        public ModLoadingState empty() {
            return new ModLoadingState(this.name, this.after, this.message != null ? this.message : ml -> "", this.size != null ? this.size : ml -> 0, this.phase, Optional.empty(), Optional.empty());
        }

        public ModLoadingState withTransition(IModStateTransition transition) {
            return new ModLoadingState(this.name, this.after, this.message != null ? this.message : ml -> "Processing transition " + this.name, this.size != null ? this.size : ModList::size, this.phase, Optional.empty(), Optional.of(transition));
        }

        public ModLoadingState withInline(Consumer<ModList> inline) {
            return new ModLoadingState(this.name, this.after, this.message != null ? this.message : ml -> "Processing work " + this.name, this.size != null ? this.size : ml -> 0, this.phase, Optional.of(inline), Optional.empty());
        }
    }
}

