/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.modlauncher.log;

import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.ITransformerActivity;
import cpw.mods.modlauncher.api.ITransformerAuditTrail;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import joptsimple.internal.Strings;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.impl.ExtendedStackTraceElement;
import org.apache.logging.log4j.core.impl.ThrowableProxy;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.PlainTextRenderer;
import org.apache.logging.log4j.core.pattern.TextRenderer;
import org.apache.logging.log4j.core.pattern.ThrowablePatternConverter;

@Plugin(name="TransformingThrowablePatternConverter", category="Converter")
@ConverterKeys(value={"tEx"})
public class TransformingThrowablePatternConverter
extends ThrowablePatternConverter {
    private static final String SUFFIXFLAG = "{}";

    protected TransformingThrowablePatternConverter(Configuration config, String[] options) {
        super("TransformingThrowable", "throwable", options, config);
    }

    public void format(LogEvent event, StringBuilder buf) {
        ThrowableProxy proxy = event.getThrownProxy();
        if (!this.options.anyLines()) {
            return;
        }
        if (proxy == null) {
            super.format(event, buf);
            return;
        }
        int len = buf.length();
        if (len > 0 && !Character.isWhitespace(buf.charAt(len - 1))) {
            buf.append(' ');
        }
        ITransformerAuditTrail trail = Optional.ofNullable(Launcher.INSTANCE).map(Launcher::environment).flatMap(env -> env.getProperty(IEnvironment.Keys.AUDITTRAIL.get())).orElse(null);
        String nl = this.options.getSeparator();
        TextRenderer renderer = this.options.getTextRenderer();
        String suffix = "";
        proxy.formatExtendedStackTraceTo(buf, this.options.getIgnorePackages(), renderer, suffix, nl);
        if (trail == null) {
            return;
        }
        TreeMap<String, List<String>> audit = new TreeMap<String, List<String>>();
        TransformingThrowablePatternConverter.buildAuditMap(trail, audit, proxy);
        this.line(buf, "Transformer Audit:");
        for (String cls : audit.keySet()) {
            this.line(buf, "  ", cls);
            for (String line : (List)audit.get(cls)) {
                this.line(buf, "    ", line);
            }
        }
        System.currentTimeMillis();
    }

    private void line(StringBuilder sb, String ... parts) {
        TextRenderer renderer = this.options.getTextRenderer();
        for (String pt : parts) {
            renderer.render(pt, sb, "Text");
        }
        renderer.render(this.options.getSeparator(), sb, "Text");
    }

    private static void buildAuditMap(ITransformerAuditTrail trail, Map<String, List<String>> map, ThrowableProxy proxy) {
        if (proxy == null) {
            return;
        }
        for (ExtendedStackTraceElement extendedStackTraceElement : proxy.getExtendedStackTrace()) {
            String cls = extendedStackTraceElement.getClassName();
            if (map.containsKey(cls)) continue;
            ArrayList<CallSite> lines = new ArrayList<CallSite>();
            for (ITransformerActivity activity : trail.getActivityFor(cls)) {
                lines.add((CallSite)((Object)(activity.getType().name() + ": " + String.join((CharSequence)":", activity.getContext()))));
            }
            if (lines.isEmpty()) continue;
            map.put(cls, lines);
        }
        for (ExtendedStackTraceElement extendedStackTraceElement : proxy.getSuppressedProxies()) {
            TransformingThrowablePatternConverter.buildAuditMap(trail, map, (ThrowableProxy)extendedStackTraceElement);
        }
        TransformingThrowablePatternConverter.buildAuditMap(trail, map, proxy.getCauseProxy());
    }

    public static TransformingThrowablePatternConverter newInstance(Configuration config, String[] options) {
        return new TransformingThrowablePatternConverter(config, options);
    }

    @Deprecated(forRemoval=true, since="10.2.2")
    public static String generateEnhancedStackTrace(Throwable throwable) {
        ThrowableProxy proxy = new ThrowableProxy(throwable);
        StringBuilder buf = new StringBuilder();
        ITransformerAuditTrail trail = Optional.ofNullable(Launcher.INSTANCE).map(Launcher::environment).flatMap(env -> env.getProperty(IEnvironment.Keys.AUDITTRAIL.get())).orElse(null);
        String nl = Strings.LINE_SEPARATOR;
        PlainTextRenderer renderer = PlainTextRenderer.getInstance();
        String suffix = "";
        proxy.formatExtendedStackTraceTo(buf, Collections.emptyList(), (TextRenderer)renderer, suffix, nl);
        if (trail != null) {
            TreeMap<String, List<String>> audit = new TreeMap<String, List<String>>();
            TransformingThrowablePatternConverter.buildAuditMap(trail, audit, proxy);
            buf.append("Transformer Audit:").append(nl);
            for (String cls : audit.keySet()) {
                buf.append("  ").append(cls).append(nl);
                for (String line : (List)audit.get(cls)) {
                    buf.append("    ").append(line).append(nl);
                }
            }
        }
        return buf.toString();
    }
}

