/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading.moddiscovery;

import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import net.minecraftforge.fml.loading.LogMarkers;
import net.minecraftforge.fml.loading.moddiscovery.ModClassVisitor;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.forgespi.language.IModLanguageProvider;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.jetbrains.annotations.ApiStatus;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.slf4j.Logger;

@ApiStatus.Internal
record Scanner(ModFile fileToScan, ModFileScanData result) {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final boolean DEBUG = LOGGER.isDebugEnabled(LogMarkers.SCAN);

    public Scanner(ModFile fileToScan) {
        this(fileToScan, new ModFileScanData());
    }

    public ModFileScanData scan() {
        this.result.addModFileInfo(this.fileToScan.getModFileInfo());
        this.fileToScan.scanFile(this::fileVisitor);
        List<IModLanguageProvider> loaders = this.fileToScan.getLoaders();
        if (loaders != null) {
            for (IModLanguageProvider loader : loaders) {
                if (DEBUG) {
                    LOGGER.debug("Scanning {} with language loader {}", (Object)this.fileToScan.getFilePath(), (Object)loader.name());
                }
                loader.getFileVisitor().accept(this.result);
            }
        }
        return this.result;
    }

    private void fileVisitor(Path path) {
        block8: {
            try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
                ModClassVisitor mcv = new ModClassVisitor();
                ClassReader cr = new ClassReader(in);
                cr.accept((ClassVisitor)mcv, 0);
                mcv.buildData(this.result.getClasses(), this.result.getAnnotations());
            }
            catch (IOException | IllegalArgumentException e) {
                if (!DEBUG) break block8;
                LOGGER.warn("Failed scanning {} path {}", (Object)this.fileToScan, (Object)path);
            }
        }
    }
}

