/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.advancements.critereon.FishingHookPredicate;
import net.minecraft.advancements.critereon.LightningBoltPredicate;
import net.minecraft.advancements.critereon.PlayerPredicate;
import net.minecraft.advancements.critereon.RaiderPredicate;
import net.minecraft.advancements.critereon.SheepPredicate;
import net.minecraft.advancements.critereon.SlimePredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.CatVariant;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.FrogVariant;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.Salmon;
import net.minecraft.world.entity.animal.TropicalFish;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.animal.WolfVariant;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.animal.horse.Variant;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.phys.Vec3;

public class EntitySubPredicates {
    public static final MapCodec<LightningBoltPredicate> LIGHTNING = EntitySubPredicates.register("lightning", LightningBoltPredicate.CODEC);
    public static final MapCodec<FishingHookPredicate> FISHING_HOOK = EntitySubPredicates.register("fishing_hook", FishingHookPredicate.CODEC);
    public static final MapCodec<PlayerPredicate> PLAYER = EntitySubPredicates.register("player", PlayerPredicate.CODEC);
    public static final MapCodec<SlimePredicate> SLIME = EntitySubPredicates.register("slime", SlimePredicate.CODEC);
    public static final MapCodec<RaiderPredicate> RAIDER = EntitySubPredicates.register("raider", RaiderPredicate.CODEC);
    public static final MapCodec<SheepPredicate> SHEEP = EntitySubPredicates.register("sheep", SheepPredicate.CODEC);
    public static final EntityVariantPredicateType<Axolotl.Variant> AXOLOTL = EntitySubPredicates.register("axolotl", EntityVariantPredicateType.create(Axolotl.Variant.CODEC, $$0 -> {
        Optional<Object> optional;
        if ($$0 instanceof Axolotl) {
            Axolotl $$1 = (Axolotl)$$0;
            optional = Optional.of($$1.getVariant());
        } else {
            optional = Optional.empty();
        }
        return optional;
    }));
    public static final EntityVariantPredicateType<Fox.Variant> FOX = EntitySubPredicates.register("fox", EntityVariantPredicateType.create(Fox.Variant.CODEC, $$0 -> {
        Optional<Object> optional;
        if ($$0 instanceof Fox) {
            Fox $$1 = (Fox)$$0;
            optional = Optional.of($$1.getVariant());
        } else {
            optional = Optional.empty();
        }
        return optional;
    }));
    public static final EntityVariantPredicateType<MushroomCow.Variant> MOOSHROOM = EntitySubPredicates.register("mooshroom", EntityVariantPredicateType.create(MushroomCow.Variant.CODEC, $$0 -> {
        Optional<Object> optional;
        if ($$0 instanceof MushroomCow) {
            MushroomCow $$1 = (MushroomCow)$$0;
            optional = Optional.of($$1.getVariant());
        } else {
            optional = Optional.empty();
        }
        return optional;
    }));
    public static final EntityVariantPredicateType<Rabbit.Variant> RABBIT = EntitySubPredicates.register("rabbit", EntityVariantPredicateType.create(Rabbit.Variant.CODEC, $$0 -> {
        Optional<Object> optional;
        if ($$0 instanceof Rabbit) {
            Rabbit $$1 = (Rabbit)$$0;
            optional = Optional.of($$1.getVariant());
        } else {
            optional = Optional.empty();
        }
        return optional;
    }));
    public static final EntityVariantPredicateType<Variant> HORSE = EntitySubPredicates.register("horse", EntityVariantPredicateType.create(Variant.CODEC, $$0 -> {
        Optional<Object> optional;
        if ($$0 instanceof Horse) {
            Horse $$1 = (Horse)$$0;
            optional = Optional.of($$1.getVariant());
        } else {
            optional = Optional.empty();
        }
        return optional;
    }));
    public static final EntityVariantPredicateType<Llama.Variant> LLAMA = EntitySubPredicates.register("llama", EntityVariantPredicateType.create(Llama.Variant.CODEC, $$0 -> {
        Optional<Object> optional;
        if ($$0 instanceof Llama) {
            Llama $$1 = (Llama)$$0;
            optional = Optional.of($$1.getVariant());
        } else {
            optional = Optional.empty();
        }
        return optional;
    }));
    public static final EntityVariantPredicateType<VillagerType> VILLAGER = EntitySubPredicates.register("villager", EntityVariantPredicateType.create(BuiltInRegistries.VILLAGER_TYPE.byNameCodec(), $$0 -> {
        Optional<Object> optional;
        if ($$0 instanceof VillagerDataHolder) {
            VillagerDataHolder $$1 = (VillagerDataHolder)((Object)$$0);
            optional = Optional.of($$1.getVariant());
        } else {
            optional = Optional.empty();
        }
        return optional;
    }));
    public static final EntityVariantPredicateType<Parrot.Variant> PARROT = EntitySubPredicates.register("parrot", EntityVariantPredicateType.create(Parrot.Variant.CODEC, $$0 -> {
        Optional<Object> optional;
        if ($$0 instanceof Parrot) {
            Parrot $$1 = (Parrot)$$0;
            optional = Optional.of($$1.getVariant());
        } else {
            optional = Optional.empty();
        }
        return optional;
    }));
    public static final EntityVariantPredicateType<Salmon.Variant> SALMON = EntitySubPredicates.register("salmon", EntityVariantPredicateType.create(Salmon.Variant.CODEC, $$0 -> {
        Optional<Object> optional;
        if ($$0 instanceof Salmon) {
            Salmon $$1 = (Salmon)$$0;
            optional = Optional.of($$1.getVariant());
        } else {
            optional = Optional.empty();
        }
        return optional;
    }));
    public static final EntityVariantPredicateType<TropicalFish.Pattern> TROPICAL_FISH = EntitySubPredicates.register("tropical_fish", EntityVariantPredicateType.create(TropicalFish.Pattern.CODEC, $$0 -> {
        Optional<Object> optional;
        if ($$0 instanceof TropicalFish) {
            TropicalFish $$1 = (TropicalFish)$$0;
            optional = Optional.of($$1.getVariant());
        } else {
            optional = Optional.empty();
        }
        return optional;
    }));
    public static final EntityHolderVariantPredicateType<PaintingVariant> PAINTING = EntitySubPredicates.register("painting", EntityHolderVariantPredicateType.create(Registries.PAINTING_VARIANT, $$0 -> {
        Optional<Object> optional;
        if ($$0 instanceof Painting) {
            Painting $$1 = (Painting)$$0;
            optional = Optional.of($$1.getVariant());
        } else {
            optional = Optional.empty();
        }
        return optional;
    }));
    public static final EntityHolderVariantPredicateType<CatVariant> CAT = EntitySubPredicates.register("cat", EntityHolderVariantPredicateType.create(Registries.CAT_VARIANT, $$0 -> {
        Optional<Object> optional;
        if ($$0 instanceof Cat) {
            Cat $$1 = (Cat)$$0;
            optional = Optional.of($$1.getVariant());
        } else {
            optional = Optional.empty();
        }
        return optional;
    }));
    public static final EntityHolderVariantPredicateType<FrogVariant> FROG = EntitySubPredicates.register("frog", EntityHolderVariantPredicateType.create(Registries.FROG_VARIANT, $$0 -> {
        Optional<Object> optional;
        if ($$0 instanceof Frog) {
            Frog $$1 = (Frog)$$0;
            optional = Optional.of($$1.getVariant());
        } else {
            optional = Optional.empty();
        }
        return optional;
    }));
    public static final EntityHolderVariantPredicateType<WolfVariant> WOLF = EntitySubPredicates.register("wolf", EntityHolderVariantPredicateType.create(Registries.WOLF_VARIANT, $$0 -> {
        Optional<Object> optional;
        if ($$0 instanceof Wolf) {
            Wolf $$1 = (Wolf)$$0;
            optional = Optional.of($$1.getVariant());
        } else {
            optional = Optional.empty();
        }
        return optional;
    }));

    private static <T extends EntitySubPredicate> MapCodec<T> register(String $$0, MapCodec<T> $$1) {
        return Registry.register(BuiltInRegistries.ENTITY_SUB_PREDICATE_TYPE, $$0, $$1);
    }

    private static <V> EntityVariantPredicateType<V> register(String $$0, EntityVariantPredicateType<V> $$1) {
        Registry.register(BuiltInRegistries.ENTITY_SUB_PREDICATE_TYPE, $$0, $$1.codec);
        return $$1;
    }

    private static <V> EntityHolderVariantPredicateType<V> register(String $$0, EntityHolderVariantPredicateType<V> $$1) {
        Registry.register(BuiltInRegistries.ENTITY_SUB_PREDICATE_TYPE, $$0, $$1.codec);
        return $$1;
    }

    public static MapCodec<? extends EntitySubPredicate> bootstrap(Registry<MapCodec<? extends EntitySubPredicate>> $$0) {
        return LIGHTNING;
    }

    public static EntitySubPredicate catVariant(Holder<CatVariant> $$0) {
        return CAT.createPredicate(HolderSet.direct($$0));
    }

    public static EntitySubPredicate frogVariant(Holder<FrogVariant> $$0) {
        return FROG.createPredicate(HolderSet.direct($$0));
    }

    public static EntitySubPredicate wolfVariant(HolderSet<WolfVariant> $$0) {
        return WOLF.createPredicate($$0);
    }

    public static class EntityVariantPredicateType<V> {
        final MapCodec<Instance> codec;
        final Function<Entity, Optional<V>> getter;

        public static <V> EntityVariantPredicateType<V> create(Registry<V> $$0, Function<Entity, Optional<V>> $$1) {
            return new EntityVariantPredicateType<V>($$0.byNameCodec(), $$1);
        }

        public static <V> EntityVariantPredicateType<V> create(Codec<V> $$0, Function<Entity, Optional<V>> $$1) {
            return new EntityVariantPredicateType<V>($$0, $$1);
        }

        public EntityVariantPredicateType(Codec<V> $$0, Function<Entity, Optional<V>> $$12) {
            this.getter = $$12;
            this.codec = RecordCodecBuilder.mapCodec($$1 -> $$1.group((App)$$0.fieldOf("variant").forGetter($$0 -> $$0.variant)).apply((Applicative)$$1, $$0 -> new Instance($$0)));
        }

        public EntitySubPredicate createPredicate(V $$0) {
            return new Instance($$0);
        }

        class Instance
        implements EntitySubPredicate {
            final V variant;

            Instance(V $$0) {
                this.variant = $$0;
            }

            public MapCodec<Instance> codec() {
                return EntityVariantPredicateType.this.codec;
            }

            @Override
            public boolean matches(Entity $$0, ServerLevel $$1, @Nullable Vec3 $$2) {
                return EntityVariantPredicateType.this.getter.apply($$0).filter(this.variant::equals).isPresent();
            }
        }
    }

    public static class EntityHolderVariantPredicateType<V> {
        final MapCodec<Instance> codec;
        final Function<Entity, Optional<Holder<V>>> getter;

        public static <V> EntityHolderVariantPredicateType<V> create(ResourceKey<? extends Registry<V>> $$0, Function<Entity, Optional<Holder<V>>> $$1) {
            return new EntityHolderVariantPredicateType<V>($$0, $$1);
        }

        public EntityHolderVariantPredicateType(ResourceKey<? extends Registry<V>> $$0, Function<Entity, Optional<Holder<V>>> $$12) {
            this.getter = $$12;
            this.codec = RecordCodecBuilder.mapCodec($$1 -> $$1.group((App)RegistryCodecs.homogeneousList($$0).fieldOf("variant").forGetter($$0 -> $$0.variants)).apply((Applicative)$$1, $$0 -> new Instance($$0)));
        }

        public EntitySubPredicate createPredicate(HolderSet<V> $$0) {
            return new Instance($$0);
        }

        class Instance
        implements EntitySubPredicate {
            final HolderSet<V> variants;

            Instance(HolderSet<V> $$0) {
                this.variants = $$0;
            }

            public MapCodec<Instance> codec() {
                return EntityHolderVariantPredicateType.this.codec;
            }

            @Override
            public boolean matches(Entity $$0, ServerLevel $$1, @Nullable Vec3 $$2) {
                return EntityHolderVariantPredicateType.this.getter.apply($$0).filter(this.variants::contains).isPresent();
            }
        }
    }
}

