/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class ARGB {
    public static int alpha(int $$0) {
        return $$0 >>> 24;
    }

    public static int red(int $$0) {
        return $$0 >> 16 & 0xFF;
    }

    public static int green(int $$0) {
        return $$0 >> 8 & 0xFF;
    }

    public static int blue(int $$0) {
        return $$0 & 0xFF;
    }

    public static int color(int $$0, int $$1, int $$2, int $$3) {
        return $$0 << 24 | $$1 << 16 | $$2 << 8 | $$3;
    }

    public static int color(int $$0, int $$1, int $$2) {
        return ARGB.color(255, $$0, $$1, $$2);
    }

    public static int color(Vec3 $$0) {
        return ARGB.color(ARGB.as8BitChannel((float)$$0.x()), ARGB.as8BitChannel((float)$$0.y()), ARGB.as8BitChannel((float)$$0.z()));
    }

    public static int multiply(int $$0, int $$1) {
        if ($$0 == -1) {
            return $$1;
        }
        if ($$1 == -1) {
            return $$0;
        }
        return ARGB.color(ARGB.alpha($$0) * ARGB.alpha($$1) / 255, ARGB.red($$0) * ARGB.red($$1) / 255, ARGB.green($$0) * ARGB.green($$1) / 255, ARGB.blue($$0) * ARGB.blue($$1) / 255);
    }

    public static int scaleRGB(int $$0, float $$1) {
        return ARGB.scaleRGB($$0, $$1, $$1, $$1);
    }

    public static int scaleRGB(int $$0, float $$1, float $$2, float $$3) {
        return ARGB.color(ARGB.alpha($$0), Math.clamp((long)((int)((float)ARGB.red($$0) * $$1)), 0, 255), Math.clamp((long)((int)((float)ARGB.green($$0) * $$2)), 0, 255), Math.clamp((long)((int)((float)ARGB.blue($$0) * $$3)), 0, 255));
    }

    public static int scaleRGB(int $$0, int $$1) {
        return ARGB.color(ARGB.alpha($$0), Math.clamp((long)ARGB.red($$0) * (long)$$1 / 255L, 0, 255), Math.clamp((long)ARGB.green($$0) * (long)$$1 / 255L, 0, 255), Math.clamp((long)ARGB.blue($$0) * (long)$$1 / 255L, 0, 255));
    }

    public static int greyscale(int $$0) {
        int $$1 = (int)((float)ARGB.red($$0) * 0.3f + (float)ARGB.green($$0) * 0.59f + (float)ARGB.blue($$0) * 0.11f);
        return ARGB.color($$1, $$1, $$1);
    }

    public static int lerp(float $$0, int $$1, int $$2) {
        int $$3 = Mth.lerpInt($$0, ARGB.alpha($$1), ARGB.alpha($$2));
        int $$4 = Mth.lerpInt($$0, ARGB.red($$1), ARGB.red($$2));
        int $$5 = Mth.lerpInt($$0, ARGB.green($$1), ARGB.green($$2));
        int $$6 = Mth.lerpInt($$0, ARGB.blue($$1), ARGB.blue($$2));
        return ARGB.color($$3, $$4, $$5, $$6);
    }

    public static int opaque(int $$0) {
        return $$0 | 0xFF000000;
    }

    public static int transparent(int $$0) {
        return $$0 & 0xFFFFFF;
    }

    public static int color(int $$0, int $$1) {
        return $$0 << 24 | $$1 & 0xFFFFFF;
    }

    public static int white(float $$0) {
        return ARGB.as8BitChannel($$0) << 24 | 0xFFFFFF;
    }

    public static int colorFromFloat(float $$0, float $$1, float $$2, float $$3) {
        return ARGB.color(ARGB.as8BitChannel($$0), ARGB.as8BitChannel($$1), ARGB.as8BitChannel($$2), ARGB.as8BitChannel($$3));
    }

    public static Vector3f vector3fFromRGB24(int $$0) {
        float $$1 = (float)ARGB.red($$0) / 255.0f;
        float $$2 = (float)ARGB.green($$0) / 255.0f;
        float $$3 = (float)ARGB.blue($$0) / 255.0f;
        return new Vector3f($$1, $$2, $$3);
    }

    public static int average(int $$0, int $$1) {
        return ARGB.color((ARGB.alpha($$0) + ARGB.alpha($$1)) / 2, (ARGB.red($$0) + ARGB.red($$1)) / 2, (ARGB.green($$0) + ARGB.green($$1)) / 2, (ARGB.blue($$0) + ARGB.blue($$1)) / 2);
    }

    public static int as8BitChannel(float $$0) {
        return Mth.floor($$0 * 255.0f);
    }

    public static float from8BitChannel(int $$0) {
        return (float)$$0 / 255.0f;
    }

    public static int toABGR(int $$0) {
        return $$0 & 0xFF00FF00 | ($$0 & 0xFF0000) >> 16 | ($$0 & 0xFF) << 16;
    }

    public static int fromABGR(int $$0) {
        return ARGB.toABGR($$0);
    }
}

