/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.equipment.ArmorMaterial;

public class AnimalArmorItem
extends Item {
    private final BodyType bodyType;

    public AnimalArmorItem(ArmorMaterial $$0, BodyType $$1, Item.Properties $$2) {
        super($$0.animalProperties($$2, $$1.allowedEntities));
        this.bodyType = $$1;
    }

    public AnimalArmorItem(ArmorMaterial $$0, BodyType $$1, Holder<SoundEvent> $$2, boolean $$3, Item.Properties $$4) {
        super($$0.animalProperties($$4, $$2, $$3, $$1.allowedEntities));
        this.bodyType = $$1;
    }

    @Override
    public SoundEvent getBreakingSound() {
        return this.bodyType.breakingSound;
    }

    public static enum BodyType {
        EQUESTRIAN(SoundEvents.ITEM_BREAK, EntityType.HORSE),
        CANINE(SoundEvents.WOLF_ARMOR_BREAK, EntityType.WOLF);

        final SoundEvent breakingSound;
        final HolderSet<EntityType<?>> allowedEntities;

        private BodyType(SoundEvent $$0, EntityType<?> ... $$1) {
            this.breakingSound = $$0;
            this.allowedEntities = HolderSet.direct(EntityType::builtInRegistryHolder, $$1);
        }
    }
}

