/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.GlowItemFrame;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;

public class HangingEntityItem
extends Item {
    private static final Component TOOLTIP_RANDOM_VARIANT = Component.translatable("painting.random").withStyle(ChatFormatting.GRAY);
    private final EntityType<? extends HangingEntity> type;

    public HangingEntityItem(EntityType<? extends HangingEntity> $$0, Item.Properties $$1) {
        super($$1);
        this.type = $$0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public InteractionResult useOn(UseOnContext $$0) {
        void $$11;
        BlockPos $$1 = $$0.getClickedPos();
        Direction $$2 = $$0.getClickedFace();
        BlockPos $$3 = $$1.relative($$2);
        Player $$4 = $$0.getPlayer();
        ItemStack $$5 = $$0.getItemInHand();
        if ($$4 != null && !this.mayPlace($$4, $$2, $$5, $$3)) {
            return InteractionResult.FAIL;
        }
        Level $$6 = $$0.getLevel();
        if (this.type == EntityType.PAINTING) {
            Optional<Painting> $$7 = Painting.create($$6, $$3, $$2);
            if ($$7.isEmpty()) {
                return InteractionResult.CONSUME;
            }
            HangingEntity $$8 = $$7.get();
        } else if (this.type == EntityType.ITEM_FRAME) {
            ItemFrame $$9 = new ItemFrame($$6, $$3, $$2);
        } else if (this.type == EntityType.GLOW_ITEM_FRAME) {
            GlowItemFrame $$10 = new GlowItemFrame($$6, $$3, $$2);
        } else {
            return InteractionResult.SUCCESS;
        }
        CustomData $$12 = $$5.getOrDefault(DataComponents.ENTITY_DATA, CustomData.EMPTY);
        if (!$$12.isEmpty()) {
            EntityType.updateCustomEntityTag($$6, $$4, (Entity)$$11, $$12);
        }
        if ($$11.survives()) {
            if (!$$6.isClientSide) {
                $$11.playPlacementSound();
                $$6.gameEvent((Entity)$$4, GameEvent.ENTITY_PLACE, $$11.position());
                $$6.addFreshEntity((Entity)$$11);
            }
            $$5.shrink(1);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.CONSUME;
    }

    protected boolean mayPlace(Player $$0, Direction $$1, ItemStack $$2, BlockPos $$3) {
        return !$$1.getAxis().isVertical() && $$0.mayUseItemAt($$3, $$1, $$2);
    }

    @Override
    public void appendHoverText(ItemStack $$0, Item.TooltipContext $$12, List<Component> $$2, TooltipFlag $$3) {
        super.appendHoverText($$0, $$12, $$2, $$3);
        HolderLookup.Provider $$4 = $$12.registries();
        if ($$4 != null && this.type == EntityType.PAINTING) {
            CustomData $$5 = $$0.getOrDefault(DataComponents.ENTITY_DATA, CustomData.EMPTY);
            if (!$$5.isEmpty()) {
                $$5.read((DynamicOps<Tag>)$$4.createSerializationContext(NbtOps.INSTANCE), Painting.VARIANT_MAP_CODEC).result().ifPresentOrElse($$1 -> {
                    ((PaintingVariant)$$1.value()).title().ifPresent($$2::add);
                    ((PaintingVariant)$$1.value()).author().ifPresent($$2::add);
                    $$2.add(Component.translatable("painting.dimensions", ((PaintingVariant)$$1.value()).width(), ((PaintingVariant)$$1.value()).height()));
                }, () -> $$2.add(TOOLTIP_RANDOM_VARIANT));
            } else if ($$3.isCreative()) {
                $$2.add(TOOLTIP_RANDOM_VARIANT);
            }
        }
    }
}

