/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.entity.player.StackedItemContents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;

public class PlacementInfo {
    public static final PlacementInfo NOT_PLACEABLE = new PlacementInfo(List.of(), List.of(), List.of());
    private final List<Ingredient> ingredients;
    private final List<StackedContents.IngredientInfo<Holder<Item>>> unpackedIngredients;
    private final List<Optional<SlotInfo>> slotInfo;

    private PlacementInfo(List<Ingredient> $$0, List<StackedContents.IngredientInfo<Holder<Item>>> $$1, List<Optional<SlotInfo>> $$2) {
        this.ingredients = $$0;
        this.unpackedIngredients = $$1;
        this.slotInfo = $$2;
    }

    public static StackedContents.IngredientInfo<Holder<Item>> ingredientToContents(Ingredient $$0) {
        return StackedItemContents.convertIngredientContents($$0.items().stream());
    }

    public static PlacementInfo create(Ingredient $$0) {
        if ($$0.items().isEmpty()) {
            return NOT_PLACEABLE;
        }
        StackedContents.IngredientInfo<Holder<Item>> $$1 = PlacementInfo.ingredientToContents($$0);
        SlotInfo $$2 = new SlotInfo(0);
        return new PlacementInfo(List.of($$0), List.of($$1), List.of(Optional.of($$2)));
    }

    public static PlacementInfo createFromOptionals(List<Optional<Ingredient>> $$0) {
        int $$1 = $$0.size();
        ArrayList<Ingredient> $$2 = new ArrayList<Ingredient>($$1);
        ArrayList<StackedContents.IngredientInfo<Holder<Item>>> $$3 = new ArrayList<StackedContents.IngredientInfo<Holder<Item>>>($$1);
        ArrayList<Optional<SlotInfo>> $$4 = new ArrayList<Optional<SlotInfo>>($$1);
        int $$5 = 0;
        for (Optional<Ingredient> $$6 : $$0) {
            if ($$6.isPresent()) {
                Ingredient $$7 = $$6.get();
                if ($$7.items().isEmpty()) {
                    return NOT_PLACEABLE;
                }
                $$2.add($$7);
                $$3.add(PlacementInfo.ingredientToContents($$7));
                $$4.add(Optional.of(new SlotInfo($$5++)));
                continue;
            }
            $$4.add(Optional.empty());
        }
        return new PlacementInfo($$2, $$3, $$4);
    }

    public static PlacementInfo create(List<Ingredient> $$0) {
        int $$1 = $$0.size();
        ArrayList<StackedContents.IngredientInfo<Holder<Item>>> $$2 = new ArrayList<StackedContents.IngredientInfo<Holder<Item>>>($$1);
        ArrayList<Optional<SlotInfo>> $$3 = new ArrayList<Optional<SlotInfo>>($$1);
        for (int $$4 = 0; $$4 < $$1; ++$$4) {
            Ingredient $$5 = $$0.get($$4);
            if ($$5.items().isEmpty()) {
                return NOT_PLACEABLE;
            }
            $$2.add(PlacementInfo.ingredientToContents($$5));
            $$3.add(Optional.of(new SlotInfo($$4)));
        }
        return new PlacementInfo($$0, $$2, $$3);
    }

    public List<Optional<SlotInfo>> slotInfo() {
        return this.slotInfo;
    }

    public List<Ingredient> ingredients() {
        return this.ingredients;
    }

    public List<StackedContents.IngredientInfo<Holder<Item>>> unpackedIngredients() {
        return this.unpackedIngredients;
    }

    public boolean isImpossibleToPlace() {
        return this.slotInfo.isEmpty();
    }

    public record SlotInfo(int placerOutputPosition) {
    }
}

