/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.CreakingHeartBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;

public class CreakingHeartBlock
extends BaseEntityBlock {
    public static final MapCodec<CreakingHeartBlock> CODEC = CreakingHeartBlock.simpleCodec(CreakingHeartBlock::new);
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.AXIS;
    public static final EnumProperty<CreakingHeartState> CREAKING = BlockStateProperties.CREAKING;

    public MapCodec<CreakingHeartBlock> codec() {
        return CODEC;
    }

    protected CreakingHeartBlock(BlockBehaviour.Properties $$0) {
        super($$0);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue(AXIS, Direction.Axis.Y)).setValue(CREAKING, CreakingHeartState.DISABLED));
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos $$0, BlockState $$1) {
        return new CreakingHeartBlockEntity($$0, $$1);
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level $$0, BlockState $$1, BlockEntityType<T> $$2) {
        if ($$0.isClientSide) {
            return null;
        }
        if ($$1.getValue(CREAKING) != CreakingHeartState.DISABLED) {
            return CreakingHeartBlock.createTickerHelper($$2, BlockEntityType.CREAKING_HEART, CreakingHeartBlockEntity::serverTick);
        }
        return null;
    }

    public static boolean canSummonCreaking(Level $$0) {
        return $$0.dimensionType().natural() && $$0.isNight();
    }

    @Override
    public void animateTick(BlockState $$0, Level $$1, BlockPos $$2, RandomSource $$3) {
        if (!CreakingHeartBlock.canSummonCreaking($$1)) {
            return;
        }
        if ($$0.getValue(CREAKING) == CreakingHeartState.DISABLED) {
            return;
        }
        if ($$3.nextInt(16) == 0 && CreakingHeartBlock.isSurroundedByLogs($$1, $$2)) {
            $$1.playLocalSound($$2.getX(), $$2.getY(), $$2.getZ(), SoundEvents.CREAKING_HEART_IDLE, SoundSource.BLOCKS, 1.0f, 1.0f, false);
        }
    }

    @Override
    protected BlockState updateShape(BlockState $$0, LevelReader $$1, ScheduledTickAccess $$2, BlockPos $$3, Direction $$4, BlockPos $$5, BlockState $$6, RandomSource $$7) {
        BlockState $$8 = super.updateShape($$0, $$1, $$2, $$3, $$4, $$5, $$6, $$7);
        return CreakingHeartBlock.updateState($$8, $$1, $$3);
    }

    private static BlockState updateState(BlockState $$0, LevelReader $$1, BlockPos $$2) {
        boolean $$3 = CreakingHeartBlock.hasRequiredLogs($$0, $$1, $$2);
        CreakingHeartState $$4 = $$0.getValue(CREAKING);
        if ($$3 && $$4 == CreakingHeartState.DISABLED) {
            return (BlockState)$$0.setValue(CREAKING, CreakingHeartState.DORMANT);
        }
        return $$0;
    }

    public static boolean hasRequiredLogs(BlockState $$0, LevelReader $$1, BlockPos $$2) {
        Direction.Axis $$3 = $$0.getValue(AXIS);
        for (Direction $$4 : $$3.getDirections()) {
            BlockState $$5 = $$1.getBlockState($$2.relative($$4));
            if ($$5.is(BlockTags.PALE_OAK_LOGS) && $$5.getValue(AXIS) == $$3) continue;
            return false;
        }
        return true;
    }

    private static boolean isSurroundedByLogs(LevelAccessor $$0, BlockPos $$1) {
        for (Direction $$2 : Direction.values()) {
            BlockPos $$3 = $$1.relative($$2);
            BlockState $$4 = $$0.getBlockState($$3);
            if ($$4.is(BlockTags.PALE_OAK_LOGS)) continue;
            return false;
        }
        return true;
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext $$0) {
        return CreakingHeartBlock.updateState((BlockState)this.defaultBlockState().setValue(AXIS, $$0.getClickedFace().getAxis()), $$0.getLevel(), $$0.getClickedPos());
    }

    @Override
    protected RenderShape getRenderShape(BlockState $$0) {
        return RenderShape.MODEL;
    }

    @Override
    protected BlockState rotate(BlockState $$0, Rotation $$1) {
        return RotatedPillarBlock.rotatePillar($$0, $$1);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> $$0) {
        $$0.add(AXIS, CREAKING);
    }

    @Override
    protected void onRemove(BlockState $$0, Level $$1, BlockPos $$2, BlockState $$3, boolean $$4) {
        BlockEntity blockEntity = $$1.getBlockEntity($$2);
        if (blockEntity instanceof CreakingHeartBlockEntity) {
            CreakingHeartBlockEntity $$5 = (CreakingHeartBlockEntity)blockEntity;
            $$5.removeProtector(null);
        }
        super.onRemove($$0, $$1, $$2, $$3, $$4);
    }

    @Override
    public BlockState playerWillDestroy(Level $$0, BlockPos $$1, BlockState $$2, Player $$3) {
        BlockEntity blockEntity = $$0.getBlockEntity($$1);
        if (blockEntity instanceof CreakingHeartBlockEntity) {
            CreakingHeartBlockEntity $$4 = (CreakingHeartBlockEntity)blockEntity;
            $$4.removeProtector($$3.damageSources().playerAttack($$3));
        }
        return super.playerWillDestroy($$0, $$1, $$2, $$3);
    }

    @Override
    protected boolean hasAnalogOutputSignal(BlockState $$0) {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected int getAnalogOutputSignal(BlockState $$0, Level $$1, BlockPos $$2) {
        void $$4;
        if ($$0.getValue(CREAKING) != CreakingHeartState.ACTIVE) {
            return 0;
        }
        BlockEntity blockEntity = $$1.getBlockEntity($$2);
        if (!(blockEntity instanceof CreakingHeartBlockEntity)) {
            return 0;
        }
        CreakingHeartBlockEntity $$3 = (CreakingHeartBlockEntity)blockEntity;
        return $$4.getAnalogOutputSignal();
    }

    public static enum CreakingHeartState implements StringRepresentable
    {
        DISABLED("disabled"),
        DORMANT("dormant"),
        ACTIVE("active");

        private final String name;

        private CreakingHeartState(String $$0) {
            this.name = $$0;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }
    }
}

