/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.config.category;

import ninja.leaping.configurate.objectmapping.Setting;
import ninja.leaping.configurate.objectmapping.serialize.ConfigSerializable;
import org.spongepowered.common.config.category.ConfigCategory;

@ConfigSerializable
public class ExploitCategory
extends ConfigCategory {
    @Setting(value="prevent-creative-itemstack-name-exploit", comment="Prevents an exploit in which the client sends a packet with the itemstack name\nexceeding the string limit.")
    private boolean preventItemNameOverflow = true;
    @Setting(value="mark-chunks-as-dirty-on-entity-list-modification", comment="Enables forcing chunks to save when an entity is added or removed from said chunk.\nThis is a partial fix for some exploits using vehicles.\nSee https://github.com/PaperMC/Paper/blob/fd1bd5223a461b6d98280bb8f2d67280a30dd24a/Spigot-Server-Patches/0306-Mark-chunk-dirty-anytime-entities-change-to-guarante.patch\n(Only affects SpongeVanilla)")
    private boolean chunksAlwaysSave = true;
    @Setting(value="update-tracked-chunk-on-entity-move", comment="Enables forcing a chunk-tracking refresh on entity movement.\nThis enables a guarantee that the entity is tracked in the proper chunk when moving.\nSee https://github.com/PaperMC/Paper/blob/fd1bd5223a461b6d98280bb8f2d67280a30dd24a/Spigot-Server-Patches/0315-Always-process-chunk-registration-after-moving.patch\n(Only affects SpongeVanilla)")
    private boolean chunkRegistrationOnMove = true;
    @Setting(value="load-chunk-on-position-set", comment="Enables forcing a chunk load when an entity position is set.\nUsually due to teleportation, vehicle movement etc. can a position lead an entity to no longer exist\nwithin it's currently marked and tracked chunk. This will enable that chunk for the position is loaded.\nPart of several exploits.\nSee https://github.com/PaperMC/Paper/blob/fd1bd5223a461b6d98280bb8f2d67280a30dd24a/Spigot-Server-Patches/0335-Ensure-chunks-are-always-loaded-on-hard-position-set.patch\n(Only affects SpongeVanilla)")
    private boolean chunkLoadOnPosition = true;
    @Setting(value="sync-player-positions-for-vehicle-movement", comment="Enables forcing updates to the player's location on vehicle movement.\nThis is partially required to update the server's understanding of where the player exists,\nand allows chunk loading issues to be avoided with laggy connections and/or hack clients.\nSee https://github.com/PaperMC/Paper/blob/fd1bd5223a461b6d98280bb8f2d67280a30dd24a/Spigot-Server-Patches/0378-Sync-Player-Position-to-Vehicles.patch\n(Only affects SpongeVanilla)")
    private boolean playerVehicleSync = true;
    @Setting(value="filter-invalid-entities-on-chunk-save", comment="Enables filtering invalid entities when a chunk is being saved\nsuch that the entity that does not \"belong\" in the saving chunk will not be saved,\nand forced an update to the world's tracked entity lists for chunks.\nSee https://github.com/PaperMC/Paper/blob/fd1bd5223a461b6d98280bb8f2d67280a30dd24a/Spigot-Server-Patches/0311-Prevent-Saving-Bad-entities-to-chunks.patch")
    private boolean chunkSaveFiltersEntities = true;
    @Setting(value="limit-book-size", comment="Limits the size of a book that can be sent by the client.\nSee https://github.com/PaperMC/Paper/blob/f8058a8187da9f6185d95bb786783e12c79c8b18/Spigot-Server-Patches/0403-Book-Size-Limits.patch\n(Only affects SpongeVanilla)")
    private boolean limitBookSize = true;
    @Setting(value="max-book-page-size", comment="If 'limit-book-size' is enabled, controls the maximum size of a book page")
    private int maxBookPageSize = 2560;
    @Setting(value="book-size-total-multiplier", comment="If 'limit-book-size' is enabled, controls the multiplier applied to each book page size")
    private double bookSizeTotalMultiplier = 0.98;
    @Setting(value="check-unknown-slots-during-window-clicks", comment="If enabled, unknown slot clicks will trigger a log warning and disconnect of the offending player")
    private boolean checkUnknownSlotDuringWindowClicks = false;
    @Setting(value="check-slot-size-during-window-clicks", comment="If enabled, slot clicks that have ItemStacks larger than a certain size will trigger a log warning and disconnect of the offending player")
    private boolean checkSlotSizeDuringWindowClicks = false;
    @Setting(value="check-slot-click-counts-over-time", comment="If enabled, players submitting too many inventory slot packets will trigger a log warning and kick the offending player.")
    private boolean checkClickCounts = false;
    @Setting(value="slot-click-counts-before-kick", comment="If check-slot-click-counts-over-time is enabled, this will be the trigger point where any click packets in a tick over this amount will automatically trigger a kick of the offending player.")
    private int clickPacketsBeforeKick = 10;
    @Setting(value="max-slot-data-interaction", comment="If 'check-slot-and-size-during-window-clicks' is enabled, this is the max data a slot is allowed to be sent up from a client before the disconnect (in bytes)")
    private int maxSlotDataInteraction = 2700;
    @Setting(value="block-chat-message-exploit", comment="If enabled, blocks chat messages that can causeremote code execution exploits on the server and any connected clients.")
    private boolean blockHarmfulChatMessage = true;
    @Setting(value="block-h2-jndi-exploit", comment="If enabled, enables the patch to the H2 database driverthat blocks remote code execution exploits on the server.")
    private boolean blockH2JndiExploit = true;

    public boolean isPreventItemNameOverflow() {
        return this.preventItemNameOverflow;
    }

    public boolean changedChunksAlwaysSave() {
        return this.chunksAlwaysSave;
    }

    public boolean chunkLoadOnPosition() {
        return this.chunkLoadOnPosition;
    }

    public boolean chunkRefreshOnMove() {
        return this.chunkRegistrationOnMove;
    }

    public boolean playerSyncVehicle() {
        return this.playerVehicleSync;
    }

    public boolean chunkSaveFiltersEntities() {
        return this.chunkSaveFiltersEntities;
    }

    public boolean limitBookSize() {
        return this.limitBookSize;
    }

    public int getMaxBookPageSize() {
        return this.maxBookPageSize;
    }

    public double getBookSizeTotalMultiplier() {
        return this.bookSizeTotalMultiplier;
    }

    public boolean checkUnknownSlotDuringWindowClicks() {
        return this.checkUnknownSlotDuringWindowClicks;
    }

    public boolean checkSlotSizeDuringWindowClicks() {
        return this.checkSlotSizeDuringWindowClicks;
    }

    public boolean checkSlotClickCounts() {
        return this.checkClickCounts;
    }

    public int slotClicksBeforeKick() {
        return this.clickPacketsBeforeKick;
    }

    public int getMaxSlotDataInteraction() {
        return this.maxSlotDataInteraction;
    }

    public boolean checkSlotOrSizeDuringWindowClicks() {
        return this.checkSlotSizeDuringWindowClicks || this.checkUnknownSlotDuringWindowClicks;
    }

    public boolean isBlockHarmfulChatMessage() {
        return this.blockHarmfulChatMessage;
    }

    public boolean isBlockH2JndiExploit() {
        return this.blockH2JndiExploit;
    }
}

