/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data.item;

import java.util.Optional;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagInt;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.item.ImmutableGenerationData;
import org.spongepowered.api.data.manipulator.mutable.item.GenerationData;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.MutableBoundedValue;
import org.spongepowered.common.data.manipulator.mutable.item.SpongeGenerationData;
import org.spongepowered.common.data.processor.common.AbstractItemSingleDataProcessor;
import org.spongepowered.common.data.value.SpongeValueFactory;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;

public final class GenerationDataProcessor
extends AbstractItemSingleDataProcessor<Integer, MutableBoundedValue<Integer>, GenerationData, ImmutableGenerationData> {
    public GenerationDataProcessor() {
        super((ItemStack stack) -> stack.func_77973_b().equals(Items.field_151164_bB), Keys.GENERATION);
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        return DataTransactionResult.failNoData();
    }

    @Override
    protected MutableBoundedValue<Integer> constructValue(Integer actualValue) {
        return SpongeValueFactory.boundedBuilder(Keys.GENERATION).actualValue(actualValue).defaultValue(0).minimum(0).maximum(3).build();
    }

    @Override
    protected boolean set(ItemStack stack, Integer value) {
        stack.func_77983_a("generation", (NBTBase)new NBTTagInt(value.intValue()));
        return true;
    }

    @Override
    protected Optional<Integer> getVal(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return Optional.empty();
        }
        return Optional.of(stack.func_77978_p().func_74762_e("generation"));
    }

    @Override
    protected ImmutableValue<Integer> constructImmutableValue(Integer value) {
        return ImmutableSpongeValue.cachedOf(Keys.GENERATION, 0, value);
    }

    @Override
    protected GenerationData createManipulator() {
        return new SpongeGenerationData();
    }
}

