/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data.item;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.ImmutablePotionEffectData;
import org.spongepowered.api.data.manipulator.mutable.PotionEffectData;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.ListValue;
import org.spongepowered.common.data.manipulator.mutable.SpongePotionEffectData;
import org.spongepowered.common.data.processor.common.AbstractItemSingleDataProcessor;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeListValue;
import org.spongepowered.common.data.value.mutable.SpongeListValue;

public class ItemPotionEffectDataProcessor
extends AbstractItemSingleDataProcessor<List<org.spongepowered.api.effect.potion.PotionEffect>, ListValue<org.spongepowered.api.effect.potion.PotionEffect>, PotionEffectData, ImmutablePotionEffectData> {
    public ItemPotionEffectDataProcessor() {
        super((ItemStack itemStack) -> itemStack.func_77973_b() == Items.field_151068_bn || itemStack.func_77973_b() == Items.field_185155_bH || itemStack.func_77973_b() == Items.field_185156_bI || itemStack.func_77973_b() == Items.field_185167_i, Keys.POTION_EFFECTS);
    }

    @Override
    protected boolean set(ItemStack dataHolder, List<org.spongepowered.api.effect.potion.PotionEffect> value) {
        if (!dataHolder.func_77942_o()) {
            dataHolder.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound mainCompound = dataHolder.func_77978_p();
        NBTTagList potionList = new NBTTagList();
        for (org.spongepowered.api.effect.potion.PotionEffect effect : value) {
            NBTTagCompound potionCompound = new NBTTagCompound();
            ((PotionEffect)effect).func_82719_a(potionCompound);
            potionList.func_74742_a((NBTBase)potionCompound);
        }
        mainCompound.func_74782_a("CustomPotionEffects", (NBTBase)potionList);
        return true;
    }

    @Override
    protected Optional<List<org.spongepowered.api.effect.potion.PotionEffect>> getVal(ItemStack dataHolder) {
        List effects = PotionUtils.func_185189_a((ItemStack)dataHolder);
        if (effects.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(effects);
    }

    @Override
    protected ImmutableValue<List<org.spongepowered.api.effect.potion.PotionEffect>> constructImmutableValue(List<org.spongepowered.api.effect.potion.PotionEffect> value) {
        return new ImmutableSpongeListValue<org.spongepowered.api.effect.potion.PotionEffect>(Keys.POTION_EFFECTS, ImmutableList.copyOf(value));
    }

    @Override
    protected ListValue<org.spongepowered.api.effect.potion.PotionEffect> constructValue(List<org.spongepowered.api.effect.potion.PotionEffect> actualValue) {
        return new SpongeListValue<org.spongepowered.api.effect.potion.PotionEffect>(Keys.POTION_EFFECTS, actualValue);
    }

    @Override
    protected PotionEffectData createManipulator() {
        return new SpongePotionEffectData();
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        if (!(container instanceof ItemStack)) {
            return DataTransactionResult.failNoData();
        }
        ItemStack itemStack = (ItemStack)container;
        Item item = itemStack.func_77973_b();
        if (item != Items.field_151068_bn) {
            return DataTransactionResult.failNoData();
        }
        Optional<List<org.spongepowered.api.effect.potion.PotionEffect>> currentEffects = this.getVal(itemStack);
        if (!itemStack.func_77942_o()) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        tagCompound.func_74782_a("CustomPotionEffects", (NBTBase)new NBTTagList());
        if (currentEffects.isPresent()) {
            return DataTransactionResult.successRemove(this.constructImmutableValue(currentEffects.get()));
        }
        return DataTransactionResult.successNoData();
    }
}

