/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.block;

import java.util.ArrayList;
import java.util.Collection;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.spawn.SpawnTypes;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.context.GeneralizedContext;
import org.spongepowered.common.event.tracking.phase.block.BlockPhaseState;

final class DispensePhaseState
extends BlockPhaseState {
    DispensePhaseState() {
    }

    @Override
    public GeneralizedContext createNewContext() {
        return (GeneralizedContext)((GeneralizedContext)((GeneralizedContext)super.createNewContext().addBlockCaptures()).addEntityCaptures()).addEntityDropCaptures();
    }

    @Override
    public void unwind(GeneralizedContext phaseContext) {
        TrackingUtil.processBlockCaptures(phaseContext);
        phaseContext.getCapturedItemsSupplier().acceptAndClearIfNotEmpty(items -> {
            Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.DISPENSE);
            SpongeCommonEventFactory.callDropItemDispense(items, phaseContext);
        });
        phaseContext.getCapturedEntitySupplier().acceptAndClearIfNotEmpty(entities -> {
            Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.DISPENSE);
            SpongeCommonEventFactory.callSpawnEntity(entities, phaseContext);
        });
        phaseContext.getBlockItemDropSupplier().acceptAndClearIfNotEmpty(drops -> drops.asMap().forEach((key, value) -> {
            Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.DROPPED_ITEM);
            SpongeCommonEventFactory.callDropItemDestruct(new ArrayList<Entity>((Collection<Entity>)value), phaseContext);
        }));
    }
}

