/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet.inventory;

import java.util.ArrayList;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayerMP;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.spawn.SpawnTypes;
import org.spongepowered.api.event.item.inventory.DropItemEvent;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.bridge.inventory.TrackedInventoryBridge;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.packet.inventory.BasicInventoryPacketState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.InventoryPacketContext;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;

public final class DropInventoryState
extends BasicInventoryPacketState {
    @Override
    public void unwind(InventoryPacketContext context) {
        EntityPlayerMP player = context.getPacketPlayer();
        ItemStack usedStack = context.getItemUsed();
        ItemStackSnapshot usedSnapshot = ItemStackUtil.snapshotOf(usedStack);
        Entity spongePlayer = (Entity)player;
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(spongePlayer);
            frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.DROPPED_ITEM);
            TrackingUtil.processBlockCaptures(context);
            context.getCapturedItemsSupplier().acceptAndClearIfNotEmpty(items -> {
                ArrayList<Entity> entities = new ArrayList<Entity>();
                for (EntityItem item : items) {
                    entities.add((Entity)item);
                }
                DropItemEvent.Dispense dropItemEvent = SpongeEventFactory.createDropItemEventDispense(Sponge.getCauseStackManager().getCurrentCause(), entities);
                SpongeImpl.postEvent(dropItemEvent);
                if (!dropItemEvent.isCancelled()) {
                    DropInventoryState.processSpawnedEntities(player, dropItemEvent);
                }
            });
            TrackedInventoryBridge mixinContainer = (TrackedInventoryBridge)player.field_71070_bA;
            mixinContainer.bridge$setCaptureInventory(false);
            mixinContainer.bridge$getCapturedSlotTransactions().clear();
        }
    }
}

